/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.util;

import fr.profi.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JPARepositoryUtils {
    public static final int MAX_BATCH_SIZE = 999;
    private static final Logger LOG = LoggerFactory.getLogger(JPARepositoryUtils.class);

    private JPARepositoryUtils() {
    }

    public static <R, P> List<R> executeInQueryAsBatch(TypedQuery<R> query, String paramName, Collection<P> paramValues) {
        if (query == null) {
            throw new IllegalArgumentException("Query is nul");
        }
        if (StringUtils.isEmpty((String)paramName)) {
            throw new IllegalArgumentException("Invalid paramName");
        }
        if (paramValues == null || paramValues.isEmpty()) {
            throw new IllegalArgumentException("Invalid paramValues collection");
        }
        ArrayList result = new ArrayList();
        ArrayList<P> paramValuesList = new ArrayList<P>(paramValues);
        int totalNParamValues = paramValuesList.size();
        int nBatches = (totalNParamValues + 999 - 1) / 999;
        for (int batch = 0; batch < nBatches; ++batch) {
            List paramsValuesSubList = paramValuesList.subList(batch * 999, Math.min((batch + 1) * 999, totalNParamValues));
            if (LOG.isTraceEnabled()) {
                LOG.trace("In Query parameters sub-List size : {}", (Object)paramsValuesSubList.size());
            }
            query.setParameter(paramName, paramsValuesSubList);
            result.addAll(query.getResultList());
        }
        return result;
    }
}

