/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.repository;

import fr.profi.util.StringUtils;
import fr.profi.util.ThreadLogger;
import fr.proline.core.orm.uds.ExternalDb;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.repository.ExternalDbRepository;
import fr.proline.repository.DatabaseConnectorFactory;
import fr.proline.repository.IDataStoreConnectorFactory;
import fr.proline.repository.IDatabaseConnector;
import fr.proline.repository.ProlineDatabaseType;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncachedDataStoreConnectorFactory
implements IDataStoreConnectorFactory {
    private static final String APP_NAME = "Proline";
    private static final Logger LOG = LoggerFactory.getLogger(UncachedDataStoreConnectorFactory.class);
    private static final UncachedDataStoreConnectorFactory UNIQUE_INSTANCE = new UncachedDataStoreConnectorFactory();
    private final Object m_managerLock = new Object();
    private IDatabaseConnector m_udsDbConnector;
    private final Map<Long, Map<Object, Object>> m_msiDbPropertiesMaps = new HashMap<Long, Map<Object, Object>>();
    private final Map<Long, Map<Object, Object>> m_lcMsDbPropertiesMaps = new HashMap<Long, Map<Object, Object>>();
    private String m_applicationName;

    protected UncachedDataStoreConnectorFactory() {
    }

    public static UncachedDataStoreConnectorFactory getInstance() {
        return UNIQUE_INSTANCE;
    }

    public void initialize(IDatabaseConnector udsDbConnector) {
        this.initialize(udsDbConnector, APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(IDatabaseConnector udsDbConnector, String applicationName) {
        Object object = this.m_managerLock;
        synchronized (object) {
            if (this.isInitialized()) {
                throw new IllegalStateException("UncachedDataStoreConnectorFactory ALREADY initialized");
            }
            if (udsDbConnector == null) {
                throw new UnsupportedOperationException("UdsDbConnector is null");
            }
            Thread currentThread = Thread.currentThread();
            if (!(currentThread.getUncaughtExceptionHandler() instanceof ThreadLogger)) {
                currentThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadLogger(LOG));
            }
            this.m_udsDbConnector = udsDbConnector;
            this.m_applicationName = applicationName;
        }
    }

    public void initialize(Map<Object, Object> udsDbProperties) {
        this.initialize(udsDbProperties, APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Map<Object, Object> udsDbProperties, String applicationName) {
        Object object = this.m_managerLock;
        synchronized (object) {
            if (this.isInitialized()) {
                throw new IllegalStateException("UncachedDataStoreConnectorFactory ALREADY initialized");
            }
            if (udsDbProperties == null) {
                throw new IllegalArgumentException("UdsDbProperties Map is null");
            }
            this.initialize(DatabaseConnectorFactory.createDatabaseConnectorInstance((ProlineDatabaseType)ProlineDatabaseType.UDS, udsDbProperties), applicationName);
        }
    }

    public void initialize(String udsDbPropertiesFileName) {
        this.initialize(udsDbPropertiesFileName, APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(String udsDbPropertiesFileName, String applicationName) {
        Object object = this.m_managerLock;
        synchronized (object) {
            if (this.isInitialized()) {
                throw new IllegalStateException("UncachedDataStoreConnectorFactory ALREADY initialized");
            }
            if (StringUtils.isEmpty((String)udsDbPropertiesFileName)) {
                throw new IllegalArgumentException("Invalid udsDbPropertiesFileName");
            }
            this.initialize(DatabaseConnectorFactory.createDatabaseConnectorInstance((ProlineDatabaseType)ProlineDatabaseType.UDS, (String)udsDbPropertiesFileName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        boolean result;
        Object object = this.m_managerLock;
        synchronized (object) {
            result = this.m_udsDbConnector != null;
        }
        return result;
    }

    public IDatabaseConnector getUdsDbConnector() {
        this.checkInitialization();
        return this.m_udsDbConnector;
    }

    public IDatabaseConnector getMsiDbConnector(long projectId) {
        return this.getProjectDbConnector(projectId, ProlineDatabaseType.MSI, this.m_msiDbPropertiesMaps);
    }

    public IDatabaseConnector getLcMsDbConnector(long projectId) {
        return this.getProjectDbConnector(projectId, ProlineDatabaseType.LCMS, this.m_lcMsDbPropertiesMaps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDatabaseConnector getProjectDbConnector(long projectId, ProlineDatabaseType prolineDbType, Map<Long, Map<Object, Object>> propertiesMaps) {
        IDatabaseConnector dbConnector = null;
        Object object = this.m_managerLock;
        synchronized (object) {
            this.checkInitialization();
            Long key = projectId;
            Map<Object, Object> propertiesMap = propertiesMaps.get(key);
            if (propertiesMap == null) {
                propertiesMap = this.retrieveExternalDbProperties(prolineDbType, projectId);
                propertiesMaps.put(key, propertiesMap);
            }
            dbConnector = DatabaseConnectorFactory.createDatabaseConnectorInstance((ProlineDatabaseType)prolineDbType, propertiesMap);
        }
        return dbConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        Object object = this.m_managerLock;
        synchronized (object) {
            if (this.m_udsDbConnector != null) {
                try {
                    this.m_udsDbConnector.close();
                }
                catch (Exception exClose) {
                    LOG.error("Error closing UDS Db Connector", (Throwable)exClose);
                }
                this.m_udsDbConnector = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLcMsDbConnector(long projectId) {
        Object object = this.m_managerLock;
        synchronized (object) {
            try {
                Map<Object, Object> lcMsDbPropertiesMap = this.m_lcMsDbPropertiesMaps.get(projectId);
                if (lcMsDbPropertiesMap != null) {
                    this.m_lcMsDbPropertiesMaps.remove(projectId);
                }
            }
            catch (Exception exClose) {
                LOG.error("Error while clearing LCMS Db connection properties", (Throwable)exClose);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeMsiDbConnector(long projectId) {
        Object object = this.m_managerLock;
        synchronized (object) {
            try {
                Map<Object, Object> msiDbPropertiesMap = this.m_msiDbPropertiesMaps.get(projectId);
                if (msiDbPropertiesMap != null) {
                    this.m_msiDbPropertiesMaps.remove(projectId);
                }
            }
            catch (Exception exClose) {
                LOG.error("Error while clearing MSI Db connection properties", (Throwable)exClose);
            }
        }
    }

    public void closeProjectConnectors(long projectId) {
        this.closeLcMsDbConnector(projectId);
        this.closeMsiDbConnector(projectId);
    }

    private void checkInitialization() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("UncachedDataStoreConnectorFactory NOT yet initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Object, Object> retrieveExternalDbProperties(ProlineDatabaseType prolineDbType, long projectId) {
        Map<Object, Object> propertiesMap = null;
        IDatabaseConnector udsDbConnector = this.getUdsDbConnector();
        EntityManager udsEm = udsDbConnector.createEntityManager();
        try {
            Project project = (Project)udsEm.find(Project.class, (Object)projectId);
            if (project == null) {
                throw new IllegalArgumentException("Project #" + projectId + " NOT found in UDS Db");
            }
            ExternalDb externalDb = ExternalDbRepository.findExternalByTypeAndProject(udsEm, prolineDbType, project);
            if (externalDb == null) {
                LOG.warn("No ExternalDb for {} Db of project #{}", (Object)prolineDbType, (Object)projectId);
            } else {
                propertiesMap = externalDb.toPropertiesMap(udsDbConnector.getDriverType(), (String)udsDbConnector.getProperty((Object)"javax.persistence.jdbc.user"), (String)udsDbConnector.getProperty((Object)"javax.persistence.jdbc.password"));
                propertiesMap.put("ApplicationName", this.m_applicationName);
            }
        }
        finally {
            try {
                udsEm.close();
            }
            catch (Exception exClose) {
                LOG.error("Error closing UDS Db EntityManager", (Throwable)exClose);
            }
        }
        return propertiesMap;
    }
}

