/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.datatypes.index.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import umich.ms.datatypes.index.Index;
import umich.ms.datatypes.index.IndexElement;

public class IndexDefault<T extends IndexElement>
implements Index<T> {
    private static final long serialVersionUID = 2038378308383734437L;
    protected final TreeMap<Integer, T> mapByNum = new TreeMap();
    protected volatile TreeMap<Integer, T> mapByRawNum;
    protected volatile HashMap<String, T> mapById;

    @Override
    public NavigableMap<Integer, T> getMapByNum() {
        return this.mapByNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavigableMap<Integer, T> getMapByRawNum() {
        TreeMap<Integer, T> tmp = this.mapByRawNum;
        if (tmp == null) {
            IndexDefault indexDefault = this;
            synchronized (indexDefault) {
                tmp = this.mapByRawNum;
                if (tmp == null) {
                    this.mapByRawNum = tmp = this.createMapByRawNum();
                }
            }
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, T> getMapById() {
        HashMap<String, T> tmp = this.mapById;
        if (tmp == null) {
            IndexDefault indexDefault = this;
            synchronized (indexDefault) {
                tmp = this.mapById;
                if (tmp == null) {
                    this.mapById = tmp = this.createMapById();
                }
            }
        }
        return tmp;
    }

    @Override
    public int size() {
        return this.mapByNum.size();
    }

    @Override
    public void add(T indexElement) {
        this.mapByNum.put(indexElement.getNumber(), indexElement);
        if (this.mapByRawNum != null) {
            this.mapByRawNum.put(indexElement.getRawNumber(), indexElement);
        }
        if (this.mapById != null) {
            this.mapById.put(indexElement.getId(), indexElement);
        }
    }

    @Override
    public T getByNum(int num) {
        return (T)((IndexElement)this.mapByNum.get(num));
    }

    @Override
    public T getByRawNum(int num) {
        NavigableMap<Integer, T> tmp = this.getMapByRawNum();
        return (T)((IndexElement)tmp.get(num));
    }

    @Override
    public T getById(String id) {
        Map<String, T> tmp = this.getMapById();
        return (T)((IndexElement)tmp.get(id));
    }

    private TreeMap<Integer, T> createMapByRawNum() {
        TreeMap<Integer, IndexElement> map = new TreeMap<Integer, IndexElement>();
        for (Map.Entry<Integer, T> entrySet : this.mapByNum.entrySet()) {
            IndexElement value = (IndexElement)entrySet.getValue();
            map.put(value.getRawNumber(), value);
        }
        return map;
    }

    private HashMap<String, T> createMapById() {
        HashMap<String, IndexElement> map = new HashMap<String, IndexElement>();
        for (Map.Entry<Integer, T> entrySet : this.mapByNum.entrySet()) {
            IndexElement value = (IndexElement)entrySet.getValue();
            String id = value.getId();
            if (id == null) {
                id = String.valueOf(value.getRawNumber());
            }
            map.put(id, value);
        }
        return map;
    }
}

