/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.pepxml.example;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.stream.XMLStreamReader;
import umich.ms.fileio.filetypes.pepxml.jaxb.standard.ErrorPoint;
import umich.ms.fileio.filetypes.pepxml.jaxb.standard.InputFileType;
import umich.ms.fileio.filetypes.pepxml.jaxb.standard.PeptideprophetSummary;
import umich.ms.fileio.filetypes.pepxml.jaxb.standard.RocDataPoint;
import umich.ms.fileio.filetypes.pepxml.jaxb.standard.RocErrorDataType;
import umich.ms.util.StringUtils;
import umich.ms.util.jaxb.JaxbUtils;
import umich.ms.util.xml.XmlUtils;

public class PepXmlAnalysisSummaryExample {
    public static void main(String[] args) throws Exception {
        String pathIn = args[0];
        Path p = Paths.get(pathIn, new String[0]).toAbsolutePath();
        if (!Files.exists(p, new LinkOption[0])) {
            throw new IllegalArgumentException("File doesn't exist: " + p.toString());
        }
        XMLStreamReader xsr = JaxbUtils.createXmlStreamReader(p, false);
        boolean foundPepProphSummary = XmlUtils.advanceReaderToNext(xsr, "peptideprophet_summary");
        if (!foundPepProphSummary) {
            throw new IllegalStateException("Could not advance the reader to the beginning of a peptideprophet_summary tag.");
        }
        PeptideprophetSummary ps = JaxbUtils.unmarshal(PeptideprophetSummary.class, xsr);
        StringBuilder sb = new StringBuilder();
        sb.append("Input files:");
        for (InputFileType inputFile : ps.getInputfile()) {
            sb.append("\n\t").append(inputFile.getName());
            if (StringUtils.isNullOrWhitespace(inputFile.getDirectory())) continue;
            sb.append(" @ ").append(inputFile.getDirectory());
        }
        for (RocErrorDataType rocErrorData : ps.getRocErrorData()) {
            sb.append("\n");
            sb.append(String.format("ROC Error data (charge '%s'): \n", rocErrorData.getCharge()));
            for (RocDataPoint rocDataPoint : rocErrorData.getRocDataPoint()) {
                sb.append(String.format("ROC min_prob=\"%.3f\" sensitivity=\"%.3f\" error=\"%.3f\" num_corr=\"%d\" num_incorr=\"%d\"\n", rocDataPoint.getMinProb(), rocDataPoint.getSensitivity(), rocDataPoint.getError(), rocDataPoint.getNumCorr(), rocDataPoint.getNumIncorr()));
            }
            for (ErrorPoint errroPoint : rocErrorData.getErrorPoint()) {
                sb.append(String.format("ERR error=\"%.3f\" min_prob=\"%.3f\" num_corr=\"%d\" num_incorr=\"%d\"\n", errroPoint.getError(), errroPoint.getMinProb(), errroPoint.getNumCorr(), errroPoint.getNumIncorr()));
            }
        }
        System.out.println(sb.toString());
    }

    private static void error(String msg) {
        System.err.println(msg);
        System.exit(1);
    }
}

