/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.hac.dendrogram;

import org.opencompare.hac.dendrogram.DendrogramNode;

public final class MergeNode
implements DendrogramNode {
    private final DendrogramNode left;
    private final DendrogramNode right;
    private final double dissimilarity;
    private final int observationCount;

    public MergeNode(DendrogramNode left, DendrogramNode right, double dissimilarity) {
        this.left = left;
        this.right = right;
        this.dissimilarity = dissimilarity;
        this.observationCount = left.getObservationCount() + right.getObservationCount();
    }

    public int getObservationCount() {
        return this.observationCount;
    }

    public final DendrogramNode getLeft() {
        return this.left;
    }

    public final DendrogramNode getRight() {
        return this.right;
    }

    public final double getDissimilarity() {
        return this.dissimilarity;
    }
}

