/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam;

import fr.proline.studio.dam.AccessDatabaseWorkerPool;
import fr.proline.studio.dam.AccessDatabaseWorkerThread;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.taskinfo.TaskInfoManager;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.PriorityChangement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Set;
import org.slf4j.LoggerFactory;

public class AccessDatabaseThread
extends Thread {
    private static AccessDatabaseThread m_instance;
    private PriorityQueue<AbstractDatabaseTask> m_actions = new PriorityQueue();
    private HashMap<Long, AbstractDatabaseTask> m_actionMap = new HashMap();
    private HashMap<Long, PriorityChangement> m_priorityChangements = new HashMap();
    private ArrayList<Long> m_abortedActionIdList = new ArrayList();
    private AccessDatabaseWorkerPool m_workerPool = AccessDatabaseWorkerPool.getWorkerPool();

    private AccessDatabaseThread() {
        super("AccessDatabaseThread");
    }

    public static AccessDatabaseThread getAccessDatabaseThread() {
        if (m_instance == null) {
            m_instance = new AccessDatabaseThread();
            m_instance.start();
        }
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            block6: while (true) {
                Object workerPoolMutex;
                AbstractDatabaseTask action = null;
                AccessDatabaseThread accessDatabaseThread = this;
                synchronized (accessDatabaseThread) {
                    while (true) {
                        if (!this.m_abortedActionIdList.isEmpty()) {
                            int nbAbortedTask = this.m_abortedActionIdList.size();
                            for (int i = 0; i < nbAbortedTask; ++i) {
                                Long taskId = this.m_abortedActionIdList.get(i);
                                AbstractDatabaseTask taskToStop = this.m_actionMap.remove(taskId);
                                if (taskToStop == null || !this.m_actions.contains(taskToStop)) continue;
                                this.m_actions.remove(taskToStop);
                                TaskInfo info = taskToStop.getTaskInfo();
                                if (info.isWaiting()) {
                                    TaskInfoManager.getTaskInfoManager().cancel(info);
                                } else {
                                    taskToStop.abortTask();
                                }
                                taskToStop.deleteThis();
                            }
                            this.m_abortedActionIdList.clear();
                        }
                        if (!this.m_priorityChangements.isEmpty()) {
                            for (Long taskId : this.m_priorityChangements.keySet()) {
                                PriorityChangement priorityChangement = this.m_priorityChangements.get(taskId);
                                AbstractDatabaseTask task = priorityChangement.getTask();
                                if (!this.m_actions.contains(task)) continue;
                                this.m_actions.remove(task);
                                task.applyPriorityChangement(priorityChangement);
                                this.m_actions.offer(task);
                            }
                        }
                        if (!this.m_actions.isEmpty()) {
                            action = this.m_actions.poll();
                            this.notifyAll();
                            // MONITOREXIT @DISABLED, blocks:[0, 3, 6, 7, 12] lbl39 : MonitorExitStatement: MONITOREXIT : var2_3
                            Object object = workerPoolMutex = this.m_workerPool.getMutex();
                            synchronized (object) {
                                break;
                            }
                        }
                        this.wait();
                    }
                }
                {
                    AccessDatabaseWorkerThread workerThread = null;
                    while (true) {
                        if ((workerThread = this.m_workerPool.getWorkerThread(action.getCurrentPriority())) != null) {
                            workerThread.setAction(action);
                            workerPoolMutex.notifyAll();
                            continue block6;
                        }
                        workerPoolMutex.wait();
                    }
                }
                break;
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger((String)"ProlineStudio.DAM").error("Unexpected exception in main loop of AccessDatabaseThread", t);
            m_instance = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionDone(AbstractDatabaseTask task) {
        AccessDatabaseThread accessDatabaseThread = this;
        synchronized (accessDatabaseThread) {
            if (task.hasSubTasksToBeDone()) {
                task.updatePercentage();
                this.m_actions.add(task);
            } else {
                this.m_actionMap.remove(task.getId());
                this.m_priorityChangements.remove(task.getId());
                TaskError taskError = task.getTaskError();
                task.getTaskInfo().setFinished(taskError == null, taskError, true);
            }
            if (task.hasConsecutiveTask()) {
                AbstractDatabaseTask consecutiveTask = task.getConsecutiveTask();
                AbstractDatabaseTask.Priority taskPriority = task.getCurrentPriority();
                if (taskPriority.ordinal() > consecutiveTask.getCurrentPriority().ordinal()) {
                    consecutiveTask.setPriority(taskPriority);
                }
                this.addTask(consecutiveTask);
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTask(AbstractDatabaseTask task) {
        if (!task.needToFetch()) {
            task.callback(true, true);
            if (task.hasConsecutiveTask()) {
                AbstractDatabaseTask consecutiveTask = task.getConsecutiveTask();
                AbstractDatabaseTask.Priority taskPriority = task.getCurrentPriority();
                if (taskPriority.ordinal() > consecutiveTask.getCurrentPriority().ordinal()) {
                    consecutiveTask.setPriority(taskPriority);
                }
                this.addTask(consecutiveTask);
            }
            return;
        }
        TaskInfoManager.getTaskInfoManager().add(task.getTaskInfo());
        AccessDatabaseThread accessDatabaseThread = this;
        synchronized (accessDatabaseThread) {
            this.m_actions.add(task);
            this.m_actionMap.put(task.getId(), task);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abortTask(Long taskId) {
        AccessDatabaseThread accessDatabaseThread = this;
        synchronized (accessDatabaseThread) {
            this.abortTaskImpl(taskId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abortTasks(Set<Long> taskIds) {
        AccessDatabaseThread accessDatabaseThread = this;
        synchronized (accessDatabaseThread) {
            Iterator<Long> it = taskIds.iterator();
            while (it.hasNext()) {
                this.abortTask(it.next());
            }
        }
    }

    private void abortTaskImpl(Long taskId) {
        AbstractDatabaseTask task = this.m_actionMap.get(taskId);
        if (task == null) {
            return;
        }
        this.m_abortedActionIdList.add(taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPriorityIndex(Long taskId, int index) {
        AccessDatabaseThread accessDatabaseThread = this;
        synchronized (accessDatabaseThread) {
            AbstractDatabaseTask task = this.m_actionMap.get(taskId);
            if (task == null) {
                return;
            }
            PriorityChangement priorityChangement = this.m_priorityChangements.get(taskId);
            if (priorityChangement == null) {
                priorityChangement = new PriorityChangement(task);
                priorityChangement.setIndex(index);
                this.m_priorityChangements.put(taskId, priorityChangement);
            } else {
                priorityChangement.addIndex(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriorityIndex(Long taskId, int index) {
        AccessDatabaseThread accessDatabaseThread = this;
        synchronized (accessDatabaseThread) {
            AbstractDatabaseTask task = this.m_actionMap.get(taskId);
            if (task == null) {
                return;
            }
            PriorityChangement priorityChangement = this.m_priorityChangements.get(taskId);
            if (priorityChangement == null) {
                priorityChangement = new PriorityChangement(task);
                this.m_priorityChangements.put(taskId, priorityChangement);
            }
            priorityChangement.setIndex(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void givePriorityToSubTask(Long taskId, int subTaskId) {
        AccessDatabaseThread accessDatabaseThread = this;
        synchronized (accessDatabaseThread) {
            AbstractDatabaseTask task = this.m_actionMap.get(taskId);
            if (task == null) {
                return;
            }
            PriorityChangement priorityChangement = this.m_priorityChangements.get(taskId);
            if (priorityChangement == null) {
                priorityChangement = new PriorityChangement(task);
                this.m_priorityChangements.put(taskId, priorityChangement);
            }
            priorityChangement.setSubTask(subTaskId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIndexPriorityTo(Long taskId) {
        AccessDatabaseThread accessDatabaseThread = this;
        synchronized (accessDatabaseThread) {
            PriorityChangement priorityChangement = this.m_priorityChangements.get(taskId);
            if (priorityChangement == null) {
                return;
            }
            if (priorityChangement.getSubTaskId() != -1) {
                priorityChangement.clearIndex();
            } else {
                this.m_priorityChangements.remove(taskId);
                AbstractDatabaseTask task = priorityChangement.getTask();
                boolean isActionRegistered = this.m_actions.remove(task);
                task.resetPriority();
                if (isActionRegistered) {
                    this.m_actions.offer(task);
                }
            }
        }
    }
}

