/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.PriorityChangement;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.SubTaskManager;
import javax.swing.SwingUtilities;

public abstract class AbstractDatabaseSlicerTask
extends AbstractDatabaseTask {
    protected SubTaskManager m_subTaskManager;

    public AbstractDatabaseSlicerTask(AbstractDatabaseCallback callback) {
        super(callback, null);
    }

    public AbstractDatabaseSlicerTask(AbstractDatabaseCallback callback, int subTaskCount, TaskInfo taskInfo) {
        super(callback, taskInfo);
        this.m_subTaskManager = new SubTaskManager(subTaskCount);
    }

    public AbstractDatabaseSlicerTask(AbstractDatabaseCallback callback, int subTaskCount, AbstractDatabaseTask.Priority priority, TaskInfo taskInfo) {
        super(callback, priority, taskInfo);
        this.m_subTaskManager = new SubTaskManager(subTaskCount);
    }

    public void init(int subTaskCount, TaskInfo taskInfo) {
        this.setTaskInfo(taskInfo);
        this.m_subTaskManager = new SubTaskManager(subTaskCount);
    }

    @Override
    public void updatePercentage() {
        float percentage = this.m_subTaskManager.getAccomplishedPercentage();
        this.m_taskInfo.setPercentage(percentage);
    }

    @Override
    public void deleteThis() {
        super.deleteThis();
        this.m_subTaskManager.deleteThis();
    }

    @Override
    public boolean hasSubTasksToBeDone() {
        return !this.m_subTaskManager.isEmpty();
    }

    @Override
    public void applyPriorityChangement(PriorityChangement priorityChangement) {
        super.applyPriorityChangement(priorityChangement);
        this.m_subTaskManager.givePriorityTo(priorityChangement.getSubTaskId(), priorityChangement.getStartIndex(), priorityChangement.getStopIndex());
    }

    @Override
    public void resetPriority() {
        this.m_currentPriority = this.m_defaultPriority;
        this.m_subTaskManager.resetPriority();
    }

    @Override
    public void callback(final boolean success, final boolean finished) {
        if (this.m_callback == null) {
            return;
        }
        final SubTask taskDone = this.m_subTaskManager.getCurrentTask();
        if (this.m_callback.mustBeCalledInAWT()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (AbstractDatabaseSlicerTask.this.m_callback != null) {
                        AbstractDatabaseSlicerTask.this.m_callback.run(success, AbstractDatabaseSlicerTask.this.m_id, taskDone, finished);
                    }
                }
            });
        } else {
            this.m_callback.run(success, this.m_id, taskDone, finished);
        }
    }
}

