/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.MergeMode;
import fr.proline.core.orm.msi.MsiSearch;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.SearchSetting;
import fr.proline.core.orm.uds.Aggregation;
import fr.proline.core.orm.uds.Dataset;
import fr.proline.core.orm.uds.ExternalDb;
import fr.proline.core.orm.uds.IdentificationDataset;
import fr.proline.core.orm.uds.ObjectTree;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.core.orm.uds.repository.ExternalDbRepository;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.core.orm.util.JsonSerializer;
import fr.proline.core.orm.util.TransientDataAllocationListener;
import fr.proline.repository.ProlineDatabaseType;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.data.DatasetToCopy;
import fr.proline.studio.dam.memory.TransientMemoryCacheManager;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class DatabaseDataSetTask
extends AbstractDatabaseTask {
    private Project m_project = null;
    private DDataset m_dataset = null;
    private ArrayList<DDataset> m_datasetList = null;
    private List<AbstractData> m_list = null;
    private ResultSummary m_rsm = null;
    private String m_name = null;
    private DDataset m_parentDataset = null;
    private Long m_resultSetId = null;
    private Long m_resultSummaryId = null;
    private Aggregation.ChildNature m_datasetType;
    private String m_aggregateName;
    private boolean m_hasSuffix = false;
    private int m_suffixStart = 0;
    private int m_suffixStop = 0;
    private Long m_datasetId = null;
    private List<Long> m_dsChildRSMIds = null;
    private List<String> m_dsNames = null;
    private boolean m_identificationDataset;
    private DatasetToCopy m_datasetCopy = null;
    private int m_action;
    private static final int LOAD_PARENT_DATASET = 0;
    private static final int LOAD_CHILDREN_DATASET = 1;
    private static final int LOAD_RSET_AND_RSM_OF_DATASET = 2;
    private static final int LOAD_DATASET_FOR_RSM = 3;
    private static final int RENAME_DATASET = 4;
    private static final int CREATE_AGGREGATE_DATASET = 5;
    private static final int CREATE_IDENTIFICATION_DATASET = 6;
    private static final int MODIFY_VALIDATED_DATASET = 7;
    private static final int REMOVE_VALIDATION_OF_DATASET = 8;
    private static final int MODIFY_MERGED_DATASET = 9;
    private static final int EMPTY_TRASH = 10;
    private static final int LOAD_DATASET_AND_RSM_INFO = 11;
    private static final int LOAD_DATASET = 12;
    private static final int CLEAR_DATASET_RSM_AND_RSET = 13;
    private static final int CLEAR_DATASET_RSM = 14;
    private static final int LOAD_QUANTITATION = 15;
    private static final int CREATE_QUANTITATION_FOLDER = 16;
    private static final int CREATE_IDENTIFICATION_FOLDER = 17;
    private static final int PASTE_DATASET = 18;
    private static final int UPDATE_RSET_OF_DATASET = 19;
    private static final Object WRITE_DATASET_LOCK = new Object();

    public DatabaseDataSetTask(AbstractDatabaseCallback callback) {
        super(callback, null);
    }

    public void initLoadParentDataset(Project project, List<AbstractData> list, boolean identificationDataset) {
        this.setTaskInfo(new TaskInfo("Load " + (identificationDataset ? "Identification" : "Quantitation") + " Data for Project " + project.getName(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_project = project;
        this.m_list = list;
        this.m_identificationDataset = identificationDataset;
        this.m_action = 0;
        this.setPriority(AbstractDatabaseTask.Priority.HIGH_1);
    }

    public void initLoadChildrenDataset(DDataset parentDataset, List<AbstractData> list, boolean identificationDataset) {
        this.setTaskInfo(new TaskInfo("Load Data for Dataset " + parentDataset.getName(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_project = parentDataset.getProject();
        this.m_parentDataset = parentDataset;
        this.m_list = list;
        this.m_identificationDataset = identificationDataset;
        this.m_action = 1;
        this.setPriority(AbstractDatabaseTask.Priority.HIGH_1);
    }

    public void initLoadRsetAndRsm(DDataset dataset) {
        this.setTaskInfo(new TaskInfo("Load Search Result and Identification Summary for Dataset " + dataset.getName(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_dataset = dataset;
        this.m_action = 2;
    }

    public void initUpdateRset(DDataset dataset) {
        this.setTaskInfo(new TaskInfo("Update Search Result for Dataset " + dataset.getName(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_dataset = dataset;
        this.m_action = 19;
    }

    public void initUpdateRset(ArrayList<DDataset> datasetList) {
        this.setTaskInfo(new TaskInfo("Update Search Result for multiple Dataset (" + datasetList.size() + " datasets)", false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_datasetList = datasetList;
        this.m_action = 19;
    }

    public void initLoadQuantitation(Project project, DDataset dataset) {
        this.setTaskInfo(new TaskInfo("Load Quantitation for Dataset " + dataset.getName(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_dataset = dataset;
        this.m_project = project;
        this.m_action = 15;
    }

    public void initLoadRsetAndRsm(ArrayList<DDataset> datasetList) {
        this.setTaskInfo(new TaskInfo("Load Search Result and Identification Summary for multiple Dataset", false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_datasetList = datasetList;
        this.m_action = 2;
    }

    public void initLoadDatasetForRsm(ResultSummary rsm) {
        this.setTaskInfo(new TaskInfo("Load data for Identification Summary " + rsm.getId(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_rsm = rsm;
        this.m_action = 3;
    }

    public void initRenameDataset(DDataset dataset, String oldName, String name) {
        this.setTaskInfo(new TaskInfo("Rename Dataset " + oldName + " to " + name, true, "Database Access", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_name = name;
        this.m_dataset = dataset;
        this.m_action = 4;
    }

    public void initPasteDatasets(Project project, DDataset parentDataset, DatasetToCopy datasetCopy, ArrayList<DDataset> datasetList) {
        this.setTaskInfo(new TaskInfo("Paste Dataset ", true, "Database Access", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_project = project;
        this.m_parentDataset = parentDataset;
        this.m_datasetCopy = datasetCopy;
        this.m_action = 18;
        this.m_datasetList = datasetList;
    }

    public void initCreateDatasetAggregate(Project project, DDataset parentDataset, Aggregation.ChildNature datasetType, String aggregateName, ArrayList<DDataset> datasetList) {
        this.initCreateDatasetAggregate(project, parentDataset, datasetType, aggregateName, false, 0, 0, datasetList);
    }

    public void initCreateDatasetAggregate(Project project, DDataset parentDataset, Aggregation.ChildNature datasetType, String aggregateName, boolean hasSuffix, int suffixStart, int suffixStop, ArrayList<DDataset> datasetList) {
        this.setTaskInfo(new TaskInfo("Create Dataset " + aggregateName, true, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_project = project;
        this.m_parentDataset = parentDataset;
        this.m_datasetType = datasetType;
        this.m_aggregateName = aggregateName;
        this.m_hasSuffix = hasSuffix;
        this.m_suffixStart = suffixStart;
        this.m_suffixStop = suffixStop;
        this.m_datasetList = datasetList;
        this.m_action = 5;
    }

    public void initCreateDatasetFolder(Project project, DDataset parentDataset, String folderName, boolean identification, ArrayList<DDataset> datasetList) {
        this.setTaskInfo(new TaskInfo("Create " + (identification ? "Identification" : "Quantitation") + " Folder " + folderName, true, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_project = project;
        this.m_parentDataset = parentDataset;
        this.m_aggregateName = folderName;
        this.m_datasetList = datasetList;
        this.m_action = identification ? 17 : 16;
    }

    public void initCreateDatasetForIdentification(Project project, DDataset parentDataset, Aggregation.ChildNature datasetType, String aggregateName, Long resultSetId, Long resultSummaryId, ArrayList<DDataset> datasetList, TaskInfo taskInfo) {
        this.setTaskInfo(taskInfo);
        this.setPriority(AbstractDatabaseTask.Priority.HIGH_2);
        this.m_project = project;
        this.m_parentDataset = parentDataset;
        this.m_datasetType = datasetType;
        this.m_aggregateName = aggregateName;
        this.m_resultSetId = resultSetId;
        this.m_resultSummaryId = resultSummaryId;
        this.m_datasetList = datasetList;
        this.m_action = 6;
    }

    public void initModifyDatasetForValidation(DDataset dataset, Long resultSummaryId, TaskInfo taskInfo) {
        this.setTaskInfo(taskInfo);
        this.setPriority(AbstractDatabaseTask.Priority.HIGH_2);
        this.m_dataset = dataset;
        this.m_resultSummaryId = resultSummaryId;
        this.m_action = 7;
    }

    public void initModifyDatasetToRemoveValidation(DDataset dataset) {
        this.setTaskInfo(new TaskInfo("Remove Identification Summary from Dataset " + dataset.getName(), true, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.setPriority(AbstractDatabaseTask.Priority.HIGH_2);
        this.m_dataset = dataset;
        this.m_action = 8;
    }

    public void initModifyDatasetForMerge(DDataset dataset, Long resultSetId, Long resultSummaryId, TaskInfo taskInfo) {
        this.setTaskInfo(taskInfo);
        this.setPriority(AbstractDatabaseTask.Priority.HIGH_2);
        this.m_dataset = dataset;
        this.m_resultSetId = resultSetId;
        this.m_resultSummaryId = resultSummaryId;
        this.m_action = 9;
    }

    public void initEmptyTrash(DDataset trashDataset, boolean identificationDataset) {
        String type = Dataset.DatasetType.IDENTIFICATION.name();
        if (!identificationDataset) {
            type = Dataset.DatasetType.QUANTITATION.name();
        }
        this.setTaskInfo(new TaskInfo("Empty Trash " + type, true, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.setPriority(AbstractDatabaseTask.Priority.HIGH_2);
        this.m_dataset = trashDataset;
        this.m_identificationDataset = identificationDataset;
        this.m_action = 10;
    }

    public void initLoadDatasetAndRSMInfo(Long datasetId, ArrayList<Long> rsmIds, ArrayList<DDataset> returnedDatasetList, ArrayList<String> returnedDatasetNames, Project project) {
        this.setTaskInfo(new TaskInfo("Load DataSet " + datasetId + " and get RSMs names", false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_project = project;
        this.m_datasetId = datasetId;
        this.m_dsChildRSMIds = rsmIds;
        this.m_action = 11;
        this.m_datasetList = returnedDatasetList;
        this.m_dsNames = returnedDatasetNames;
        this.setPriority(AbstractDatabaseTask.Priority.HIGH_1);
    }

    public void initLoadDataset(Long datasetId, ArrayList<DDataset> returnedDatasetList) {
        this.setTaskInfo(new TaskInfo("Load DataSet " + datasetId, false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_datasetId = datasetId;
        this.m_datasetList = returnedDatasetList;
        this.m_action = 12;
        this.setPriority(AbstractDatabaseTask.Priority.HIGH_1);
    }

    public void initClearDataset(DDataset dataset, boolean rsmAndRset) {
        this.setTaskInfo(new TaskInfo("Clear Dataset " + dataset.getName(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_dataset = dataset;
        this.m_action = rsmAndRset ? 13 : 14;
    }

    @Override
    public boolean needToFetch() {
        switch (this.m_action) {
            case 0: 
            case 1: {
                return true;
            }
            case 3: {
                return this.m_rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getDataSet() == null;
            }
            case 2: {
                if (this.m_datasetList != null) {
                    int nbDataSet = this.m_datasetList.size();
                    for (int i = 0; i < nbDataSet; ++i) {
                        DDataset d = this.m_datasetList.get(i);
                        if (!this.needToFetchRsetAndRsm(d)) continue;
                        return true;
                    }
                    return false;
                }
                return this.needToFetchRsetAndRsm(this.m_dataset);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return true;
    }

    private boolean needToFetchRsetAndRsm(DDataset dataset) {
        if (dataset.getResultSetId() != null && dataset.getResultSet() == null) {
            return true;
        }
        return dataset.getResultSummaryId() != null && dataset.getResultSummary() == null;
    }

    @Override
    public boolean fetchData() {
        switch (this.m_action) {
            case 0: {
                return this.fetchParentsDataSet();
            }
            case 1: {
                return this.fetchChildrenDataSet();
            }
            case 2: {
                return this.fetchRsetAndRsm();
            }
            case 3: {
                return this.fetchDatasetForRsm(this.m_rsm);
            }
            case 4: {
                return this.renameDataset();
            }
            case 18: {
                return this.pasteDataset();
            }
            case 5: {
                return this.createDataset(false);
            }
            case 6: {
                return this.createDataset(true);
            }
            case 7: {
                return this.modifyDatasetRSM();
            }
            case 8: {
                return this.removeValidationOfDataset();
            }
            case 9: {
                return this.modifyDatasetRsetAndRsm();
            }
            case 10: {
                return this.emptyTrash();
            }
            case 11: {
                return this.fetchDatasetWithIDAndRSMInfo();
            }
            case 12: {
                return this.fetchDataset();
            }
            case 13: 
            case 14: {
                return this.clearDataset();
            }
            case 15: {
                return this.fetchQuantitation();
            }
            case 16: {
                return this.createDatasetFolder(false);
            }
            case 17: {
                return this.createDatasetFolder(true);
            }
            case 19: {
                return this.updateDatasetsRset();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fetchParentsDataSet() {
        long projectId = this.m_project.getId();
        ArrayList<Long> dsIdsList = new ArrayList<Long>();
        HashMap<Long, DDataset> ddatasetById = new HashMap<Long, DDataset>();
        ArrayList<Long> rsetIdList = new ArrayList<Long>();
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            List datasetListSelected = new ArrayList();
            if (this.m_identificationDataset) {
                dataSetQuery = entityManagerUDS.createQuery("SELECT new fr.proline.core.orm.uds.dto.DDataset(d.id, d.project, d.name, d.type, d.childCount, d.resultSetId, d.resultSummaryId, d.number) FROM Dataset d WHERE (d.parentDataset IS null) AND d.type<>:quantitationType AND d.type<>:quantitationType2 AND d.project.id=:projectId  ORDER BY d.number ASC", DDataset.class);
                dataSetQuery.setParameter("projectId", (Object)projectId);
                dataSetQuery.setParameter("quantitationType", (Object)Dataset.DatasetType.QUANTITATION);
                dataSetQuery.setParameter("quantitationType2", (Object)Dataset.DatasetType.QUANTITATION_FOLDER);
                datasetListSelected = dataSetQuery.getResultList();
            } else {
                dataSetQuery = entityManagerUDS.createQuery("SELECT new fr.proline.core.orm.uds.dto.DDataset(d.id, d.project, d.name, d.type, d.childCount, d.resultSetId, d.resultSummaryId, d.number) FROM Dataset d WHERE (d.parentDataset IS null) AND (  d.type=:trashType)  AND d.project.id=:projectId  ORDER BY d.number ASC", DDataset.class);
                dataSetQuery.setParameter("projectId", (Object)projectId);
                dataSetQuery.setParameter("trashType", (Object)Dataset.DatasetType.TRASH);
                datasetListSelected.addAll(dataSetQuery.getResultList());
                dataSetQuery = entityManagerUDS.createQuery("SELECT new fr.proline.core.orm.uds.dto.DDataset(d.id, d.project, d.name, d.type, d.childCount, d.resultSetId, mqc.quantResultSummaryId, d.number) FROM Dataset d, MasterQuantitationChannel mqc WHERE (d.parentDataset IS null) AND d.type=:quantitationType  AND d.project.id=:projectId AND mqc.quantDataset.id = d.id ORDER BY d.number ASC", DDataset.class);
                dataSetQuery.setParameter("projectId", (Object)projectId);
                dataSetQuery.setParameter("quantitationType", (Object)Dataset.DatasetType.QUANTITATION);
                datasetListSelected.addAll(dataSetQuery.getResultList());
                dataSetQuery = entityManagerUDS.createQuery("SELECT new fr.proline.core.orm.uds.dto.DDataset(d.id, d.project, d.name, d.type, d.childCount, d.resultSetId, d.resultSummaryId, d.number) FROM Dataset d WHERE (d.parentDataset IS null) AND d.type=:quantitationType AND d.project.id=:projectId  ORDER BY d.number ASC", DDataset.class);
                dataSetQuery.setParameter("projectId", (Object)projectId);
                dataSetQuery.setParameter("quantitationType", (Object)Dataset.DatasetType.QUANTITATION_FOLDER);
                datasetListSelected.addAll(dataSetQuery.getResultList());
                Collections.sort(datasetListSelected, new Comparator<DDataset>(){

                    @Override
                    public int compare(DDataset d2, DDataset d1) {
                        if (d2.isTrash()) {
                            return Integer.MAX_VALUE;
                        }
                        if (d1.isTrash()) {
                            return Integer.MIN_VALUE;
                        }
                        return d2.getNumber() - d1.getNumber();
                    }
                });
            }
            DDataset trash = null;
            for (DDataset datasetCur : datasetListSelected) {
                boolean isQuantiWithChild;
                boolean bl = isQuantiWithChild = datasetCur.isQuantitation() && (datasetCur.getQuantMethodInfo() == DDatasetType.QuantitationMethodInfo.FEATURES_EXTRACTION || datasetCur.getQuantMethodInfo() == DDatasetType.QuantitationMethodInfo.ISOBARIC_TAGGING);
                if (isQuantiWithChild) {
                    datasetCur.setChildrenCount(1);
                }
                if (datasetCur.isTrash()) {
                    trash = datasetCur;
                } else {
                    DataSetData dsData = new DataSetData(datasetCur);
                    if (isQuantiWithChild) {
                        dsData.setHasChildren(true);
                    }
                    this.m_list.add(dsData);
                    Long resultSetId = datasetCur.getResultSetId();
                    if (resultSetId != null) {
                        rsetIdList.add(resultSetId);
                    }
                }
                Long id = datasetCur.getId();
                dsIdsList.add(id);
                ddatasetById.put(id, datasetCur);
            }
            if (!this.m_list.isEmpty()) {
                this.loadDataSetSuppData(entityManagerUDS, dsIdsList, ddatasetById);
            }
            if (trash != null) {
                this.m_list.add(new DataSetData(trash));
            }
            if (this.m_identificationDataset) {
                this.m_project.getTransientData().setChildrenNumber(this.m_list.size());
            }
            ExternalDb msiDb = ExternalDbRepository.findExternalByTypeAndProject((EntityManager)entityManagerUDS, (ProlineDatabaseType)ProlineDatabaseType.MSI, (Project)((Project)entityManagerUDS.merge((Object)this.m_project)));
            String udsJdbcUrl = DatabaseDataManager.getDatabaseDataManager().getUdsJdbcURL();
            String msiJdbcUrl = udsJdbcUrl.substring(0, udsJdbcUrl.lastIndexOf(47) + 1) + msiDb.getDbName();
            String dbUser = (String)DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(projectId).getProperty((Object)"javax.persistence.jdbc.user");
            String dbPassword = (String)DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(projectId).getProperty((Object)"javax.persistence.jdbc.password");
            entityManagerUDS.getTransaction().commit();
        }
        this.completeMergeInfo(projectId, rsetIdList);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fetchChildrenDataSet() {
        long parentDatasetId = this.m_parentDataset.getId();
        ArrayList<Long> dsIdsList = new ArrayList<Long>();
        HashMap<Long, DDataset> ddatasetById = new HashMap<Long, DDataset>();
        ArrayList<Long> rsetIdList = new ArrayList<Long>();
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            List datasetListSelected = new ArrayList();
            if (this.m_parentDataset.isTrash()) {
                if (this.m_identificationDataset) {
                    datasetQuery = entityManagerUDS.createQuery("SELECT new fr.proline.core.orm.uds.dto.DDataset(d.id, d.project, d.name,  d.type, d.childCount, d.resultSetId, d.resultSummaryId, d.number)  FROM Dataset d WHERE d.parentDataset.id=:parentDatasetId AND d.type<>:quantitationType AND d.type<>:quantitationType2 ORDER BY d.number ASC", DDataset.class);
                    datasetQuery.setParameter("quantitationType", (Object)Dataset.DatasetType.QUANTITATION);
                    datasetQuery.setParameter("quantitationType2", (Object)Dataset.DatasetType.QUANTITATION_FOLDER);
                    datasetQuery.setParameter("parentDatasetId", (Object)parentDatasetId);
                    datasetListSelected = datasetQuery.getResultList();
                } else {
                    datasetQuery = entityManagerUDS.createQuery("SELECT new fr.proline.core.orm.uds.dto.DDataset(d.id, d.project, d.name,  d.type, d.childCount, d.resultSetId, mqc.quantResultSummaryId, d.number)  FROM Dataset d, MasterQuantitationChannel mqc WHERE d.parentDataset.id=:parentDatasetId AND d.type=:quantitationType AND mqc.quantDataset.id = d.id ORDER BY d.number ASC", DDataset.class);
                    datasetQuery.setParameter("quantitationType", (Object)Dataset.DatasetType.QUANTITATION);
                    datasetQuery.setParameter("parentDatasetId", (Object)parentDatasetId);
                    datasetListSelected.addAll(datasetQuery.getResultList());
                    datasetQuery = entityManagerUDS.createQuery("SELECT new fr.proline.core.orm.uds.dto.DDataset(d.id, d.project, d.name,  d.type, d.childCount, d.resultSetId, d.resultSummaryId, d.number)  FROM Dataset d WHERE d.parentDataset.id=:parentDatasetId AND d.type=:quantitationType2 ORDER BY d.number ASC", DDataset.class);
                    datasetQuery.setParameter("quantitationType2", (Object)Dataset.DatasetType.QUANTITATION_FOLDER);
                    datasetQuery.setParameter("parentDatasetId", (Object)parentDatasetId);
                    datasetListSelected.addAll(datasetQuery.getResultList());
                }
            } else if (this.m_identificationDataset) {
                datasetQuery = entityManagerUDS.createQuery("SELECT new fr.proline.core.orm.uds.dto.DDataset(d.id, d.project, d.name,  d.type, d.childCount, d.resultSetId, d.resultSummaryId, d.number)  FROM Dataset d WHERE d.parentDataset.id=:parentDatasetId ORDER BY d.number ASC", DDataset.class);
                datasetQuery.setParameter("parentDatasetId", (Object)parentDatasetId);
                datasetListSelected.addAll(datasetQuery.getResultList());
            } else {
                datasetQuery = entityManagerUDS.createQuery("SELECT new fr.proline.core.orm.uds.dto.DDataset(d.id, d.project, d.name,  d.type, d.childCount, d.resultSetId, mqc.quantResultSummaryId, d.number)  FROM Dataset d, MasterQuantitationChannel mqc WHERE d.parentDataset.id=:parentDatasetId AND mqc.quantDataset.id = d.id ORDER BY d.number ASC", DDataset.class);
                datasetQuery.setParameter("parentDatasetId", (Object)parentDatasetId);
                datasetListSelected.addAll(datasetQuery.getResultList());
                datasetQuery = entityManagerUDS.createQuery("SELECT new fr.proline.core.orm.uds.dto.DDataset(d.id, d.project, d.name,  d.type, d.childCount, d.resultSetId, d.resultSummaryId, d.number)  FROM Dataset d WHERE d.type=:datasetType AND d.parentDataset.id=:parentDatasetId ORDER BY d.number ASC", DDataset.class);
                datasetQuery.setParameter("datasetType", (Object)Dataset.DatasetType.QUANTITATION_FOLDER);
                datasetQuery.setParameter("parentDatasetId", (Object)parentDatasetId);
                datasetListSelected.addAll(datasetQuery.getResultList());
            }
            Collections.sort(datasetListSelected, new Comparator<DDataset>(){

                @Override
                public int compare(DDataset d2, DDataset d1) {
                    if (d2.isTrash()) {
                        return Integer.MAX_VALUE;
                    }
                    if (d1.isTrash()) {
                        return Integer.MIN_VALUE;
                    }
                    return d2.getNumber() - d1.getNumber();
                }
            });
            for (DDataset datasetCur : datasetListSelected) {
                this.m_list.add(new DataSetData(datasetCur));
                Long id = datasetCur.getId();
                dsIdsList.add(id);
                ddatasetById.put(id, datasetCur);
                Long resultSetId = datasetCur.getResultSetId();
                if (resultSetId == null) continue;
                rsetIdList.add(resultSetId);
            }
            if (!this.m_list.isEmpty()) {
                this.loadDataSetSuppData(entityManagerUDS, dsIdsList, ddatasetById);
            }
            entityManagerUDS.getTransaction().commit();
        }
        this.completeMergeInfo(this.m_parentDataset.getProject().getId(), rsetIdList);
        return true;
    }

    private void loadDataSetSuppData(EntityManager entityManagerUDS, List<Long> dsIdsList, Map<Long, DDataset> ddatasetById) {
        Query aggregationQuery = entityManagerUDS.createQuery("SELECT d.id, d.aggregation FROM Dataset d WHERE d.id IN (:listId)");
        aggregationQuery.setParameter("listId", dsIdsList);
        List results = aggregationQuery.getResultList();
        for (Object[] resCur : results) {
            Long id = (Long)resCur[0];
            Aggregation aggregation = (Aggregation)resCur[1];
            ddatasetById.get(id).setAggregation(aggregation);
        }
        Query quantitationQuery = entityManagerUDS.createQuery("SELECT d.id, d.method FROM Dataset d WHERE d.id IN (:listId)");
        quantitationQuery.setParameter("listId", dsIdsList);
        results = quantitationQuery.getResultList();
        for (Object[] resCur : results) {
            Long id = (Long)resCur[0];
            QuantitationMethod quantitationMethod = (QuantitationMethod)resCur[1];
            ddatasetById.get(id).setQuantitationMethod(quantitationMethod);
        }
        for (Map.Entry<Long, DDataset> entrySet : ddatasetById.entrySet()) {
            DDataset ds = entrySet.getValue();
            if (!ds.isQuantitation()) continue;
            if (ds.getQuantMethodInfo() == DDatasetType.QuantitationMethodInfo.FEATURES_EXTRACTION || ds.getQuantMethodInfo().equals((Object)DDatasetType.QuantitationMethodInfo.ISOBARIC_TAGGING)) {
                ds.setChildrenCount(1);
            }
            Dataset datasetDB = (Dataset)entityManagerUDS.find(Dataset.class, (Object)entrySet.getKey());
            this.setDDatasetQuantProperties(ds, datasetDB.getObjectTreeIdByName(), entityManagerUDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completeMergeInfo(Long projectId, ArrayList<Long> rsetIdList) {
        if (!this.m_list.isEmpty() && !rsetIdList.isEmpty()) {
            try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(projectId.longValue()).createEntityManager();){
                entityManagerMSI.getTransaction().begin();
                HashSet<Long> rsetFromMergedRsm = new HashSet<Long>();
                HashSet<Long> mergedRsmIds = new HashSet<Long>();
                HashMap<Long, MergeMode> mergeModeByRSId = new HashMap<Long, MergeMode>();
                HashMap<Long, MergeMode> mergeModeByRSMId = new HashMap<Long, MergeMode>();
                Query mergeInfoQuery = entityManagerMSI.createQuery("SELECT r.id, r.mergedRsmId, r.serializedProperties FROM ResultSet r WHERE r.id IN (:listId)");
                mergeInfoQuery.setParameter("listId", rsetIdList);
                List results = mergeInfoQuery.getResultList();
                for (Object[] resCur : results) {
                    Long rsetId = (Long)resCur[0];
                    Long mergedRsmId = (Long)resCur[1];
                    if (mergedRsmId != null) {
                        rsetFromMergedRsm.add(rsetId);
                        mergedRsmIds.add(mergedRsmId);
                        continue;
                    }
                    String serializedProperties = (String)resCur[2];
                    Map serializedPropertiesMap = (Map)JsonSerializer.getMapper().readValue(serializedProperties, Map.class);
                    if (!serializedPropertiesMap.containsKey("merge_mode")) continue;
                    String mergeType = serializedPropertiesMap.get("merge_mode").toString().toUpperCase();
                    if (mergeType.equals(MergeMode.UNION.name())) {
                        mergeModeByRSId.put(rsetId, MergeMode.UNION);
                        continue;
                    }
                    mergeModeByRSId.put(rsetId, MergeMode.AGGREGATION);
                }
                if (!mergedRsmIds.isEmpty()) {
                    mergeInfoQuery = entityManagerMSI.createQuery("SELECT rsm.id, rsm.serializedProperties FROM ResultSummary rsm WHERE rsm.id IN (:listId)");
                    mergeInfoQuery.setParameter("listId", mergedRsmIds);
                    results = mergeInfoQuery.getResultList();
                    for (Object[] resCur : results) {
                        Long rsmId = (Long)resCur[0];
                        String serializedProperties = (String)resCur[1];
                        Map serializedPropertiesMap = (Map)JsonSerializer.getMapper().readValue(serializedProperties, Map.class);
                        if (!serializedPropertiesMap.containsKey("merge_mode")) continue;
                        String mergeType = serializedPropertiesMap.get("merge_mode").toString().toUpperCase();
                        if (mergeType.equals(MergeMode.UNION.name())) {
                            mergeModeByRSMId.put(rsmId, MergeMode.UNION);
                            continue;
                        }
                        mergeModeByRSMId.put(rsmId, MergeMode.AGGREGATION);
                    }
                }
                for (AbstractData data : this.m_list) {
                    if (data.getDataType() != AbstractData.DataTypes.DATA_SET) continue;
                    DDataset dataset = ((DataSetData)data).getDataset();
                    Long rsetId = dataset.getResultSetId();
                    Long rsmId = dataset.getResultSummaryId();
                    dataset.setAggregationInformation(DDatasetType.AggregationInformation.UNKNOWN);
                    if (rsetFromMergedRsm.contains(rsetId)) {
                        if (!mergeModeByRSMId.containsKey(rsmId)) continue;
                        if (((MergeMode)mergeModeByRSMId.get(rsmId)).equals((Object)MergeMode.AGGREGATION)) {
                            dataset.setAggregationInformation(DDatasetType.AggregationInformation.IDENTIFICATION_SUMMARY_AGG);
                            continue;
                        }
                        dataset.setAggregationInformation(DDatasetType.AggregationInformation.IDENTIFICATION_SUMMARY_UNION);
                        continue;
                    }
                    if (!mergeModeByRSId.containsKey(rsetId)) continue;
                    if (((MergeMode)mergeModeByRSId.get(rsetId)).equals((Object)MergeMode.AGGREGATION)) {
                        dataset.setAggregationInformation(DDatasetType.AggregationInformation.SEARCH_RESULT_AGG);
                        continue;
                    }
                    dataset.setAggregationInformation(DDatasetType.AggregationInformation.SEARCH_RESULT_UNION);
                }
                entityManagerMSI.getTransaction().commit();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateDatasetsRset() {
        long projectId = -1L;
        if (this.m_dataset != null) {
            projectId = this.m_dataset.getProject().getId();
        } else if (this.m_datasetList != null) {
            projectId = this.m_datasetList.get(0).getProject().getId();
        }
        boolean result = true;
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(projectId).createEntityManager();){
            if (this.m_datasetList != null) {
                int nbDataset = this.m_datasetList.size();
                for (int i = 0; i < nbDataset; ++i) {
                    result = result && this.updateDatasetRset(entityManagerMSI, this.m_datasetList.get(i));
                }
            } else if (this.m_dataset != null) {
                result = this.updateDatasetRset(entityManagerMSI, this.m_dataset);
            }
        }
        return result;
    }

    private boolean updateDatasetRset(EntityManager entityManagerMSI, DDataset d) {
        Long rsetId = d.getResultSetId();
        if (rsetId != null) {
            ResultSet rsetFound = (ResultSet)entityManagerMSI.find(ResultSet.class, (Object)rsetId);
            MsiSearch msiSearch = rsetFound.getMsiSearch();
            if (msiSearch != null) {
                SearchSetting searchSetting = msiSearch.getSearchSetting();
                Set enzymeSet = searchSetting.getEnzymes();
                Iterator it = enzymeSet.iterator();
                while (it.hasNext()) {
                    it.next();
                }
                Set searchSettingsSeqDatabaseMapSet = searchSetting.getSearchSettingsSeqDatabaseMaps();
                Iterator itSeqDbMap = searchSettingsSeqDatabaseMapSet.iterator();
                while (itSeqDbMap.hasNext()) {
                    itSeqDbMap.next();
                }
            }
            d.setResultSet(rsetFound);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fetchRsetAndRsm() {
        long projectId = -1L;
        if (this.m_dataset != null) {
            projectId = this.m_dataset.getProject().getId();
        } else if (this.m_datasetList != null) {
            projectId = this.m_datasetList.get(0).getProject().getId();
        }
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            if (this.m_datasetList != null) {
                int nbDataset = this.m_datasetList.size();
                for (int i = 0; i < nbDataset; ++i) {
                    this.fetchRsetAndRsmForOneDataset(entityManagerMSI, this.m_datasetList.get(i));
                }
            } else if (this.m_dataset != null) {
                this.fetchRsetAndRsmForOneDataset(entityManagerMSI, this.m_dataset);
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchQuantitation() {
        EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();
        EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_project.getId()).createEntityManager();
        EntityManager entityManagerLCMS = DStoreCustomPoolConnectorFactory.getInstance().getLcMsDbConnector(this.m_project.getId()).createEntityManager();
        try {
            entityManagerUDS.getTransaction().begin();
            entityManagerMSI.getTransaction().begin();
            entityManagerLCMS.getTransaction().begin();
            Dataset datasetDB = (Dataset)entityManagerUDS.find(Dataset.class, (Object)this.m_dataset.getId());
            QuantitationMethod quantMethodDB = datasetDB.getMethod();
            List listMasterQuantitationChannels = datasetDB.getMasterQuantitationChannels();
            List labels = quantMethodDB.getLabels();
            quantMethodDB.setLabels(labels);
            this.m_dataset.setQuantitationMethod(quantMethodDB);
            this.m_dataset.setDescription(datasetDB.getDescription());
            this.m_taskError = DatabaseLoadXicMasterQuantTask.fetchDataQuantChannels(this.m_project.getId(), this.m_dataset);
            this.setDDatasetQuantProperties(this.m_dataset, datasetDB.getObjectTreeIdByName(), entityManagerUDS);
            entityManagerUDS.getTransaction().commit();
            entityManagerMSI.getTransaction().commit();
            entityManagerLCMS.getTransaction().commit();
        }
        catch (Exception e) {
            m_logger.error(this.getClass().getSimpleName() + " failed", (Throwable)e);
            this.m_taskError = new TaskError(e);
            try {
                entityManagerUDS.getTransaction().rollback();
                entityManagerMSI.getTransaction().rollback();
                entityManagerLCMS.getTransaction().rollback();
            }
            catch (Exception rollbackException) {
                m_logger.error(this.getClass().getSimpleName() + " failed : potential network problem", (Throwable)rollbackException);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            entityManagerUDS.close();
            entityManagerMSI.close();
            entityManagerLCMS.close();
        }
        return true;
    }

    private void setDDatasetQuantProperties(DDataset ddataset, Map<String, Long> objectTreeIdByName, EntityManager entityManagerUDS) {
        if (objectTreeIdByName != null) {
            for (Map.Entry<String, Long> entry : objectTreeIdByName.entrySet()) {
                if (!entry.getKey().startsWith("quantitation") && !entry.getKey().equals("proline.low_level_config")) continue;
                Long objectId = entry.getValue();
                ObjectTree objectTree = (ObjectTree)entityManagerUDS.find(ObjectTree.class, (Object)objectId);
                ddataset.setObjectTree(objectTree);
            }
        }
    }

    private void fetchRsetAndRsmForOneDataset(EntityManager entityManagerMSI, DDataset d) {
        this.updateDatasetRset(entityManagerMSI, d);
        Long rsmId = d.getResultSummaryId();
        if (rsmId != null) {
            ResultSummary rsmFound = (ResultSummary)entityManagerMSI.find(ResultSummary.class, (Object)rsmId);
            Set objTreeByName = rsmFound.getObjectTreeIdByName().keySet();
            rsmFound.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setDDataset(d);
            d.setResultSummary(rsmFound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDatasetForRsm(ResultSummary rsm) {
        Long rsmId = rsm.getId();
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            TypedQuery dataSetQuery = entityManagerUDS.createQuery("SELECT d FROM Dataset d WHERE d.resultSummaryId=:rsmId", Dataset.class);
            dataSetQuery.setParameter("rsmId", (Object)rsmId);
            Dataset dataSet = (Dataset)dataSetQuery.getSingleResult();
            rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setDataSet(dataSet);
            entityManagerUDS.getTransaction().commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataset() {
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            TypedQuery dataSetQuery = entityManagerUDS.createQuery("SELECT new fr.proline.core.orm.uds.dto.DDataset(d.id, d.project, d.name, d.type, d.childCount, d.resultSetId, d.resultSummaryId, d.number)  FROM Dataset d WHERE d.id=:dsId", DDataset.class);
            dataSetQuery.setParameter("dsId", (Object)this.m_datasetId);
            DDataset ddataSet = (DDataset)dataSetQuery.getSingleResult();
            this.m_datasetList.add(ddataSet);
            if (ddataSet.isIdentification() && ddataSet.isAggregation()) {
                TypedQuery aggregationQuery = entityManagerUDS.createQuery("SELECT d.aggregation FROM Dataset d WHERE d.id = :dsId", Aggregation.class);
                aggregationQuery.setParameter("dsId", (Object)this.m_datasetId);
                Aggregation aggregation = (Aggregation)aggregationQuery.getSingleResult();
                ddataSet.setAggregation(aggregation);
            }
            if (ddataSet.isQuantitation()) {
                TypedQuery quantitationQuery = entityManagerUDS.createQuery("SELECT d.method FROM Dataset d WHERE d.id = :dsId", QuantitationMethod.class);
                quantitationQuery.setParameter("dsId", (Object)this.m_datasetId);
                QuantitationMethod quantitationMethod = (QuantitationMethod)quantitationQuery.getSingleResult();
                ddataSet.setQuantitationMethod(quantitationMethod);
                Dataset datasetDB = (Dataset)entityManagerUDS.find(Dataset.class, (Object)this.m_datasetId);
                this.setDDatasetQuantProperties(ddataSet, datasetDB.getObjectTreeIdByName(), entityManagerUDS);
            }
            entityManagerUDS.getTransaction().commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDatasetWithIDAndRSMInfo() {
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            DDataset ddataSet;
            entityManagerUDS.getTransaction().begin();
            TypedQuery dataSetQuery = entityManagerUDS.createQuery("SELECT new fr.proline.core.orm.uds.dto.DDataset(d.id, d.project, d.name,  d.type, d.childCount, d.resultSetId, d.resultSummaryId, d.number)  FROM Dataset d WHERE d.id=:dsId", DDataset.class);
            dataSetQuery.setParameter("dsId", (Object)this.m_datasetId);
            try {
                ddataSet = (DDataset)dataSetQuery.getSingleResult();
                this.m_datasetList.add(ddataSet);
            }
            catch (NoResultException e) {
                m_logger.error(this.getClass().getSimpleName() + " failed -- Dataset with id=" + this.m_datasetId + " doesn't exist anymore in the database", (Throwable)e);
                this.m_taskError = new TaskError((Exception)((Object)e));
                try {
                    entityManagerUDS.getTransaction().rollback();
                }
                catch (Exception rollbackException) {
                    m_logger.error(this.getClass().getSimpleName() + " failed : potential network problem", (Throwable)rollbackException);
                }
                boolean rollbackException = false;
                entityManagerUDS.close();
                return rollbackException;
            }
            TypedQuery aggregationQuery = entityManagerUDS.createQuery("SELECT d.aggregation FROM Dataset d WHERE d.id = :dsId", Aggregation.class);
            aggregationQuery.setParameter("dsId", (Object)this.m_datasetId);
            Aggregation aggregation = (Aggregation)aggregationQuery.getSingleResult();
            ddataSet.setAggregation(aggregation);
            Query rsmDSQuery = entityManagerUDS.createQuery("SELECT d.id, d.resultSummaryId FROM Dataset d WHERE d.resultSummaryId IN (:listId) and d.project.id = :pjId ");
            rsmDSQuery.setParameter("listId", this.m_dsChildRSMIds);
            rsmDSQuery.setParameter("pjId", (Object)this.m_project.getId());
            HashMap dsIdPerRSMIds = new HashMap();
            for (Object[] resCur : rsmDSQuery.getResultList()) {
                Long dsId = (Long)resCur[0];
                Long rsmId = (Long)resCur[1];
                m_logger.debug("--- FOR RSM   " + rsmId + " DS = " + dsId);
                if (dsIdPerRSMIds.containsKey(rsmId)) {
                    ((List)dsIdPerRSMIds.get(rsmId)).add(dsId);
                    continue;
                }
                ArrayList<Long> rsmDSs = new ArrayList<Long>();
                rsmDSs.add(dsId);
                dsIdPerRSMIds.put(rsmId, rsmDSs);
            }
            Query dsQueries = entityManagerUDS.createQuery("SELECT d.id, d.parentDataset.id, d.name FROM Dataset d WHERE d.project.id = :pjId and d.parentDataset is not null ");
            dsQueries.setParameter("pjId", (Object)this.m_project.getId());
            List results = dsQueries.getResultList();
            HashMap<Long, Object[]> dsInfoPerDsIds = new HashMap<Long, Object[]>();
            for (Object[] resCur : results) {
                Long dsId = (Long)resCur[0];
                Object[] dsInfo = new Object[]{(Long)resCur[1], (String)resCur[2]};
                dsInfoPerDsIds.put(dsId, dsInfo);
            }
            entityManagerUDS.getTransaction().commit();
            for (Long nextRSMId : this.m_dsChildRSMIds) {
                boolean foundDS = false;
                Iterator rsmDSsIdIt = ((List)dsIdPerRSMIds.get(nextRSMId)).iterator();
                while (!foundDS && rsmDSsIdIt.hasNext()) {
                    Long nextDSId;
                    Long rsmDSId = nextDSId = (Long)rsmDSsIdIt.next();
                    while (!foundDS && nextDSId != null) {
                        if (this.m_datasetId.equals(nextDSId)) {
                            foundDS = true;
                            Object[] rsmDSInfo = (Object[])dsInfoPerDsIds.get(rsmDSId);
                            if (rsmDSInfo == null) {
                                this.m_dsNames.add(ddataSet.getName());
                                continue;
                            }
                            this.m_dsNames.add((String)rsmDSInfo[1]);
                            continue;
                        }
                        Object[] dsInfo = (Object[])dsInfoPerDsIds.get(nextDSId);
                        if (dsInfo == null) {
                            nextDSId = null;
                            continue;
                        }
                        nextDSId = (Long)dsInfo[0];
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renameDataset() {
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            String renameSQL = "UPDATE Dataset d set d.name= :name where d.id = :datasetId";
            Query renameQuery = entityManagerUDS.createQuery(renameSQL);
            renameQuery.setParameter("datasetId", (Object)this.m_dataset.getId());
            renameQuery.setParameter("name", (Object)this.m_name);
            renameQuery.executeUpdate();
            entityManagerUDS.getTransaction().commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearDataset() {
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            String updateSQL = this.m_action == 13 ? "UPDATE Dataset d set d.resultSetId=null,d.resultSummaryId=null where d.id = :datasetId" : "UPDATE Dataset d set d.resultSummaryId=null where d.id = :datasetId";
            Query updateQuery = entityManagerUDS.createQuery(updateSQL);
            updateQuery.setParameter("datasetId", (Object)this.m_dataset.getId());
            updateQuery.executeUpdate();
            entityManagerUDS.getTransaction().commit();
            this.m_dataset.setAggregationInformation(DDatasetType.AggregationInformation.UNKNOWN);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pasteDataset() {
        Object object = WRITE_DATASET_LOCK;
        synchronized (object) {
            EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();
            try {
                IdentificationDataset d;
                Dataset mergedParentDataset;
                entityManagerUDS.getTransaction().begin();
                long projectId = this.m_datasetCopy.getProjectId();
                Long resultSetId = this.m_datasetCopy.getResultSetId();
                Project mergedProject = (Project)entityManagerUDS.find(Project.class, (Object)projectId);
                Dataset dataset = mergedParentDataset = this.m_parentDataset == null ? null : (Dataset)entityManagerUDS.find(Dataset.class, (Object)this.m_parentDataset.getId());
                if (resultSetId != null) {
                    d = new IdentificationDataset();
                    d.setProject(mergedProject);
                    d.setType(Dataset.DatasetType.IDENTIFICATION);
                } else {
                    d = new Dataset(mergedProject);
                    d.setType(Dataset.DatasetType.AGGREGATE);
                    Aggregation aggregation = DatabaseDataManager.getDatabaseDataManager().getAggregation(this.m_datasetCopy.getDatasetType());
                    Aggregation mergedAggregation = (Aggregation)entityManagerUDS.merge((Object)aggregation);
                    d.setAggregation(mergedAggregation);
                }
                if (mergedParentDataset != null) {
                    mergedParentDataset.addChild((Dataset)d);
                } else {
                    int childrenCount = this.m_project.getTransientData().getChildrenNumber();
                    d.setNumber(childrenCount);
                    this.m_project.getTransientData().setChildrenNumber(childrenCount + 1);
                }
                d.setName(this.m_datasetCopy.getName());
                d.setResultSetId(this.m_datasetCopy.getResultSetId());
                d.setChildrenCount(0);
                this.pasteDatasetAddChildrenImpl(entityManagerUDS, mergedProject, (Dataset)d, this.m_datasetCopy);
                entityManagerUDS.persist((Object)d);
                if (mergedParentDataset != null) {
                    entityManagerUDS.merge((Object)mergedParentDataset);
                }
                DDataset ddataset = new DDataset(d.getId(), d.getProject(), d.getName(), d.getType(), d.getChildrenCount(), d.getResultSetId(), d.getResultSummaryId(), d.getNumber());
                ddataset.setAggregation(d.getAggregation());
                this.m_datasetList.add(ddataset);
                entityManagerUDS.getTransaction().commit();
            }
            catch (Exception e) {
                boolean bl;
                try {
                    m_logger.error(this.getClass().getSimpleName() + " failed", (Throwable)e);
                    this.m_taskError = new TaskError(e);
                    try {
                        entityManagerUDS.getTransaction().rollback();
                    }
                    catch (Exception rollbackException) {
                        m_logger.error(this.getClass().getSimpleName() + " failed : potential network problem", (Throwable)rollbackException);
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    entityManagerUDS.close();
                    throw throwable;
                }
                entityManagerUDS.close();
                return bl;
            }
            entityManagerUDS.close();
            return true;
        }
    }

    private Dataset pasteDatasetAddChildrenImpl(EntityManager entityManagerUDS, Project mergedProject, Dataset d, DatasetToCopy datasetCopy) {
        ArrayList<DatasetToCopy> copiedChildren = datasetCopy.getChildren();
        for (DatasetToCopy copy : copiedChildren) {
            d.addChild(this.pasteDatasetImpl(entityManagerUDS, mergedProject, copy));
        }
        return d;
    }

    private Dataset pasteDatasetImpl(EntityManager entityManagerUDS, Project mergedProject, DatasetToCopy datasetCopy) {
        IdentificationDataset d;
        Long resultSetId = datasetCopy.getResultSetId();
        if (resultSetId != null) {
            d = new IdentificationDataset();
            d.setProject(mergedProject);
            d.setType(Dataset.DatasetType.IDENTIFICATION);
        } else {
            d = new Dataset(mergedProject);
            d.setType(Dataset.DatasetType.AGGREGATE);
            Aggregation aggregation = DatabaseDataManager.getDatabaseDataManager().getAggregation(this.m_datasetCopy.getDatasetType());
            Aggregation mergedAggregation = (Aggregation)entityManagerUDS.merge((Object)aggregation);
            d.setAggregation(mergedAggregation);
        }
        d.setName(datasetCopy.getName());
        d.setResultSetId(datasetCopy.getResultSetId());
        d.setChildrenCount(0);
        this.pasteDatasetAddChildrenImpl(entityManagerUDS, mergedProject, (Dataset)d, datasetCopy);
        entityManagerUDS.persist((Object)d);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDataset(boolean identificationDataset) {
        Object object = WRITE_DATASET_LOCK;
        synchronized (object) {
            EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();
            try {
                entityManagerUDS.getTransaction().begin();
                if (this.m_hasSuffix) {
                    for (int i = this.m_suffixStart; i <= this.m_suffixStop; ++i) {
                        String datasetName = this.m_aggregateName + String.valueOf(i);
                        this.createDataSetImpl(entityManagerUDS, datasetName, identificationDataset);
                    }
                } else {
                    this.createDataSetImpl(entityManagerUDS, this.m_aggregateName, identificationDataset);
                }
                entityManagerUDS.getTransaction().commit();
            }
            catch (Exception e) {
                boolean bl;
                try {
                    m_logger.error(this.getClass().getSimpleName() + " failed", (Throwable)e);
                    this.m_taskError = new TaskError(e);
                    try {
                        entityManagerUDS.getTransaction().rollback();
                    }
                    catch (Exception rollbackException) {
                        m_logger.error(this.getClass().getSimpleName() + " failed : potential network problem", (Throwable)rollbackException);
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    entityManagerUDS.close();
                    throw throwable;
                }
                entityManagerUDS.close();
                return bl;
            }
            entityManagerUDS.close();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDatasetFolder(boolean identification) {
        Object object = WRITE_DATASET_LOCK;
        synchronized (object) {
            EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();
            try {
                entityManagerUDS.getTransaction().begin();
                this.createFolderImpl(entityManagerUDS, this.m_aggregateName, identification);
                entityManagerUDS.getTransaction().commit();
            }
            catch (Exception e) {
                boolean bl;
                try {
                    m_logger.error(this.getClass().getSimpleName() + " failed", (Throwable)e);
                    this.m_taskError = new TaskError(e);
                    try {
                        entityManagerUDS.getTransaction().rollback();
                    }
                    catch (Exception rollbackException) {
                        m_logger.error(this.getClass().getSimpleName() + " failed : potential network problem", (Throwable)rollbackException);
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    entityManagerUDS.close();
                    throw throwable;
                }
                entityManagerUDS.close();
                return bl;
            }
            entityManagerUDS.close();
            return true;
        }
    }

    private void createFolderImpl(EntityManager entityManagerUDS, String folderName, boolean identification) {
        Project mergedProject = (Project)entityManagerUDS.find(Project.class, (Object)this.m_project.getId());
        Dataset mergedParentDataset = this.m_parentDataset == null ? null : (Dataset)entityManagerUDS.find(Dataset.class, (Object)this.m_parentDataset.getId());
        Dataset d = new Dataset(mergedProject);
        if (identification) {
            d.setType(Dataset.DatasetType.IDENTIFICATION_FOLDER);
        } else {
            d.setType(Dataset.DatasetType.QUANTITATION_FOLDER);
        }
        Aggregation aggregation = DatabaseDataManager.getDatabaseDataManager().getAggregation(Aggregation.ChildNature.OTHER);
        Aggregation mergedAggregation = (Aggregation)entityManagerUDS.merge((Object)aggregation);
        d.setAggregation(mergedAggregation);
        d.setName(folderName);
        d.setResultSetId(this.m_resultSetId);
        d.setResultSummaryId(this.m_resultSummaryId);
        d.setChildrenCount(0);
        if (mergedParentDataset != null) {
            mergedParentDataset.addChild(d);
        } else {
            int childrenCount = this.m_project.getTransientData().getChildrenNumber();
            d.setNumber(childrenCount);
            this.m_project.getTransientData().setChildrenNumber(childrenCount + 1);
        }
        entityManagerUDS.persist((Object)d);
        if (mergedParentDataset != null) {
            entityManagerUDS.merge((Object)mergedParentDataset);
        }
        DDataset ddataset = new DDataset(d.getId(), d.getProject(), d.getName(), d.getType(), d.getChildrenCount(), d.getResultSetId(), d.getResultSummaryId(), d.getNumber());
        ddataset.setAggregation(d.getAggregation());
        this.m_datasetList.add(ddataset);
    }

    private void createDataSetImpl(EntityManager entityManagerUDS, String datasetName, boolean identificationDataset) {
        IdentificationDataset d;
        Dataset mergedParentDataset;
        Project mergedProject = (Project)entityManagerUDS.find(Project.class, (Object)this.m_project.getId());
        Dataset dataset = mergedParentDataset = this.m_parentDataset == null ? null : (Dataset)entityManagerUDS.find(Dataset.class, (Object)this.m_parentDataset.getId());
        if (identificationDataset) {
            d = new IdentificationDataset();
            d.setProject(mergedProject);
            d.setType(Dataset.DatasetType.IDENTIFICATION);
        } else {
            d = new Dataset(mergedProject);
            d.setType(Dataset.DatasetType.AGGREGATE);
            Aggregation aggregation = DatabaseDataManager.getDatabaseDataManager().getAggregation(this.m_datasetType);
            Aggregation mergedAggregation = (Aggregation)entityManagerUDS.merge((Object)aggregation);
            d.setAggregation(mergedAggregation);
        }
        d.setName(datasetName);
        d.setResultSetId(this.m_resultSetId);
        d.setResultSummaryId(this.m_resultSummaryId);
        d.setChildrenCount(0);
        if (mergedParentDataset != null) {
            mergedParentDataset.addChild((Dataset)d);
        } else {
            int childrenCount = this.m_project.getTransientData().getChildrenNumber();
            d.setNumber(childrenCount);
            this.m_project.getTransientData().setChildrenNumber(childrenCount + 1);
        }
        entityManagerUDS.persist((Object)d);
        if (mergedParentDataset != null) {
            entityManagerUDS.merge((Object)mergedParentDataset);
        }
        DDataset ddataset = new DDataset(d.getId(), d.getProject(), d.getName(), d.getType(), d.getChildrenCount(), d.getResultSetId(), d.getResultSummaryId(), d.getNumber());
        ddataset.setAggregation(d.getAggregation());
        this.m_datasetList.add(ddataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean modifyDatasetRSM() {
        Object object = WRITE_DATASET_LOCK;
        synchronized (object) {
            EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();
            try {
                entityManagerUDS.getTransaction().begin();
                Dataset mergedDataset = (Dataset)entityManagerUDS.find(Dataset.class, (Object)this.m_dataset.getId());
                this.m_dataset.setResultSummaryId(this.m_resultSummaryId);
                mergedDataset.setResultSummaryId(this.m_resultSummaryId);
                entityManagerUDS.merge((Object)mergedDataset);
                entityManagerUDS.getTransaction().commit();
            }
            catch (Exception e) {
                boolean bl;
                try {
                    m_logger.error(this.getClass().getSimpleName() + " failed", (Throwable)e);
                    this.m_taskError = new TaskError(e);
                    try {
                        entityManagerUDS.getTransaction().rollback();
                    }
                    catch (Exception rollbackException) {
                        m_logger.error(this.getClass().getSimpleName() + " failed : potential network problem", (Throwable)rollbackException);
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    entityManagerUDS.close();
                    throw throwable;
                }
                entityManagerUDS.close();
                return bl;
            }
            entityManagerUDS.close();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeValidationOfDataset() {
        Object object = WRITE_DATASET_LOCK;
        synchronized (object) {
            EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();
            try {
                entityManagerUDS.getTransaction().begin();
                Dataset mergedDataset = (Dataset)entityManagerUDS.find(Dataset.class, (Object)this.m_dataset.getId());
                this.m_dataset.setResultSummaryId(null);
                mergedDataset.setResultSummaryId(null);
                this.m_dataset.setResultSummary(null);
                mergedDataset.getTransientData().setResultSummary(null);
                entityManagerUDS.merge((Object)mergedDataset);
                entityManagerUDS.getTransaction().commit();
            }
            catch (Exception e) {
                boolean bl;
                try {
                    m_logger.error(this.getClass().getSimpleName() + " failed", (Throwable)e);
                    this.m_taskError = new TaskError(e);
                    try {
                        entityManagerUDS.getTransaction().rollback();
                    }
                    catch (Exception rollbackException) {
                        m_logger.error(this.getClass().getSimpleName() + " failed : potential network problem", (Throwable)rollbackException);
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    entityManagerUDS.close();
                    throw throwable;
                }
                entityManagerUDS.close();
                return bl;
            }
            entityManagerUDS.close();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean modifyDatasetRsetAndRsm() {
        Object object = WRITE_DATASET_LOCK;
        synchronized (object) {
            EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();
            try {
                entityManagerUDS.getTransaction().begin();
                Dataset mergedDataset = (Dataset)entityManagerUDS.find(Dataset.class, (Object)this.m_dataset.getId());
                this.m_dataset.setResultSetId(this.m_resultSetId);
                mergedDataset.setResultSetId(this.m_resultSetId);
                this.m_dataset.setResultSummaryId(this.m_resultSummaryId);
                mergedDataset.setResultSummaryId(this.m_resultSummaryId);
                entityManagerUDS.merge((Object)mergedDataset);
                entityManagerUDS.getTransaction().commit();
            }
            catch (Exception e) {
                boolean bl;
                try {
                    m_logger.error(this.getClass().getSimpleName() + " failed", (Throwable)e);
                    this.m_taskError = new TaskError(e);
                    try {
                        entityManagerUDS.getTransaction().rollback();
                    }
                    catch (Exception rollbackException) {
                        m_logger.error(this.getClass().getSimpleName() + " failed : potential network problem", (Throwable)rollbackException);
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    entityManagerUDS.close();
                    throw throwable;
                }
                entityManagerUDS.close();
                return bl;
            }
            entityManagerUDS.close();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean emptyTrash() {
        Object object = WRITE_DATASET_LOCK;
        synchronized (object) {
            EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();
            try {
                entityManagerUDS.getTransaction().begin();
                Dataset mergedTrash = (Dataset)entityManagerUDS.find(Dataset.class, (Object)this.m_dataset.getId());
                this.removeChildren(entityManagerUDS, mergedTrash, this.m_identificationDataset);
                List children = mergedTrash.getChildren();
                mergedTrash.setChildren(children);
                mergedTrash.setChildrenCount(children == null ? 0 : children.size());
                if (children != null) {
                    int pos = 0;
                    for (Dataset child : children) {
                        child.setNumber(pos);
                        entityManagerUDS.persist((Object)child);
                    }
                }
                entityManagerUDS.persist((Object)mergedTrash);
                entityManagerUDS.getTransaction().commit();
            }
            catch (Exception e) {
                boolean bl;
                try {
                    m_logger.error("updateDatasetAndProjectsTree failed", (Throwable)e);
                    try {
                        entityManagerUDS.getTransaction().rollback();
                    }
                    catch (Exception rollbackException) {
                        m_logger.error(this.getClass().getSimpleName() + " failed : potential network problem", (Throwable)rollbackException);
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    entityManagerUDS.close();
                    throw throwable;
                }
                entityManagerUDS.close();
                return bl;
            }
            entityManagerUDS.close();
            return true;
        }
    }

    private void removeChildren(EntityManager entityManagerUDS, Dataset d, boolean identificationTrash) {
        boolean isDatasetIdentification;
        List children = d.getChildren();
        if (children != null) {
            int nbChildren = children.size();
            for (int i = nbChildren - 1; i >= 0; --i) {
                boolean isDatasetIdentification2;
                Dataset child = (Dataset)children.get(i);
                this.removeChildren(entityManagerUDS, child, identificationTrash);
                boolean bl = isDatasetIdentification2 = child.getMethod() == null;
                if ((!isDatasetIdentification2 || !identificationTrash) && (isDatasetIdentification2 || identificationTrash)) continue;
                children.remove(child);
            }
        }
        boolean bl = isDatasetIdentification = d.getMethod() == null;
        if (isDatasetIdentification && identificationTrash || !isDatasetIdentification && !identificationTrash) {
            entityManagerUDS.remove((Object)d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateDatasetAndProjectsTree(LinkedHashMap<Object, ArrayList<DDataset>> databaseObjectsToModify, boolean identificationTree) {
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            for (Object parentObject : databaseObjectsToModify.keySet()) {
                int i;
                ArrayList<DDataset> datasetList = databaseObjectsToModify.get(parentObject);
                int nbDataset = datasetList.size();
                ArrayList<Dataset> mergedDatasetList = new ArrayList<Dataset>(nbDataset);
                boolean childrenNotLoaded = false;
                for (int i2 = 0; i2 < nbDataset; ++i2) {
                    DDataset dataset = datasetList.get(i2);
                    if (dataset == null) {
                        childrenNotLoaded = true;
                        continue;
                    }
                    Dataset mergedDataset = (Dataset)entityManagerUDS.find(Dataset.class, (Object)dataset.getId());
                    mergedDatasetList.add(mergedDataset);
                }
                Dataset mergedParentDataset = null;
                if (parentObject instanceof DDataset) {
                    DDataset parentDataset = (DDataset)parentObject;
                    mergedParentDataset = (Dataset)entityManagerUDS.find(Dataset.class, (Object)parentDataset.getId());
                    if (mergedParentDataset.getType() == Dataset.DatasetType.TRASH) {
                        if (identificationTree) {
                            datasetQuery = entityManagerUDS.createQuery("SELECT new fr.proline.core.orm.uds.dto.DDataset(d.id, d.project, d.name,  d.type, d.childCount, d.resultSetId, d.resultSummaryId, d.number)  FROM Dataset d WHERE d.parentDataset.id=:parentDatasetId AND d.type=:quantitationType ORDER BY d.number ASC", DDataset.class);
                            datasetQuery.setParameter("parentDatasetId", (Object)mergedParentDataset.getId());
                            datasetQuery.setParameter("quantitationType", (Object)Dataset.DatasetType.QUANTITATION);
                            List quantiInTrash = datasetQuery.getResultList();
                            mergedParentDataset.replaceAllChildren(mergedDatasetList);
                            for (DDataset aQuantiInTrash : quantiInTrash) {
                                wholeDataset = (Dataset)entityManagerUDS.find(Dataset.class, (Object)aQuantiInTrash.getId());
                                mergedParentDataset.addChild(wholeDataset);
                            }
                        } else {
                            datasetQuery = entityManagerUDS.createQuery("SELECT new fr.proline.core.orm.uds.dto.DDataset(d.id, d.project, d.name,  d.type, d.childCount, d.resultSetId, d.resultSummaryId, d.number)  FROM Dataset d WHERE d.parentDataset.id=:parentDatasetId AND d.type<>:quantitationType ORDER BY d.number ASC", DDataset.class);
                            datasetQuery.setParameter("parentDatasetId", (Object)mergedParentDataset.getId());
                            datasetQuery.setParameter("quantitationType", (Object)Dataset.DatasetType.QUANTITATION);
                            List identificationInTrash = datasetQuery.getResultList();
                            mergedParentDataset.replaceAllChildren(mergedDatasetList);
                            for (DDataset aIdentificationInTrash : identificationInTrash) {
                                wholeDataset = (Dataset)entityManagerUDS.find(Dataset.class, (Object)aIdentificationInTrash.getId());
                                mergedParentDataset.addChild(wholeDataset);
                            }
                        }
                        List childs = mergedParentDataset.getChildren();
                        int pos = 0;
                        for (Dataset dataset : childs) {
                            dataset.setNumber(pos);
                            ++pos;
                        }
                    } else if (childrenNotLoaded) {
                        for (i = 0; i < mergedDatasetList.size(); ++i) {
                            mergedParentDataset.addChild((Dataset)mergedDatasetList.get(i));
                        }
                    } else {
                        mergedParentDataset.replaceAllChildren(mergedDatasetList);
                    }
                    parentDataset.setChildrenCount(mergedParentDataset.getChildrenCount());
                } else if (parentObject instanceof Project) {
                    Project parentProject = (Project)parentObject;
                    if (identificationTree) {
                        parentProject.getTransientData().setChildrenNumber(nbDataset);
                    }
                    for (i = 0; i < mergedDatasetList.size(); ++i) {
                        Dataset mergedChildDataset = (Dataset)mergedDatasetList.get(i);
                        mergedChildDataset.setNumber(i);
                    }
                }
                for (i = 0; i < mergedDatasetList.size(); ++i) {
                    Dataset mergedDataset = (Dataset)mergedDatasetList.get(i);
                    entityManagerUDS.merge((Object)mergedDataset);
                }
                if (mergedParentDataset == null) continue;
                entityManagerUDS.merge((Object)mergedParentDataset);
            }
            entityManagerUDS.getTransaction().commit();
        }
        return true;
    }
}

