/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.msi.PeptideInstance;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.core.orm.util.TransientDataAllocationListener;
import fr.proline.studio.dam.memory.TransientMemoryCacheManager;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseSlicerTask;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseBioSequenceTask;
import fr.proline.studio.dam.tasks.SubTask;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class DatabaseProteinSetsTask
extends AbstractDatabaseSlicerTask {
    private static final int SLICE_SIZE = 1000;
    public static final int SUB_TASK_TYPICAL_PROTEIN = 0;
    public static final int SUB_TASK_SPECTRAL_COUNT = 1;
    public static final int SUB_TASK_SPECIFIC_SPECTRAL_COUNT = 2;
    public static final int SUB_TASK_SAMESET_SUBSET_COUNT = 3;
    public static final int SUB_TASK_COUNT = 4;
    private int m_action;
    private static final int LOAD_PROTEIN_SET_FOR_RSM = 0;
    private static final int LOAD_PROTEIN_SET_FOR_PEPTIDE_INSTANCE = 1;
    private long m_projectId = -1L;
    private ResultSummary m_rsm = null;
    private PeptideInstance m_peptideInstance = null;
    private ArrayList<Long> m_proteinMatchIds = null;
    private HashMap<Long, DProteinSet> m_proteinSetMap = null;
    private ArrayList<Long> m_proteinSetIds = null;

    public DatabaseProteinSetsTask(AbstractDatabaseCallback callback) {
        super(callback);
    }

    public void initLoadProteinSets(long projectId, ResultSummary rsm) {
        this.init(4, new TaskInfo("Load Protein Sets of Identification Summary " + rsm.getId(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_rsm = rsm;
        this.m_action = 0;
    }

    public void initLoadProteinSetForPeptideInstance(long projectId, PeptideInstance peptideInstance) {
        this.init(4, new TaskInfo("Load Protein Sets for Peptide Instance " + peptideInstance.getId(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_projectId = projectId;
        this.m_peptideInstance = peptideInstance;
        this.m_rsm = peptideInstance.getResultSummary();
        this.m_action = 1;
    }

    @Override
    public void abortTask() {
        super.abortTask();
        switch (this.m_action) {
            case 0: {
                this.m_rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setProteinSetArray(null);
                break;
            }
            case 1: {
                this.m_peptideInstance.getTransientData().setProteinSetArray(null);
            }
        }
    }

    @Override
    public boolean needToFetch() {
        switch (this.m_action) {
            case 0: {
                return this.m_rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getProteinSetArray() == null;
            }
            case 1: {
                return this.m_peptideInstance.getTransientData().getProteinSetArray() == null;
            }
        }
        return false;
    }

    @Override
    public boolean fetchData() {
        if (this.m_action == 0) {
            if (this.needToFetch()) {
                return this.fetchDataMainTaskForRSM();
            }
            return this.fetchDataSubTaskFor();
        }
        if (this.m_action == 1) {
            if (this.needToFetch()) {
                return this.fetchDataMainTaskForPeptideInstance();
            }
            return this.fetchDataSubTaskFor();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataMainTaskForRSM() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            Long rsmId = this.m_rsm.getId();
            TypedQuery proteinSetsQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DProteinSet(ps.id, ps.representativeProteinMatchId ,ps.resultSummary.id) FROM PeptideSet pepset JOIN pepset.proteinSet as ps WHERE ps.resultSummary.id=:rsmId AND ps.isValidated=true ORDER BY pepset.score DESC", DProteinSet.class);
            proteinSetsQuery.setParameter("rsmId", (Object)rsmId);
            List proteinSets = proteinSetsQuery.getResultList();
            DProteinSet[] proteinSetArray = proteinSets.toArray(new DProteinSet[proteinSets.size()]);
            this.m_rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setProteinSetArray(proteinSetArray);
            boolean bl = this.fetchDataMainTask(entityManagerMSI, proteinSetArray);
            return bl;
        }
    }

    private boolean fetchDataMainTask(EntityManager entityManagerMSI, DProteinSet[] proteinSetArray) {
        this.m_proteinSetMap = new HashMap();
        for (DProteinSet proteinSetCur : proteinSetArray) {
            this.m_proteinSetMap.put(proteinSetCur.getId(), proteinSetCur);
        }
        int nbProteinSets = proteinSetArray.length;
        this.m_proteinMatchIds = new ArrayList(nbProteinSets);
        this.m_proteinSetIds = new ArrayList(nbProteinSets);
        for (int i = 0; i < nbProteinSets; ++i) {
            this.m_proteinMatchIds.add(i, proteinSetArray[i].getProteinMatchId());
            this.m_proteinSetIds.add(i, proteinSetArray[i].getId());
        }
        if (nbProteinSets > 0) {
            SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(0, this.m_proteinMatchIds.size(), 1000);
            this.typicalProteinMatch(entityManagerMSI, subTask);
            subTask = this.m_subTaskManager.sliceATaskAndGetFirst(1, this.m_proteinSetIds.size(), 1000);
            this.spectralCount(entityManagerMSI, subTask);
            subTask = this.m_subTaskManager.sliceATaskAndGetFirst(2, this.m_proteinSetIds.size(), 1000);
            this.specificSpectralCount(entityManagerMSI, subTask);
        }
        if (nbProteinSets > 0) {
            SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(3, this.m_proteinSetIds.size(), 1000);
            this.sameSetAndSubSetInfo(entityManagerMSI, this.m_proteinSetIds, subTask);
        }
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataMainTaskForPeptideInstance() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            Long pepInstanceId = this.m_peptideInstance.getId();
            TypedQuery proteinSetsQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DProteinSet(prots.id, prots.representativeProteinMatchId ,prots.resultSummary.id) FROM fr.proline.core.orm.msi.ProteinSet prots, fr.proline.core.orm.msi.PeptideSet peps, fr.proline.core.orm.msi.PeptideSetPeptideInstanceItem peps_to_pepi WHERE peps.proteinSet=prots AND peps.id=peps_to_pepi.id.peptideSetId AND peps_to_pepi.id.peptideInstanceId=:peptideInstanceId AND prots.isValidated=true ORDER BY peps.score DESC", DProteinSet.class);
            proteinSetsQuery.setParameter("peptideInstanceId", (Object)pepInstanceId);
            List proteinSets = proteinSetsQuery.getResultList();
            DProteinSet[] proteinSetArray = proteinSets.toArray(new DProteinSet[proteinSets.size()]);
            this.m_peptideInstance.getTransientData().setProteinSetArray(proteinSetArray);
            boolean bl = this.fetchDataMainTask(entityManagerMSI, proteinSetArray);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataSubTaskFor() {
        SubTask slice = this.m_subTaskManager.getNextSubTask();
        if (slice == null) {
            return true;
        }
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            switch (slice.getSubTaskId()) {
                case 0: {
                    this.typicalProteinMatch(entityManagerMSI, slice);
                    break;
                }
                case 1: {
                    this.spectralCount(entityManagerMSI, slice);
                    break;
                }
                case 2: {
                    this.specificSpectralCount(entityManagerMSI, slice);
                    break;
                }
                case 3: {
                    this.sameSetAndSubSetInfo(entityManagerMSI, this.m_proteinSetIds, slice);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    private void typicalProteinMatch(EntityManager entityManagerMSI, SubTask subTask) {
        DProteinSet[] proteinSetArray = null;
        if (this.m_action == 0) {
            proteinSetArray = this.m_rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getProteinSetArray();
        } else if (this.m_action == 1) {
            proteinSetArray = this.m_peptideInstance.getTransientData().getProteinSetArray();
        }
        List sliceOfProteinMatchIds = subTask.getSubList(this.m_proteinMatchIds);
        TypedQuery typicalProteinQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DProteinMatch(pm.id, pm.accession, pm.score, pm.peptideCount, pm.resultSet.id, pm.description, pm.geneName, pm.serializedProperties, pepset.id, pepset.score, pepset.sequenceCount, pepset.peptideCount, pepset.peptideMatchCount, pepset.resultSummaryId) FROM PeptideSetProteinMatchMap pset_to_pm JOIN pset_to_pm.proteinMatch as pm JOIN pset_to_pm.peptideSet as pepset WHERE pm.id IN (:listId) AND pset_to_pm.resultSummary.id=:rsmId", DProteinMatch.class);
        typicalProteinQuery.setParameter("listId", (Object)sliceOfProteinMatchIds);
        typicalProteinQuery.setParameter("rsmId", (Object)this.m_rsm.getId());
        List typicalProteinMatches = typicalProteinQuery.getResultList();
        HashMap<Long, DProteinMatch> typicalProteinMap = new HashMap<Long, DProteinMatch>();
        for (DProteinMatch pmCur : typicalProteinMatches) {
            typicalProteinMap.put(pmCur.getId(), pmCur);
        }
        DatabaseBioSequenceTask.fetchData(typicalProteinMap.values().stream().collect(Collectors.toList()), this.m_projectId);
        for (int i = subTask.getStartIndex(); i <= subTask.getStopIndex(); ++i) {
            DProteinSet proteinSetCur = proteinSetArray[i];
            proteinSetCur.setTypicalProteinMatch((DProteinMatch)typicalProteinMap.get(proteinSetCur.getProteinMatchId()));
        }
    }

    private void spectralCount(EntityManager entityManagerMSI, SubTask subTask) {
        DProteinSet[] proteinSetArray = null;
        if (this.m_action == 0) {
            proteinSetArray = this.m_rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getProteinSetArray();
        } else if (this.m_action == 1) {
            proteinSetArray = this.m_peptideInstance.getTransientData().getProteinSetArray();
        }
        List sliceOfProteinSetIds = subTask.getSubList(this.m_proteinSetIds);
        HashMap<Long, Integer> spectralCountMap = new HashMap<Long, Integer>();
        String spectralCountQueryString = "SELECT ps.representativeProteinMatchId, sum(pi.totalLeavesMatchCount), sum(pi.peptideMatchCount) FROM ProteinSet ps, PeptideSet pepS, PeptideInstance pi, PeptideSetPeptideInstanceItem ps_to_pi WHERE ps.id IN (:proteinSetIds) AND ps_to_pi.id.peptideSetId = pepS.id AND  ps_to_pi.id.peptideInstanceId=pi.id AND pepS.proteinSet.id = ps.id AND ps.resultSummary.id=:rsmId AND ps.resultSummary.id=ps_to_pi.resultSummary.id AND ps.resultSummary.id=pepS.resultSummaryId GROUP BY ps.id";
        Query spectralCountQuery = entityManagerMSI.createQuery(spectralCountQueryString);
        spectralCountQuery.setParameter("proteinSetIds", (Object)sliceOfProteinSetIds);
        spectralCountQuery.setParameter("rsmId", (Object)this.m_rsm.getId());
        List spectralCountRes = spectralCountQuery.getResultList();
        for (Object[] cur : spectralCountRes) {
            boolean mergedData;
            Long proteinMatchId = (Long)cur[0];
            Integer spectralCount = ((Long)cur[1]).intValue();
            Integer peptideMatchCount = ((Long)cur[2]).intValue();
            if (spectralCount > 0) {
                spectralCountMap.put(proteinMatchId, spectralCount);
                continue;
            }
            ResultSet.Type rsType = this.m_rsm.getResultSet().getType();
            boolean bl = mergedData = rsType == ResultSet.Type.USER || rsType == ResultSet.Type.DECOY_USER;
            if (!mergedData) {
                spectralCountMap.put(proteinMatchId, peptideMatchCount);
                continue;
            }
            spectralCountMap.put(proteinMatchId, -1);
        }
        for (int i = subTask.getStartIndex(); i <= subTask.getStopIndex(); ++i) {
            DProteinSet proteinSetCur = proteinSetArray[i];
            long proteinMatchId = proteinSetCur.getProteinMatchId();
            Integer spectralCount = (Integer)spectralCountMap.get(proteinMatchId);
            if (spectralCount == null) continue;
            proteinSetCur.setSpectralCount(spectralCount);
        }
    }

    private void specificSpectralCount(EntityManager entityManagerMSI, SubTask subTask) {
        Integer specificSpectralCount;
        DProteinSet[] proteinSetArray = null;
        if (this.m_action == 0) {
            proteinSetArray = this.m_rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getProteinSetArray();
        } else if (this.m_action == 1) {
            proteinSetArray = this.m_peptideInstance.getTransientData().getProteinSetArray();
        }
        List sliceOfProteinSetIds = subTask.getSubList(this.m_proteinSetIds);
        HashMap<Long, Integer> spectralCountMap = new HashMap<Long, Integer>();
        String specificSpectralCountQueryString = "SELECT ps.representativeProteinMatchId, sum(pi.totalLeavesMatchCount), sum(pi.peptideMatchCount) FROM ProteinSet ps, PeptideSet pepS, PeptideInstance pi, PeptideSetPeptideInstanceItem ps_to_pi WHERE ps.id IN (:proteinSetIds) AND ps_to_pi.id.peptideSetId = pepS.id AND  ps_to_pi.id.peptideInstanceId=pi.id AND pepS.proteinSet.id = ps.id AND ps.resultSummary.id=:rsmId AND ps.resultSummary.id=ps_to_pi.resultSummary.id AND ps.resultSummary.id=pepS.resultSummaryId AND pi.validatedProteinSetCount=1 GROUP BY ps.id";
        Query specificSpectralCountQuery = entityManagerMSI.createQuery(specificSpectralCountQueryString);
        specificSpectralCountQuery.setParameter("proteinSetIds", (Object)sliceOfProteinSetIds);
        specificSpectralCountQuery.setParameter("rsmId", (Object)this.m_rsm.getId());
        List specificSpectralCountRes = specificSpectralCountQuery.getResultList();
        for (Object[] cur : specificSpectralCountRes) {
            boolean mergedData;
            Long proteinMatchId = (Long)cur[0];
            specificSpectralCount = ((Long)cur[1]).intValue();
            Integer peptideMatchCount = ((Long)cur[2]).intValue();
            if (specificSpectralCount > 0) {
                spectralCountMap.put(proteinMatchId, specificSpectralCount);
                continue;
            }
            ResultSet.Type rsType = this.m_rsm.getResultSet().getType();
            boolean bl = mergedData = rsType == ResultSet.Type.USER || rsType == ResultSet.Type.DECOY_USER;
            if (!mergedData) {
                spectralCountMap.put(proteinMatchId, peptideMatchCount);
                continue;
            }
            spectralCountMap.put(proteinMatchId, -1);
        }
        if (specificSpectralCountRes.size() < sliceOfProteinSetIds.size()) {
            for (Long proteinSetId : sliceOfProteinSetIds) {
                DProteinSet proteinSet = this.m_proteinSetMap.get(proteinSetId);
                Long proteinMatchId = proteinSet.getProteinMatchId();
                if (spectralCountMap.containsKey(proteinMatchId)) continue;
                spectralCountMap.put(proteinMatchId, 0);
            }
        }
        for (int i = subTask.getStartIndex(); i <= subTask.getStopIndex(); ++i) {
            DProteinSet proteinSetCur = proteinSetArray[i];
            specificSpectralCount = (Integer)spectralCountMap.get(proteinSetCur.getProteinMatchId());
            if (specificSpectralCount == null) continue;
            proteinSetCur.setSpecificSpectralCount(specificSpectralCount);
        }
    }

    private void sameSetAndSubSetInfo(EntityManager entityManagerMSI, ArrayList<Long> proteinSetIds, SubTask subTask) {
        List sliceOfProteinSetIds = subTask.getSubList(proteinSetIds);
        String allCountQueryString = "SELECT ps.id, pspmi.is_in_subset, count(pm), string_agg(pm.accession,', ') FROM protein_set ps left outer join protein_set_protein_match_item pspmi on ps.id = pspmi.protein_set_id left outer join protein_match pm on pspmi.protein_match_id = pm.id  WHERE pspmi.result_summary_id = ?1  AND ps.id IN (?2)  GROUP BY ps.id, pspmi.is_in_subset ";
        Query allCountQuery = entityManagerMSI.createNativeQuery(allCountQueryString);
        allCountQuery.setParameter(1, (Object)this.m_rsm.getId());
        allCountQuery.setParameter(2, (Object)sliceOfProteinSetIds);
        HashMap<Long, Object> sameSubSetAccByProtSetId = new HashMap<Long, Object>();
        List allCountRes = allCountQuery.getResultList();
        for (Object[] cur : allCountRes) {
            Long proteinSetId = ((BigInteger)cur[0]).longValue();
            Boolean isInSubset = (Boolean)cur[1];
            int proteinsCount = ((BigInteger)cur[2]).intValue();
            String allAccessions = cur[3].toString();
            DProteinSet proteinSet = this.m_proteinSetMap.get(proteinSetId);
            if (isInSubset.booleanValue()) {
                proteinSet.setSubSetCount(Integer.valueOf(proteinsCount));
            } else {
                proteinSet.setSameSetCount(Integer.valueOf(proteinsCount));
            }
            if (sameSubSetAccByProtSetId.containsKey(proteinSetId)) {
                String finalAccList = (String)sameSubSetAccByProtSetId.get(proteinSetId) + ", " + allAccessions;
                sameSubSetAccByProtSetId.put(proteinSetId, finalAccList);
                continue;
            }
            sameSubSetAccByProtSetId.put(proteinSetId, allAccessions);
        }
        for (Long id : sameSubSetAccByProtSetId.keySet()) {
            String allAcc = (String)sameSubSetAccByProtSetId.get(id);
            String[] accAsArray = allAcc.split(", ");
            DProteinSet proteinSet = this.m_proteinSetMap.get(id);
            proteinSet.setSameSubSetNames(accAsArray);
            if (proteinSet.getSubSetCount() != null) continue;
            proteinSet.setSubSetCount(Integer.valueOf(0));
        }
    }
}

