/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks.data.ptm;

import fr.proline.core.orm.msi.dto.DInfoPTM;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.studio.dam.tasks.data.ptm.AbstractJSONPTMSite;
import fr.proline.studio.dam.tasks.data.ptm.JSONPTMSite;
import fr.proline.studio.dam.tasks.data.ptm.JSONPTMSite2;
import fr.proline.studio.dam.tasks.data.ptm.PTMDataset;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.dam.tasks.data.ptm.PTMSitePeptideInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PTMSite {
    private Long m_id;
    private final AbstractJSONPTMSite m_site;
    private DInfoPTM m_ptmSpecificity;
    private DProteinMatch m_proteinMatch;
    private DMasterQuantProteinSet m_masterQuantProteinSet;
    private DPeptideMatch m_bestPeptideMatch;
    private Map<Long, PTMSitePeptideInstance> m_ptmSitePeptideInstanceByPepId;
    private Map<Long, Integer> m_ptmPositionByPeptideId;
    private List<DPeptideInstance> m_parentPeptideInstances;
    private PTMDataset m_dataset;
    private Optional<Boolean> isNtermSite = Optional.empty();
    private Optional<Boolean> isCtermSite = Optional.empty();

    public PTMSite(AbstractJSONPTMSite jsonSite, DProteinMatch proteinMatch) {
        this.m_site = jsonSite;
        this.m_proteinMatch = proteinMatch;
        this.m_id = -1L;
        if (this.m_site instanceof JSONPTMSite2) {
            this.m_id = ((JSONPTMSite2)this.m_site).id;
            this.isCtermSite = Optional.ofNullable(((JSONPTMSite2)this.m_site).isCTerminal);
            this.isNtermSite = Optional.ofNullable(((JSONPTMSite2)this.m_site).isNTerminal);
        }
    }

    public Long getId() {
        return this.m_id;
    }

    public AbstractJSONPTMSite getJSONPtmSite() {
        return this.m_site;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.m_proteinMatch != null) {
            builder.append(this.m_proteinMatch.getAccession()).append("-");
        } else {
            builder.append("Protein Match ID").append(this.m_site.proteinMatchId).append("-");
        }
        builder.append(this.toProteinReadablePtmString());
        return builder.toString();
    }

    public void setProteinMatch(DProteinMatch proteinMatch) {
        this.m_proteinMatch = proteinMatch;
    }

    public DProteinMatch getProteinMatch() {
        return this.m_proteinMatch;
    }

    public void setBestProbabilityPepMatch(DPeptideMatch peptideMatch) {
        this.m_bestPeptideMatch = peptideMatch;
    }

    public DPeptideMatch getMostConfidentPepMatch() {
        return this.m_bestPeptideMatch;
    }

    public Long getBestProbabilityPepMatchId() {
        if (this.m_bestPeptideMatch != null) {
            return this.m_bestPeptideMatch.getId();
        }
        return this.m_site.bestPeptideMatchId;
    }

    public void setPTMSpecificity(DInfoPTM specificity) {
        this.m_ptmSpecificity = specificity;
    }

    public DInfoPTM getPTMSpecificity() {
        return this.m_ptmSpecificity;
    }

    public void addPeptideInstances(List<DPeptideInstance> parentPeptideInstances, List<DPeptideInstance> leafInstances) {
        if (this.m_parentPeptideInstances == null) {
            this.m_parentPeptideInstances = new ArrayList<DPeptideInstance>();
        }
        this.m_parentPeptideInstances.addAll(parentPeptideInstances);
        if (this.m_ptmSitePeptideInstanceByPepId == null) {
            this.m_ptmSitePeptideInstanceByPepId = new HashMap<Long, PTMSitePeptideInstance>();
        }
        this.linkPeptideInstances(parentPeptideInstances, leafInstances);
    }

    private void linkPeptideInstances(List<DPeptideInstance> parentPeptideInstances, List<DPeptideInstance> leafInstances) {
        Map<Long, List<DPeptideInstance>> leafPepInstanceByPepId = leafInstances.stream().collect(Collectors.groupingBy(pi -> pi.getPeptideId()));
        for (DPeptideInstance parentPeptideInstance : parentPeptideInstances) {
            PTMPeptideInstance parentPTMPeptideInst = this.m_dataset.getPTMPeptideInstance(this.m_proteinMatch, parentPeptideInstance, this.m_site.seqPosition);
            Long peptideId = parentPeptideInstance.getPeptideId();
            parentPTMPeptideInst.setStartPosition(this.getPositionOnProtein() - this.getPositionOnPeptide(peptideId));
            parentPTMPeptideInst.addPTMSite(this);
            List<DPeptideInstance> leafPeptideInstances = leafPepInstanceByPepId.get(peptideId);
            PTMSitePeptideInstance ptmSitePeptideInstance = new PTMSitePeptideInstance(this, parentPTMPeptideInst, leafPeptideInstances, this.getMostConfidentPepMatch(leafPeptideInstances));
            this.m_ptmSitePeptideInstanceByPepId.put(peptideId, ptmSitePeptideInstance);
        }
    }

    public List<DPeptideInstance> getParentPeptideInstances() {
        return this.m_parentPeptideInstances;
    }

    public void setQuantProteinSet(DMasterQuantProteinSet mqps) {
        this.m_masterQuantProteinSet = mqps;
    }

    public PTMSitePeptideInstance getPTMSitePeptideInstance(Long peptideId) {
        return this.m_ptmSitePeptideInstanceByPepId.get(peptideId);
    }

    public List<PTMSitePeptideInstance> getPTMSitePeptideInstances() {
        return new ArrayList<PTMSitePeptideInstance>(this.m_ptmSitePeptideInstanceByPepId.values());
    }

    public Integer getPeptideCount() {
        return this.getPtmPositionByPeptideId().keySet().size();
    }

    public boolean isLoaded() {
        return this.m_ptmSitePeptideInstanceByPepId != null;
    }

    private DPeptideMatch getMostConfidentPepMatch(List<DPeptideInstance> peptideInstances) {
        List<DPeptideMatch> pepMatches = peptideInstances.stream().flatMap(pi -> Optional.ofNullable(pi.getPeptideMatches()).map(Collection::stream).orElseGet(Stream::empty)).collect(Collectors.toList());
        Float[] bestProba = new Float[]{Float.valueOf(0.0f)};
        DPeptideMatch[] bestPM = new DPeptideMatch[1];
        pepMatches.sort(Comparator.comparing(DPeptideMatch::getScore).reversed());
        pepMatches.forEach(pepMatch -> {
            int position = this.getPositionOnPeptide(pepMatch.getPeptide().getId());
            Float proba = (Float)pepMatch.getPtmSiteProperties().getMascotProbabilityBySite().get(this.m_ptmSpecificity.toReadablePtmString(position));
            if (proba == null) {
                proba = (Float)pepMatch.getPtmSiteProperties().getMascotProbabilityBySite().get(this.m_ptmSpecificity.toOtherReadablePtmString(position));
            }
            if (proba != null && proba.floatValue() > bestProba[0].floatValue()) {
                bestPM[0] = pepMatch;
                bestProba[0] = proba;
            }
        });
        return bestPM[0];
    }

    private Map<Long, Integer> getPtmPositionByPeptideId() {
        if (this.m_ptmPositionByPeptideId == null) {
            this.m_ptmPositionByPeptideId = new HashMap<Long, Integer>();
            for (Map.Entry<Integer, List<Long>> entry : this.m_site.peptideIdsByPtmPosition.entrySet()) {
                for (Long pepId : entry.getValue()) {
                    this.m_ptmPositionByPeptideId.put(pepId, entry.getKey());
                }
            }
        }
        return this.m_ptmPositionByPeptideId;
    }

    public List<PTMPeptideInstance> getAssociatedPTMPeptideInstances() {
        List<PTMPeptideInstance> res = this.m_ptmSitePeptideInstanceByPepId.values().stream().map(ptmSitePepInst -> ptmSitePepInst.getParentPTMPeptideInstance()).collect(Collectors.toList());
        return res;
    }

    public String toProteinReadablePtmString() {
        StringBuilder builder = new StringBuilder();
        if (this.m_ptmSpecificity != null) {
            builder.append(this.m_ptmSpecificity.getPtmShortName()).append("(");
            if (this.m_ptmSpecificity.getLocationSpecificity().equals("Anywhere")) {
                builder.append(this.m_ptmSpecificity.getResidueAASpecificity());
            } else {
                builder.append(this.m_ptmSpecificity.getLocationSpecificity());
            }
            builder.append(")-");
        } else {
            builder.append("PTM ID").append(this.m_site.ptmDefinitionId).append("-");
        }
        builder.append(this.m_site.seqPosition);
        return builder.toString();
    }

    public String peptideSpecificReadablePtmString(Long peptideId) {
        Integer pepPosition = this.getPositionOnPeptide(peptideId);
        StringBuilder builder = new StringBuilder();
        if (this.m_ptmSpecificity != null) {
            builder.append(this.m_ptmSpecificity.getPtmShortName()).append("(");
            if (this.m_ptmSpecificity.getLocationSpecificity().equals("Anywhere")) {
                builder.append(this.m_ptmSpecificity.getResidueAASpecificity());
            } else {
                builder.append(this.m_ptmSpecificity.getLocationSpecificity());
            }
            builder.append(pepPosition).append(")");
        } else {
            builder.append("PTM ID").append(this.m_site.ptmDefinitionId).append("-").append(pepPosition);
        }
        return builder.toString();
    }

    public String toReadablePtmString(Long peptideId) {
        return this.m_ptmSpecificity.toReadablePtmString(this.getPositionOnPeptide(peptideId).intValue());
    }

    public String toOtherReadablePtmString(Long peptideId) {
        return this.m_ptmSpecificity.toOtherReadablePtmString(this.getPositionOnPeptide(peptideId).intValue());
    }

    public Integer getPositionOnPeptide(Long peptideId) {
        return this.getPtmPositionByPeptideId().get(peptideId);
    }

    public Float getLocalisationConfidence() {
        return this.m_site.localizationConfidence;
    }

    public DMasterQuantProteinSet getMasterQuantProteinSet() {
        return this.m_masterQuantProteinSet;
    }

    public void setDataset(PTMDataset ptmDataset) {
        this.m_dataset = ptmDataset;
    }

    public PTMDataset getPTMdataset() {
        return this.m_dataset;
    }

    public Long[] getPeptideInstanceIds() {
        if (JSONPTMSite.class.isInstance(this.m_site)) {
            return ((JSONPTMSite)this.m_site).peptideInstanceIds;
        }
        return null;
    }

    public ArrayList<Long> getPeptideIds() {
        return new ArrayList<Long>(this.getPtmPositionByPeptideId().keySet());
    }

    public Integer getPositionOnProtein() {
        return this.m_site.seqPosition;
    }

    public boolean isNterm() {
        return this.isNtermSite.orElseGet(() -> this.m_ptmSpecificity.getLocationSpecificity().toLowerCase().endsWith("n-term"));
    }

    public boolean isCterm() {
        return this.isCtermSite.orElseGet(() -> this.m_ptmSpecificity.getLocationSpecificity().toLowerCase().endsWith("c-term"));
    }

    public boolean isProteinNTerm() {
        return this.m_ptmSpecificity.getLocationSpecificity().endsWith("N-term");
    }

    public boolean isProteinCTerm() {
        return this.m_ptmSpecificity.getLocationSpecificity().endsWith("C-term");
    }

    public boolean isProteinNTermWithOutM() {
        return this.m_ptmSpecificity.getLocationSpecificity().endsWith("N-term") && this.getPositionOnProtein() == 1;
    }
}

