/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.repository;

import fr.profi.util.PropertiesUtils;
import fr.profi.util.StringUtils;
import fr.proline.repository.ConnectionWrapper;
import fr.proline.repository.IConnectionListener;
import fr.proline.repository.IDatabaseConnector;
import fr.proline.repository.ProlineDatabaseType;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseConnector
implements IDatabaseConnector,
IConnectionListener {
    private static final String HIBERNATE_PROP_FILES_SUFFIXE = "_hibernate.properties";
    public static final String JDBC_APPNAME_KEY = "ApplicationName";
    public static final String PERSISTENCE_JDBC_DRIVER_KEY = "javax.persistence.jdbc.driver";
    public static final String PERSISTENCE_JDBC_URL_KEY = "javax.persistence.jdbc.url";
    public static final String PERSISTENCE_JDBC_USER_KEY = "javax.persistence.jdbc.user";
    public static final String PERSISTENCE_JDBC_PASSWORD_KEY = "javax.persistence.jdbc.password";
    public static final String PERSISTENCE_VALIDATION_MODE_KEY = "javax.persistence.validation.mode";
    public static final String HIBERNATE_DIALECT_KEY = "hibernate.dialect";
    public static final String HIBERNATE_FETCH_SIZE_KEY = "hibernate.jdbc.fetch_size";
    public static final String HIBERNATE_BATCH_SIZE_KEY = "hibernate.jdbc.batch_size";
    public static final String HIBERNATE_BATCH_VERSIONED_DATA_KEY = "hibernate.jdbc.batch_versioned_data";
    public static final String HIBERNATE_BYTECODE_OPTIMIZER_KEY = "hibernate.bytecode.use_reflection_optimizer";
    public static final String HIBERNATE_IMPLICIT_NAMING_STRATEGY_KEY = "hibernate.implicit_naming_strategy";
    public static final String HIBERNATE_ID_NEW_GENERATOR_MAPPINGS_KEY = "hibernate.id.new_generator_mappings";
    public static final String HIBERNATE_HIKARI_CONNECTION_PROVIDER_CLASS_KEY = "hibernate.connection.provider_class";
    public static final String HIBERNATE_HIKARI_POOL_MIN_IDLE_KEY = "hibernate.hikari.minimumIdle";
    public static final String HIBERNATE_HIKARI_POOL_MAX_SIZE_KEY = "hibernate.hikari.maximumPoolSize";
    public static final String HIBERNATE_HIKARI_POOL_MAX_IDLE_TIME_KEY = "hibernate.hikari.idleTimeout";
    public static final String HIBERNATE_C3PO_POOL_MIN_SIZE_KEY = "hibernate.c3p0.min_size";
    public static final String HIBERNATE_C3PO_POOL_MAX_SIZE_KEY = "hibernate.c3p0.max_size";
    public static final String HIBERNATE_C3PO_POOL_MAX_IDLE_TIME_KEY = "hibernate.c3p0.timeout";
    public static final String HIBERNATE_C3PO_POOL_MAX_STATEMENTS_PER_CON_KEY = "hibernate.c3p0.maxStatementsPerConnection";
    public static final String HIBERNATE_C3PO_POOL_TEST_CON_ON_CHECKIN_KEY = "hibernate.c3p0.testConnectionOnCheckin";
    public static final String HIBERNATE_C3PO_POOL_IDLE_CON_TEST_PERIOD_KEY = "hibernate.c3p0.idle_test_period";
    public static final String HIBERNATE_C3PO__POOL_PREFERRED_TEST_QUERY_KEY = "hibernate.c3p0.preferredTestQuery";
    public static final int DEFAULT_MAX_POOL_CONNECTIONS = 20;
    public static final int DEFAULT_MIN_IDLE_CONNECTIONS = 10;
    public static final int DEFAULT_MAX_IDLE_TIME = 840000;
    public static final String PROLINE_MAX_POOL_CONNECTIONS_KEY = "proline.project.max.pool.connection";
    public static final String JDBC_SCHEME = "jdbc";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDatabaseConnector.class);
    private static final Map<String, Integer> CONNECTOR_INSTANCES = new HashMap<String, Integer>();
    private static final boolean DEFAULT_ORM_OPTIMIZATIONS = true;
    private final ProlineDatabaseType m_prolineDbType;
    private final Map<Object, Object> m_properties;
    private final String m_ident;
    private final Object m_connectorLock = new Object();
    private Map<Object, Object> m_additionalProperties;
    protected DataSource m_dataSource;
    private EntityManagerFactory m_entityManagerFactory;
    private List<EntityManager> m_entityManagers;
    private boolean m_closed;
    private int m_connectionCount = 0;

    protected AbstractDatabaseConnector(ProlineDatabaseType prolineDbType, Map<Object, Object> properties) {
        if (prolineDbType == null) {
            throw new IllegalArgumentException("ProlineDbType is null");
        }
        Properties p = new Properties();
        try {
            File f = new File("config/" + prolineDbType.name() + HIBERNATE_PROP_FILES_SUFFIXE);
            FileReader fr = new FileReader("config/" + prolineDbType.name() + HIBERNATE_PROP_FILES_SUFFIXE);
            p.load(fr);
            LOG.debug(" ------ Read properties file  : " + prolineDbType.name() + "_hibernate.propertiesfrom" + f.getAbsolutePath());
        }
        catch (IOException f) {
            // empty catch block
        }
        Iterator<String> keys = p.stringPropertyNames().iterator();
        HashMap<Object, Object> ap = new HashMap<Object, Object>();
        while (keys.hasNext()) {
            String k = keys.next();
            String res = p.getProperty(k);
            LOG.debug(" ------ add m_additionalProperties IS " + k + " : " + res);
            ap.put(k, res);
        }
        this.setAdditionalProperties(ap);
        this.m_prolineDbType = prolineDbType;
        if (properties == null) {
            throw new IllegalArgumentException("Properties Map is null");
        }
        this.m_properties = new HashMap<Object, Object>(properties);
        StringBuilder identBuffer = new StringBuilder(prolineDbType.getPersistenceUnitName());
        String jdbcURL = PropertiesUtils.getProperty(this.m_properties, (String)PERSISTENCE_JDBC_URL_KEY);
        if (!StringUtils.isEmpty((String)jdbcURL)) {
            identBuffer.append('_').append(jdbcURL.replaceAll(":", "_"));
        }
        this.m_ident = identBuffer.toString();
        int newConnectorInstancesCount = AbstractDatabaseConnector.addConnectorInstances(this.m_ident);
        if (newConnectorInstancesCount > 1) {
            Exception ex = new Exception("Multiple DatabaseConnector");
            LOG.error("There are " + newConnectorInstancesCount + " DatabaseConnector instances for [" + this.m_ident + "]", (Throwable)ex);
        }
    }

    @Override
    public final ProlineDatabaseType getProlineDatabaseType() {
        return this.m_prolineDbType;
    }

    @Override
    public final boolean isMemory() {
        HashMap<Object, Object> propertiesCopy = new HashMap<Object, Object>(this.m_properties);
        return this.isMemory(propertiesCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAdditionalProperties(Map<Object, Object> additionalProperties) {
        Object object = this.m_connectorLock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IllegalStateException("Connector is ALREADY closed");
            }
            if (this.m_dataSource != null) {
                LOG.warn("DataSource ALREADY created : AdditionalProperties IGNORED");
            }
            if (this.m_entityManagerFactory != null) {
                LOG.warn("EntityManagerFactory ALREADY created : AdditionalProperties IGNORED");
            }
            this.m_additionalProperties = additionalProperties == null ? null : new HashMap<Object, Object>(additionalProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object getProperty(Object key) {
        Object result = null;
        Object object = this.m_connectorLock;
        synchronized (object) {
            if (this.m_additionalProperties != null && this.m_additionalProperties.containsKey(key)) {
                result = this.m_additionalProperties.get(key);
            } else if (this.m_properties.containsKey(key)) {
                result = this.m_properties.get(key);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DataSource getDataSource() {
        Object object = this.m_connectorLock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IllegalStateException("Connector is ALREADY closed");
            }
            if (this.m_dataSource == null) {
                ProlineDatabaseType prolineDbType = this.getProlineDatabaseType();
                HashMap<Object, Object> propertiesCopy = new HashMap<Object, Object>(this.m_properties);
                if (this.m_additionalProperties != null && !this.m_additionalProperties.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Creating DataSource with additionalProperties :" + StringUtils.LINE_SEPARATOR + PropertiesUtils.formatProperties(this.m_additionalProperties));
                    }
                    propertiesCopy.putAll(this.m_additionalProperties);
                }
                try {
                    this.m_dataSource = this.createDataSource(this.m_ident, propertiesCopy);
                }
                catch (Exception ex) {
                    String message = "Error creating DataSource for " + prolineDbType;
                    LOG.error(message, (Throwable)ex);
                    throw new RuntimeException(message, ex);
                }
            }
        }
        return this.m_dataSource;
    }

    @Override
    public final Connection createUnmanagedConnection() throws SQLException {
        String jdbcURL = PropertiesUtils.getProperty(this.m_properties, (String)PERSISTENCE_JDBC_URL_KEY);
        String user = PropertiesUtils.getProperty(this.m_properties, (String)PERSISTENCE_JDBC_USER_KEY);
        String password = PropertiesUtils.getProperty(this.m_properties, (String)PERSISTENCE_JDBC_PASSWORD_KEY);
        return DriverManager.getConnection(jdbcURL, user, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final EntityManagerFactory getEntityManagerFactory() {
        Object object = this.m_connectorLock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IllegalStateException("Connector is ALREADY closed");
            }
            if (this.m_entityManagerFactory == null) {
                this.m_entityManagers = new ArrayList<EntityManager>();
                ProlineDatabaseType prolineDbType = this.getProlineDatabaseType();
                HashMap<Object, Object> propertiesCopy = new HashMap<Object, Object>(this.m_properties);
                if (this.m_additionalProperties != null && !this.m_additionalProperties.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Creating EntityManagerFactory with additionalProperties :" + StringUtils.LINE_SEPARATOR + PropertiesUtils.formatProperties(this.m_additionalProperties));
                    }
                    propertiesCopy.putAll(this.m_additionalProperties);
                }
                if (propertiesCopy.get(PERSISTENCE_JDBC_DRIVER_KEY) == null) {
                    propertiesCopy.put(PERSISTENCE_JDBC_DRIVER_KEY, this.getDriverType().getJdbcDriver());
                }
                try {
                    this.m_entityManagerFactory = this.createEntityManagerFactory(this.getProlineDatabaseType(), propertiesCopy, true);
                }
                catch (Exception ex) {
                    String message = "Error creating EntityManagerFactory for " + prolineDbType;
                    LOG.error(message, (Throwable)ex);
                    throw new RuntimeException(message, ex);
                }
            }
        }
        return this.m_entityManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityManager createEntityManager() {
        EntityManager em = this.getEntityManagerFactory().createEntityManager();
        Object object = this.m_connectorLock;
        synchronized (object) {
            this.m_entityManagers.add(em);
        }
        return em;
    }

    @Override
    public int getOpenEntityManagerCount() {
        int openEmCount = 0;
        for (EntityManager m_entityManager : this.m_entityManagers) {
            if (!m_entityManager.isOpen()) continue;
            ++openEmCount;
        }
        return openEmCount;
    }

    @Override
    public int getOpenConnectionCount() {
        return this.m_connectionCount;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.m_ident;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        Object object = this.m_connectorLock;
        synchronized (object) {
            if (!this.m_closed) {
                int remainingConnectorInstancesCount;
                this.m_closed = true;
                if (this.m_entityManagerFactory != null) {
                    if (this.getOpenEntityManagerCount() > 0) {
                        LOG.warn("Some EntityManager instances are still open. Closing the database connector before closing all related EntityManager instances may lead to inconsistent behavior.");
                    }
                    LOG.debug("Closing EntityManagerFactory for [{}]", (Object)this.m_ident);
                    try {
                        this.m_entityManagerFactory.close();
                    }
                    catch (Exception exClose) {
                        LOG.error("Error closing EntityManagerFactory for [" + this.m_ident + "]", (Throwable)exClose);
                    }
                }
                if (this.m_dataSource != null) {
                    this.doClose(this.m_ident, this.m_dataSource);
                }
                if ((remainingConnectorInstancesCount = AbstractDatabaseConnector.removeConnectorInstances(this.m_ident)) > 0) {
                    LOG.error("There are {} remaining DatabaseConnector instances for [{}]", (Object)remainingConnectorInstancesCount, (Object)this.m_ident);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isClosed() {
        boolean result;
        Object object = this.m_connectorLock;
        synchronized (object) {
            result = this.m_closed;
        }
        return result;
    }

    protected boolean isMemory(Map<Object, Object> properties) {
        return false;
    }

    protected abstract DataSource createDataSource(String var1, Map<Object, Object> var2);

    protected EntityManagerFactory createEntityManagerFactory(ProlineDatabaseType prolineDbType, Map<Object, Object> properties, boolean ormOptimizations) {
        if (prolineDbType == null) {
            throw new IllegalArgumentException("Database is null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Properties Map is null");
        }
        if (ormOptimizations) {
            AbstractDatabaseConnector.optimize(properties);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Effective EntityManagerFactory settings for " + prolineDbType + " :" + StringUtils.LINE_SEPARATOR + PropertiesUtils.formatProperties(properties));
        }
        return Persistence.createEntityManagerFactory((String)prolineDbType.getPersistenceUnitName(), properties);
    }

    protected void doClose(String ident, DataSource source) {
        LOG.warn("Closing DatabaseConnector [{}] does not close already retrieved SQL JDBC Connection resources", (Object)ident);
    }

    protected static void enableC3P0Pool(Map<Object, Object> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties Map is null");
        }
        properties.putIfAbsent(HIBERNATE_C3PO_POOL_MIN_SIZE_KEY, "0");
        properties.putIfAbsent(HIBERNATE_C3PO_POOL_MAX_SIZE_KEY, Integer.toString(20));
        properties.putIfAbsent(HIBERNATE_C3PO_POOL_MAX_IDLE_TIME_KEY, "840");
        properties.putIfAbsent(HIBERNATE_C3PO_POOL_MAX_STATEMENTS_PER_CON_KEY, "30");
        properties.putIfAbsent(HIBERNATE_C3PO_POOL_TEST_CON_ON_CHECKIN_KEY, "true");
        properties.putIfAbsent(HIBERNATE_C3PO_POOL_IDLE_CON_TEST_PERIOD_KEY, "300");
    }

    protected static void enableHikariPool(Map<Object, Object> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties Map is null");
        }
        properties.putIfAbsent(HIBERNATE_HIKARI_CONNECTION_PROVIDER_CLASS_KEY, "org.hibernate.hikaricp.internal.HikariCPConnectionProvider");
        properties.putIfAbsent(HIBERNATE_HIKARI_POOL_MIN_IDLE_KEY, Integer.toString(10));
        properties.putIfAbsent(HIBERNATE_HIKARI_POOL_MAX_SIZE_KEY, Integer.toString(20));
        properties.putIfAbsent(HIBERNATE_HIKARI_POOL_MAX_IDLE_TIME_KEY, Integer.toString(840000));
    }

    protected static Integer getMaxPoolConnection(Map<Object, Object> properties) {
        Integer maxConnection = 20;
        if (properties.containsKey(PROLINE_MAX_POOL_CONNECTIONS_KEY)) {
            if (Integer.class.isInstance(properties.get(PROLINE_MAX_POOL_CONNECTIONS_KEY))) {
                maxConnection = (Integer)properties.get(PROLINE_MAX_POOL_CONNECTIONS_KEY);
            } else {
                try {
                    maxConnection = Integer.parseInt((String)properties.get(PROLINE_MAX_POOL_CONNECTIONS_KEY));
                }
                catch (NumberFormatException nfe) {
                    maxConnection = 20;
                }
            }
        }
        return maxConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int addConnectorInstances(String ident) {
        assert (!StringUtils.isEmpty((String)ident)) : "addConnectorInstances() invalid ident";
        int result = 0;
        Map<String, Integer> map = CONNECTOR_INSTANCES;
        synchronized (map) {
            Integer oldCountObj = CONNECTOR_INSTANCES.get(ident);
            int oldCount = 0;
            if (oldCountObj != null) {
                oldCount = oldCountObj;
            }
            if (oldCount < 0) {
                LOG.error("Inconsistent Connector instances count (adding to {}): {}", (Object)ident, (Object)oldCount);
                oldCount = 0;
            }
            result = oldCount + 1;
            CONNECTOR_INSTANCES.put(ident, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int removeConnectorInstances(String ident) {
        assert (!StringUtils.isEmpty((String)ident)) : "removeConnectorInstances() invalid ident";
        int result = 0;
        Map<String, Integer> map = CONNECTOR_INSTANCES;
        synchronized (map) {
            Integer oldCountObj = CONNECTOR_INSTANCES.get(ident);
            int oldCount = 0;
            if (oldCountObj != null) {
                oldCount = oldCountObj;
            }
            if (oldCount <= 0) {
                LOG.error("Inconsistent Connector instances count (removing from {}): {}", (Object)ident, (Object)oldCount);
            } else {
                result = oldCount - 1;
            }
            CONNECTOR_INSTANCES.put(ident, result);
        }
        return result;
    }

    private static void optimize(Map<Object, Object> properties) {
        assert (properties != null) : "optimize() properties is null";
        properties.putIfAbsent(HIBERNATE_IMPLICIT_NAMING_STRATEGY_KEY, "legacy-hbm");
        properties.putIfAbsent(PERSISTENCE_VALIDATION_MODE_KEY, "none");
        properties.putIfAbsent(HIBERNATE_FETCH_SIZE_KEY, "1000");
        properties.putIfAbsent(HIBERNATE_BATCH_SIZE_KEY, "30");
        properties.putIfAbsent(HIBERNATE_BATCH_VERSIONED_DATA_KEY, "true");
        properties.putIfAbsent(HIBERNATE_BYTECODE_OPTIMIZER_KEY, "true");
        properties.putIfAbsent(HIBERNATE_ID_NEW_GENERATOR_MAPPINGS_KEY, "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(ConnectionWrapper connectionWrapper) {
        Object object = this.m_connectorLock;
        synchronized (object) {
            --this.m_connectionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionCreated(Connection connection) {
        Object object = this.m_connectorLock;
        synchronized (object) {
            ++this.m_connectionCount;
        }
    }
}

