/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.repository;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.pool.HikariPool;
import fr.profi.util.PropertiesUtils;
import fr.profi.util.StringUtils;
import fr.proline.repository.AbstractDatabaseConnector;
import fr.proline.repository.DataSourceWrapper;
import fr.proline.repository.DriverType;
import fr.proline.repository.IDatabaseConnector;
import fr.proline.repository.ProlineDatabaseType;
import fr.proline.repository.dialect.TableNameSequencePostgresDialect;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresDatabaseConnector
extends AbstractDatabaseConnector {
    private static final Logger LOG = LoggerFactory.getLogger(PostgresDatabaseConnector.class);
    private static final String HIBERNATE_CONNECTION_KEEPALIVE_KEY = "hibernate.connection.tcpKeepAlive";
    private static final String POSTGRESQL_SCHEME = "jdbc:" + DriverType.POSTGRESQL.getJdbcURLProtocol() + ":";
    private static final AtomicLong NAME_SEQUENCE = new AtomicLong(0L);
    private IDatabaseConnector.ConnectionPoolType m_poolManagementType = IDatabaseConnector.DEFAULT_POOL_TYPE;

    public PostgresDatabaseConnector(ProlineDatabaseType database, Map<Object, Object> properties, IDatabaseConnector.ConnectionPoolType poolManagementType) {
        super(database, properties);
    }

    @Override
    public DriverType getDriverType() {
        return DriverType.POSTGRESQL;
    }

    @Override
    protected DataSource createDataSource(String ident, Map<Object, Object> properties) {
        long start = System.currentTimeMillis();
        if (properties == null) {
            throw new IllegalArgumentException("Properties Map is null");
        }
        String rawDatabaseURL = PropertiesUtils.getProperty(properties, (String)"javax.persistence.jdbc.url");
        if (StringUtils.isEmpty((String)rawDatabaseURL)) {
            throw new IllegalArgumentException("Invalid database URL");
        }
        URI fakeURI = PostgresDatabaseConnector.buildFakeURI(rawDatabaseURL);
        if (fakeURI == null) {
            throw new IllegalArgumentException("Invalid PostgreSQL database URI");
        }
        Integer maxConnection = PostgresDatabaseConnector.getMaxPoolConnection(properties);
        DataSource source = null;
        switch (this.m_poolManagementType) {
            case NO_POOL_MANAGEMENT: {
                source = this.buildSimpleDataSource(ident, properties, fakeURI);
                break;
            }
            case SIMPLE_POOL_MANAGEMENT: {
                source = this.buildC3P0DataSource(ident, properties, fakeURI, maxConnection);
                break;
            }
            case HIGH_PERF_POOL_MANAGEMENT: {
                source = this.buildHikariDataSource(ident, properties, fakeURI, maxConnection);
                break;
            }
        }
        LOG.info("Pool creation duration = " + (System.currentTimeMillis() - start) + " ms for " + this.getProlineDatabaseType());
        return source;
    }

    private DataSource buildSimpleDataSource(String ident, Map<Object, Object> properties, URI fakeURI) {
        String databasePath;
        int serverPort;
        PGSimpleDataSource source = new PGSimpleDataSource();
        String serverName = fakeURI.getHost();
        if (serverName != null) {
            source.setServerNames(new String[]{serverName});
        }
        if ((serverPort = fakeURI.getPort()) != -1) {
            source.setPortNumbers(new int[]{serverPort});
        }
        if ((databasePath = PostgresDatabaseConnector.extractDatabaseName(fakeURI.getPath())) != null) {
            source.setDatabaseName(databasePath);
        }
        source.setApplicationName(PropertiesUtils.getProperty(properties, (String)"ApplicationName"));
        source.setUser(PropertiesUtils.getProperty(properties, (String)"javax.persistence.jdbc.user"));
        source.setPassword(PropertiesUtils.getProperty(properties, (String)"javax.persistence.jdbc.password"));
        return new DataSourceWrapper((DataSource)source, this);
    }

    private DataSource buildC3P0DataSource(String ident, Map<Object, Object> properties, URI fakeURI, Integer maxConnection) {
        String datasourceName = ident + "_" + NAME_SEQUENCE.getAndIncrement();
        ComboPooledDataSource source = new ComboPooledDataSource();
        Properties props = new Properties();
        String appName = PropertiesUtils.getProperty(properties, (String)"ApplicationName");
        if (appName != null) {
            props.put("ApplicationName", appName);
        }
        source.setProperties(props);
        source.setJdbcUrl(PropertiesUtils.getProperty(properties, (String)"javax.persistence.jdbc.url"));
        source.setUser(PropertiesUtils.getProperty(properties, (String)"javax.persistence.jdbc.user"));
        source.setPassword(PropertiesUtils.getProperty(properties, (String)"javax.persistence.jdbc.password"));
        LOG.debug(" buildC3P0DataSource maxConnection " + maxConnection);
        source.setMaxPoolSize(maxConnection.intValue());
        source.setDataSourceName(datasourceName);
        return source;
    }

    private DataSource buildHikariDataSource(String ident, Map<Object, Object> properties, URI fakeURI, Integer maxConnection) {
        String poolName = ident + "_" + NAME_SEQUENCE.getAndIncrement();
        Properties dsProperties = new Properties();
        String appName = PropertiesUtils.getProperty(properties, (String)"ApplicationName");
        if (appName != null) {
            dsProperties.put("ApplicationName", appName);
        }
        HikariConfig config = new HikariConfig();
        config.setDataSourceProperties(dsProperties);
        config.setPoolName(poolName);
        config.setJdbcUrl(PropertiesUtils.getProperty(properties, (String)"javax.persistence.jdbc.url"));
        config.setUsername(PropertiesUtils.getProperty(properties, (String)"javax.persistence.jdbc.user"));
        config.setPassword(PropertiesUtils.getProperty(properties, (String)"javax.persistence.jdbc.password"));
        LOG.debug(" buildHikariDataSource maxConnection " + maxConnection);
        config.setMaximumPoolSize(maxConnection.intValue());
        return new HikariDataSource(config);
    }

    @Override
    protected EntityManagerFactory createEntityManagerFactory(ProlineDatabaseType database, Map<Object, Object> properties, boolean ormOptimizations) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties Map is null");
        }
        if (properties.get("hibernate.dialect") == null) {
            properties.put("hibernate.dialect", TableNameSequencePostgresDialect.class.getName());
        }
        switch (this.m_poolManagementType) {
            case NO_POOL_MANAGEMENT: {
                break;
            }
            case SIMPLE_POOL_MANAGEMENT: {
                PostgresDatabaseConnector.enableC3P0Pool(properties);
                break;
            }
            case HIGH_PERF_POOL_MANAGEMENT: {
                PostgresDatabaseConnector.enableHikariPool(properties);
                Integer maxPool = PostgresDatabaseConnector.getMaxPoolConnection(properties);
                properties.put("hibernate.hikari.maximumPoolSize", maxPool.toString());
                break;
            }
        }
        properties.putIfAbsent(HIBERNATE_CONNECTION_KEEPALIVE_KEY, "true");
        return super.createEntityManagerFactory(database, properties, ormOptimizations);
    }

    @Override
    public int getOpenConnectionCount() {
        if (this.m_dataSource == null) {
            return 0;
        }
        switch (this.m_poolManagementType) {
            case NO_POOL_MANAGEMENT: {
                return super.getOpenConnectionCount();
            }
            case SIMPLE_POOL_MANAGEMENT: {
                try {
                    ComboPooledDataSource poolDS = (ComboPooledDataSource)this.m_dataSource;
                    return poolDS.getNumBusyConnections();
                }
                catch (Exception exClose) {
                    LOG.error("Error counting open connection from DataSource", (Throwable)exClose);
                    return 0;
                }
            }
            case HIGH_PERF_POOL_MANAGEMENT: {
                try {
                    HikariDataSource poolDS = (HikariDataSource)this.m_dataSource;
                    HikariPool pool = this._getHikariDataSourcePool(poolDS);
                    return pool.getActiveConnections();
                }
                catch (Exception exClose) {
                    LOG.error("Error counting open connection from DataSource", (Throwable)exClose);
                    return 0;
                }
            }
        }
        return 0;
    }

    private HikariPool _getHikariDataSourcePool(HikariDataSource dataSource) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field fpool = HikariDataSource.class.getDeclaredField("pool");
        fpool.setAccessible(true);
        return (HikariPool)fpool.get(dataSource);
    }

    @Override
    protected void doClose(String ident, DataSource source) {
        switch (this.m_poolManagementType) {
            case NO_POOL_MANAGEMENT: {
                break;
            }
            case SIMPLE_POOL_MANAGEMENT: {
                LOG.debug("Closing DataSource for [{}]", (Object)ident);
                try {
                    ComboPooledDataSource poolDS = (ComboPooledDataSource)source;
                    LOG.warn("Number of busy connections = " + poolDS.getNumBusyConnections());
                    poolDS.close();
                }
                catch (Exception exClose) {
                    LOG.error("Error closing DataSource for [" + ident + "]", (Throwable)exClose);
                }
                break;
            }
            case HIGH_PERF_POOL_MANAGEMENT: {
                LOG.debug("Closing DataSource for [{}]", (Object)ident);
                try {
                    HikariDataSource poolDS = (HikariDataSource)source;
                    HikariPool pool = this._getHikariDataSourcePool(poolDS);
                    LOG.warn("Number of active connections = " + pool.getActiveConnections());
                    poolDS.close();
                    break;
                }
                catch (Exception exClose) {
                    LOG.error("Error closing DataSource for [" + ident + "]", (Throwable)exClose);
                }
            }
        }
    }

    private static URI buildFakeURI(String rawDatabaseURL) {
        int length;
        int start;
        assert (!StringUtils.isEmpty((String)rawDatabaseURL)) : "buildFakeURI() invalid databaseURL";
        URI result = null;
        String normalizedDatabaseURL = rawDatabaseURL.toLowerCase();
        int index = normalizedDatabaseURL.indexOf(POSTGRESQL_SCHEME);
        if (index != -1 && (start = index + POSTGRESQL_SCHEME.length()) < (length = rawDatabaseURL.length())) {
            String fakeURI = "http:" + rawDatabaseURL.substring(start, length);
            try {
                result = new URI(fakeURI);
            }
            catch (URISyntaxException ex) {
                LOG.error("Unable to parse [" + fakeURI + "] as URI", (Throwable)ex);
            }
        }
        return result;
    }

    private static String extractDatabaseName(String rawDatabasePath) {
        String result = null;
        if (!StringUtils.isEmpty((String)rawDatabasePath)) {
            String[] parts;
            for (String part : parts = rawDatabasePath.split("/")) {
                if (StringUtils.isEmpty((String)part)) continue;
                result = part;
                break;
            }
        }
        return result;
    }
}

