/*
 * Decompiled with CFR 0.152.
 */
package uk.me.berndporr.iirj;

import org.apache.commons.math3.complex.Complex;
import uk.me.berndporr.iirj.ComplexPair;
import uk.me.berndporr.iirj.LayoutBase;
import uk.me.berndporr.iirj.MathSupplement;
import uk.me.berndporr.iirj.PoleZeroPair;

public class BandPassTransform {
    private double wc2;
    private double wc;
    private double a;
    private double b;
    private double a2;
    private double b2;
    private double ab;
    private double ab_2;

    public BandPassTransform(double fc, double fw, LayoutBase digital, LayoutBase analog) {
        digital.reset();
        if (fc < 0.0) {
            throw new ArithmeticException("Cutoff frequency cannot be negative.");
        }
        if (!(fc < 0.5)) {
            throw new ArithmeticException("Cutoff frequency must be less than the Nyquist frequency.");
        }
        double ww = Math.PI * 2 * fw;
        this.wc2 = Math.PI * 2 * fc - ww / 2.0;
        this.wc = this.wc2 + ww;
        if (this.wc2 < 1.0E-8) {
            this.wc2 = 1.0E-8;
        }
        if (this.wc > 3.141592643589793) {
            this.wc = 3.141592643589793;
        }
        this.a = Math.cos((this.wc + this.wc2) * 0.5) / Math.cos((this.wc - this.wc2) * 0.5);
        this.b = 1.0 / Math.tan((this.wc - this.wc2) * 0.5);
        this.a2 = this.a * this.a;
        this.b2 = this.b * this.b;
        this.ab = this.a * this.b;
        this.ab_2 = 2.0 * this.ab;
        int numPoles = analog.getNumPoles();
        int pairs = numPoles / 2;
        for (int i = 0; i < pairs; ++i) {
            PoleZeroPair pair = analog.getPair(i);
            ComplexPair p1 = this.transform(pair.poles.first);
            ComplexPair z1 = this.transform(pair.zeros.first);
            digital.addPoleZeroConjugatePairs(p1.first, z1.first);
            digital.addPoleZeroConjugatePairs(p1.second, z1.second);
        }
        if ((numPoles & 1) == 1) {
            ComplexPair poles = this.transform(analog.getPair((int)pairs).poles.first);
            ComplexPair zeros = this.transform(analog.getPair((int)pairs).zeros.first);
            digital.add(poles, zeros);
        }
        double wn = analog.getNormalW();
        digital.setNormal(2.0 * Math.atan(Math.sqrt(Math.tan((this.wc + wn) * 0.5) * Math.tan((this.wc2 + wn) * 0.5))), analog.getNormalGain());
    }

    private ComplexPair transform(Complex c) {
        if (c.isInfinite()) {
            return new ComplexPair(new Complex(-1.0), new Complex(1.0));
        }
        c = new Complex(1.0).add(c).divide(new Complex(1.0).subtract(c));
        Complex v = new Complex(0.0);
        v = MathSupplement.addmul(v, 4.0 * (this.b2 * (this.a2 - 1.0) + 1.0), c);
        v = v.add(8.0 * (this.b2 * (this.a2 - 1.0) - 1.0));
        v = v.multiply(c);
        v = v.add(4.0 * (this.b2 * (this.a2 - 1.0) + 1.0));
        v = v.sqrt();
        Complex u = v.multiply(-1);
        u = MathSupplement.addmul(u, this.ab_2, c);
        u = u.add(this.ab_2);
        v = MathSupplement.addmul(v, this.ab_2, c);
        v = v.add(this.ab_2);
        Complex d = new Complex(0.0);
        d = MathSupplement.addmul(d, 2.0 * (this.b - 1.0), c).add(2.0 * (1.0 + this.b));
        return new ComplexPair(u.divide(d), v.divide(d));
    }
}

