/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended.xpath;

import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import com.ximpleware.extended.xpath.Expr;

public class UnaryExpr
extends Expr {
    public int op;
    public Expr operand;

    public UnaryExpr(int o, Expr e) {
        this.op = o;
        this.operand = e;
    }

    public String toString() {
        return "-" + this.operand;
    }

    public boolean evalBoolean(VTDNavHuge vn) {
        return this.operand.evalBoolean(vn);
    }

    public double evalNumber(VTDNavHuge vn) {
        return -1.0 * this.operand.evalNumber(vn);
    }

    public int evalNodeSet(VTDNavHuge vn) throws XPathEvalExceptionHuge {
        throw new XPathEvalExceptionHuge("UnaryExpr can't eval to a node set!");
    }

    public String evalString(VTDNavHuge vn) {
        double dval = this.operand.evalNumber(vn);
        if (dval == (double)((int)dval)) {
            return "" + (int)dval;
        }
        return "" + dval;
    }

    public void reset(VTDNavHuge vn) {
        this.operand.reset(vn);
    }

    public boolean isNodeSet() {
        return false;
    }

    public boolean isNumerical() {
        return true;
    }

    public boolean isString() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean requireContextSize() {
        return this.operand.requireContextSize();
    }

    public void setContextSize(int size) {
        this.operand.setContextSize(size);
    }

    public void setPosition(int pos) {
        this.operand.setPosition(pos);
    }

    public int adjust(int n) {
        return 0;
    }
}

