/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.logparser.gui;

import fr.proline.logparser.gui.LogControlPanel;
import fr.proline.logparser.model.LogLineReader;
import fr.proline.logparser.model.ProlineException;
import fr.proline.logparser.model.Utility;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReaderWorker
extends SwingWorker<Long, String>
implements PropertyChangeListener {
    protected static final Logger m_logger = LoggerFactory.getLogger(LogReaderWorker.class);
    List<File> m_fileList;
    File m_currentFile;
    private Utility.DATE_FORMAT m_dateFormat;
    Scanner m_fileScanner;
    JTextPane m_taskFlowPane;
    LogLineReader m_reader;
    StringBuilder m_stringBuilder;
    LogControlPanel m_ctrlLogPanel;
    private long m_fileSize;
    private int m_loadingPercent;
    private long m_loadingLength;
    private boolean m_isStandalon;

    public LogReaderWorker(LogControlPanel logPanel, JTextPane taskFlowTextPane, List<File> fileList, Utility.DATE_FORMAT dateFormat, LogLineReader reader) {
        this.m_taskFlowPane = taskFlowTextPane;
        this.m_ctrlLogPanel = logPanel;
        this.m_fileList = fileList;
        for (File file : this.m_fileList) {
            this.m_fileSize += file.length();
        }
        this.m_loadingLength = 0L;
        this.m_dateFormat = dateFormat;
        String abPath = this.m_fileList.get(0).getAbsolutePath();
        m_logger.debug("absolute path is {}", (Object)abPath);
        this.m_reader = reader;
        this.m_stringBuilder = new StringBuilder();
        this.m_isStandalon = false;
        this.addPropertyChangeListener(this);
    }

    public void setStandalon(boolean b) {
        this.m_isStandalon = b;
    }

    @Override
    protected Long doInBackground() {
        long start = System.currentTimeMillis();
        long index = 0L;
        String regex = "\\d.(\\d+).txt";
        Pattern pattern = Pattern.compile("\\d.(\\d+).txt");
        int fileIndex = -1;
        try {
            this.addTraceBegin(this.m_fileList.get(0).getName());
            this.setProgress(0);
            Iterator<File> iterator = this.m_fileList.iterator();
            while (iterator.hasNext()) {
                String fName;
                Matcher matcher;
                File file;
                this.m_currentFile = file = iterator.next();
                m_logger.debug("Analyse begin...{}", (Object)file.getName());
                if (this.m_fileList.size() > 1 && !this.m_isStandalon && (matcher = pattern.matcher(fName = this.m_currentFile.getName())).find()) {
                    fileIndex = Integer.valueOf(matcher.group(1));
                }
                index = 0L;
                this.m_fileScanner = new Scanner(file, StandardCharsets.UTF_8.name());
                while (this.m_fileScanner.hasNextLine()) {
                    String line = this.m_fileScanner.nextLine();
                    this.m_loadingLength += (long)line.length();
                    this.m_reader.registerTask(fileIndex, line, ++index);
                    if (!this.m_reader.isHasNewTrace()) continue;
                    this.publish(this.m_reader.getNewTrace());
                }
            }
            this.m_reader.memoryClean();
            m_logger.info("Analyse done. {} line in total, {} lines no treated. Total read time is {}", new Object[]{index, this.m_reader.getNoTreatLineCount(), Utility.formatDeltaTime(System.currentTimeMillis() - start)});
            this.m_reader.showNoTreatedLines();
        }
        catch (ProlineException ex) {
            if (ex.getCause() instanceof ParseException) {
                return -1L;
            }
            JOptionPane.showMessageDialog(this.m_taskFlowPane, ex + "\n" + ex.getStackTrace()[0], "Exception", 0);
            StackTraceElement[] trace = ex.getStackTrace();
            Object result = "";
            for (StackTraceElement el : trace) {
                result = (String)result + el.toString() + "\n";
            }
            m_logger.error(ex + "\n" + (String)result);
            m_logger.error(" ProlineException, task register stop at file {}, line {}", (Object)this.m_currentFile.getName(), (Object)index);
        }
        catch (Exception ex) {
            m_logger.error(" Exception task register stop at line {}", (Object)index);
            ex.printStackTrace();
        }
        return index;
    }

    @Override
    protected void process(List<String> trace) {
        for (String line : trace) {
            this.m_stringBuilder.append(line);
        }
        this.m_loadingPercent = (int)Math.floorDiv(this.m_loadingLength * 100L, this.m_fileSize) + 1;
        this.m_taskFlowPane.setText(this.m_stringBuilder.toString());
        this.setProgress(this.m_loadingPercent);
    }

    public int getLoadingPercent() {
        return this.m_loadingPercent;
    }

    public void addTraceBegin(String fileName) {
        this.m_stringBuilder = new StringBuilder("Analyse File: " + fileName + "\n");
        this.m_taskFlowPane.setText(this.m_stringBuilder.toString());
    }

    @Override
    protected void done() {
        try {
            if ((Long)this.get() == -1L) {
                this.m_reader.close();
                this.m_ctrlLogPanel.redo();
            } else {
                this.m_ctrlLogPanel.setProgressBarVisible(false);
                String addition = this.m_fileList.size() > 1 ? " " + this.m_fileList.size() + " debug files" : "";
                this.m_ctrlLogPanel.setData(this.m_reader.getTasks(), this.m_fileList.get(0).getName() + addition);
                this.m_reader.close();
            }
        }
        catch (InterruptedException ex) {
            m_logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (ExecutionException ex) {
            m_logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.m_reader.close();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals("state")) {
            if (evt.getNewValue().toString().equals("STARTED")) {
                this.m_ctrlLogPanel.setProgressBarVisible(true);
            }
        } else if (propertyName.equals("progress")) {
            Integer progress = (Integer)evt.getNewValue();
            this.m_ctrlLogPanel.setProgress(progress);
        }
    }
}

