/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.logparser.gui;

import fr.proline.logparser.gui.ColorPalette;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JPanel;

public class TaskExecutionPanel
extends JPanel {
    private ArrayList<Long> m_xValues;
    private ArrayList<Integer> m_yValues;
    private int m_size;
    private long m_length = 0L;
    private String m_value = "";
    private int m_y0;
    private int m_height;

    public TaskExecutionPanel(int y, int height) {
        this.m_y0 = y;
        this.m_height = height;
    }

    public void setData(ArrayList<Long> xValues, ArrayList<Integer> yValues, String value) {
        this.m_xValues = xValues;
        this.m_yValues = yValues;
        this.m_size = xValues.size();
        if (this.m_size != 0) {
            this.m_length = this.m_xValues.get(this.m_size - 1);
        }
        if (this.m_length == 0L) {
            this.m_length = 1L;
        }
        this.m_value = value;
    }

    public void init() {
        this.m_xValues = null;
    }

    @Override
    public void paint(Graphics g) {
        if (this.m_xValues == null || this.m_size < 1) {
            super.paint(g);
            return;
        }
        this.setOpaque(true);
        super.paint(g);
        long maxLength = this.getWidth() - 10;
        for (int i = 0; i < this.m_size; ++i) {
            long predTimeStamp = i == 0 ? 0L : this.m_xValues.get(i - 1);
            int start = Math.round(5L + predTimeStamp * maxLength / this.m_length);
            int w = Math.round((this.m_xValues.get(i) - predTimeStamp) * maxLength / this.m_length);
            Color color = ColorPalette.pickColor(this.m_yValues.get(i));
            g.setColor(color);
            if (this.m_height == -1) {
                this.m_height = this.getHeight() - 2;
            }
            g.fillRect(start, this.m_y0, w, this.m_height);
        }
        FontMetrics fm = g.getFontMetrics(g.getFont());
        Rectangle2D fb = fm.getStringBounds(this.m_value, g);
        int px = (int)((double)maxLength - fb.getWidth()) / 2;
        int py = (int)fb.getHeight();
        g.setColor(Color.BLACK);
        g.drawString(this.m_value, px, py);
    }

    @Override
    public String toString() {
        String s = this.m_xValues.size() + " ";
        for (int i = 0; i < this.m_xValues.size(); ++i) {
            s = s + ",[" + this.m_xValues.get(i) + "," + this.m_yValues.get(i) + "]";
        }
        return s;
    }
}

