/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.logparser.gui;

import fr.proline.logparser.gui.LogControlPanel;
import fr.proline.logparser.model.LogTask;
import fr.proline.logparser.model.TaskInJsonCtrl;
import fr.proline.logparser.model.Utility;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;

public class TaskLoaderWorker
extends SwingWorker<String, Void> {
    ArrayList<LogTask.LogLine> m_traces;
    int m_nbLine;
    StringBuffer m_stringBuffer;
    LogControlPanel m_ctrl;

    public TaskLoaderWorker(ArrayList<LogTask.LogLine> trace, int nbLine, LogControlPanel ctrl) {
        this.m_ctrl = ctrl;
        this.m_traces = trace;
        this.m_nbLine = nbLine;
        this.m_stringBuffer = new StringBuffer();
    }

    @Override
    protected String doInBackground() throws Exception {
        int maxLine;
        this.m_stringBuffer.setLength(0);
        int traceSize = this.m_traces.size();
        int diffrent = 0;
        if (this.m_ctrl.isBigFile() && (diffrent = traceSize - (maxLine = this.m_ctrl.getMaxLine2Show())) > 0) {
            traceSize = maxLine;
        }
        try {
            for (int i = 0; i < traceSize; ++i) {
                LogTask.LogLine item = this.m_traces.get(i);
                String index = item.fileIndex != -1 ? item.fileIndex + "." + item.index : "" + item.index;
                String lindeIndex = "<font color=\"Gray\">[" + index + "]</font>:";
                String markerLine1 = item.line.replaceAll("<", "&lt;");
                String markerLine2 = markerLine1.replaceAll(">", "&gt;");
                String markerLine3 = this.replaceLogLevelInColor(markerLine2);
                Object markerLine = markerLine3.contains("Calling service") || markerLine3.contains("Calling BytesMessage Service") ? "<font color=\"Blue\">" + markerLine3 + "</font>" : markerLine3;
                this.m_stringBuffer.append("<div>" + lindeIndex + (String)markerLine + "</div>");
                this.m_stringBuffer.length();
            }
            this.m_stringBuffer.append("<div> </div><div>Au total " + traceSize + " lines shown. </div>");
            if (this.m_nbLine > traceSize) {
                String fileName = TaskInJsonCtrl.getInstance().getCurrentFile().getPath();
                diffrent = this.m_nbLine - traceSize;
                this.m_stringBuffer.append("<div> ... </div><div> " + diffrent + " more lines, please refer to the file " + fileName);
            }
            return this.m_stringBuffer.toString();
        }
        catch (OutOfMemoryError e) {
            System.out.println(Utility.getMemory());
            System.out.println(e.getMessage() + "\n" + e.getLocalizedMessage() + "\n" + e.getCause());
            System.exit(1);
            return "";
        }
    }

    private String replaceLogLevelInColor(String srcString) {
        String ds = srcString.replaceAll("DEBUG", "<font color=\"Green\">DEBUG</font>");
        String ws = ds.replaceAll("WARN", "<font color=\"orange\">WARN</font>");
        String es = ws.replaceAll("ERROR", "<font color=\"red\">ERROR</font>");
        String is = es.replaceAll("INFO", "<font color=\"Blue\">INFO</font>");
        return is;
    }

    @Override
    protected void done() {
        try {
            String trace = (String)this.get();
            this.m_ctrl.getConsole().setData(trace);
        }
        catch (InterruptedException ex) {
            this.m_ctrl.getConsole().setData(ex.getMessage());
        }
        catch (ExecutionException ex) {
            this.m_ctrl.getConsole().setData(ex.getMessage());
        }
    }
}

