/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.AbstractContext;
import javolution.osgi.internal.OSGiServices;

public abstract class SecurityContext
extends AbstractContext {
    protected SecurityContext() {
    }

    public static SecurityContext enter() {
        return (SecurityContext)SecurityContext.currentSecurityContext().enterInner();
    }

    public static void check(Permission<?> permission) {
        if (!SecurityContext.currentSecurityContext().isGranted(permission)) {
            throw new SecurityException(permission + " is not granted.");
        }
    }

    public abstract boolean isGranted(Permission<?> var1);

    public abstract void grant(Permission<?> var1, Object var2);

    public abstract void revoke(Permission<?> var1, Object var2);

    public final void grant(Permission<?> permission) {
        this.grant(permission, null);
    }

    public final void revoke(Permission<?> permission) {
        this.revoke(permission, null);
    }

    private static SecurityContext currentSecurityContext() {
        SecurityContext ctx = SecurityContext.current(SecurityContext.class);
        if (ctx != null) {
            return ctx;
        }
        return OSGiServices.getSecurityContext();
    }

    public static class Permission<T> {
        public static final Permission<Object> ALL = new Permission(null);
        private final Class<? super T> category;
        private final String action;
        private final T instance;

        public Permission(Class<? super T> category) {
            this(category, null, null);
        }

        public Permission(Class<? super T> category, String action) {
            this(category, action, null);
        }

        public Permission(Class<? super T> category, String action, T instance) {
            this.category = category;
            this.action = action;
            this.instance = instance;
        }

        public Class<? super T> getCategory() {
            return this.category;
        }

        public String getAction() {
            return this.action;
        }

        public T getInstance() {
            return this.instance;
        }

        public boolean implies(Permission<?> that) {
            if (this.category == null) {
                return true;
            }
            if (!this.category.isAssignableFrom(that.category)) {
                return false;
            }
            if (this.action == null) {
                return true;
            }
            if (!this.action.equals(that.action)) {
                return false;
            }
            if (this.instance == null) {
                return true;
            }
            return this.instance.equals(that.instance);
        }

        public String toString() {
            if (this.category == null) {
                return "All permissions";
            }
            if (this.action == null) {
                return "Permission for any action on " + this.category.getName();
            }
            if (this.instance == null) {
                return "Permission for " + this.action + " on " + this.category.getName();
            }
            return "Permission for " + this.action + " on instance " + this.instance + " of " + this.category.getName();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Permission)) {
                return false;
            }
            Permission that = (Permission)obj;
            if (this.category == null && that.category != null) {
                return false;
            }
            if (this.category != null && !this.category.equals(that.category)) {
                return false;
            }
            if (this.action == null && that.action != null) {
                return false;
            }
            if (this.action != null && !this.action.equals(that.action)) {
                return false;
            }
            if (this.instance == null && that.instance != null) {
                return false;
            }
            if (this.instance != null && !this.instance.equals(that.instance)) {
                return false;
            }
            return false;
        }

        public int hashCode() {
            return (this.category != null ? this.category.hashCode() : 0) + (this.action != null ? this.action.hashCode() : 0) + (this.instance != null ? this.instance.hashCode() : 0);
        }
    }
}

