/*
 * Decompiled with CFR 0.152.
 */
package javolution.context.internal;

import javolution.context.SecurityContext;
import javolution.util.FastTable;

public final class SecurityContextImpl
extends SecurityContext {
    private FastTable<Action> actions = new FastTable();

    @Override
    public boolean isGranted(SecurityContext.Permission<?> permission) {
        boolean isGranted = true;
        for (Action a : this.actions) {
            if (!a.permission.implies(permission)) continue;
            isGranted = a.grant;
        }
        return isGranted;
    }

    @Override
    public void grant(SecurityContext.Permission<?> permission, Object certificate) throws SecurityException {
        Action a = new Action();
        a.grant = true;
        a.permission = permission;
        this.actions.add(a);
    }

    @Override
    public void revoke(SecurityContext.Permission<?> permission, Object certificate) throws SecurityException {
        Action a = new Action();
        a.grant = false;
        a.permission = permission;
        this.actions.add(a);
    }

    @Override
    protected SecurityContext inner() {
        SecurityContextImpl ctx = new SecurityContextImpl();
        ctx.actions.addAll(this.actions);
        return ctx;
    }

    private static class Action {
        boolean grant;
        SecurityContext.Permission<?> permission;

        private Action() {
        }
    }
}

