/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.lang.reflect.Field;
import java.util.Vector;
import javolution.context.LogContext;
import javolution.lang.Configurable;

public class Initializer {
    public static final Configurable<Boolean> SHOW_INITIALIZED = new Configurable<Boolean>(){

        @Override
        protected Boolean getDefault() {
            return false;
        }
    };
    private final ClassLoader classLoader;

    public Initializer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Class<?>[] loadedClasses() {
        Class<?> cls;
        for (cls = this.classLoader.getClass(); cls != ClassLoader.class; cls = cls.getSuperclass()) {
        }
        try {
            Field fldClasses = cls.getDeclaredField("classes");
            fldClasses.setAccessible(true);
            Vector list = (Vector)fldClasses.get(this.classLoader);
            Class[] classes = new Class[list.size()];
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = (Class)list.get(i);
            }
            return classes;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void loadClass(Class<?> cls) {
        try {
            this.classLoader.loadClass(cls.getName());
        }
        catch (ClassNotFoundException e) {
            LogContext.debug("Class " + cls + " not found.");
        }
    }

    public boolean initializeLoadedClasses() {
        boolean isInitializationSuccessful = true;
        int nbrClassesInitialized = 0;
        while (true) {
            Class<?>[] classes;
            if ((classes = this.loadedClasses()) == null) {
                LogContext.debug("Automatic class initialization not supported.");
                return false;
            }
            if (nbrClassesInitialized >= classes.length) break;
            for (int i = nbrClassesInitialized; i < classes.length; ++i) {
                Class<?> cls = classes[i];
                try {
                    if (SHOW_INITIALIZED.get().booleanValue()) {
                        LogContext.debug("Initialize ", cls.getName());
                    }
                    Class.forName(cls.getName(), true, this.classLoader);
                    continue;
                }
                catch (Throwable error) {
                    isInitializationSuccessful = false;
                    LogContext.warning("Class ", cls.getName(), " cannot be initialized.");
                }
            }
            nbrClassesInitialized = classes.length;
        }
        LogContext.debug("Initialization of ", nbrClassesInitialized, " classes loaded by ", this.classLoader);
        return isInitializationSuccessful;
    }
}

