/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import java.io.IOException;
import javolution.lang.MathLib;
import javolution.lang.Realtime;
import javolution.text.Cursor;
import javolution.text.TextBuilder;

@Realtime
public final class TypeFormat {
    private static final int INT_MAX_DIV10 = 0xCCCCCCC;
    private static final long LONG_MAX_DIV10 = 0xCCCCCCCCCCCCCCCL;

    private TypeFormat() {
    }

    public static boolean parseBoolean(CharSequence csq, Cursor cursor) {
        int start = cursor.getIndex();
        int end = csq.length();
        if (end >= start + 5 && (csq.charAt(start) == 'f' || csq.charAt(start) == 'F')) {
            if (!(csq.charAt(++start) != 'a' && csq.charAt(start) != 'A' || csq.charAt(++start) != 'l' && csq.charAt(start) != 'L' || csq.charAt(++start) != 's' && csq.charAt(start) != 'S' || csq.charAt(++start) != 'e' && csq.charAt(start) != 'E')) {
                cursor.increment(5);
                return false;
            }
        } else if (!(end < start + 4 || csq.charAt(start) != 't' && csq.charAt(start) != 'T' || csq.charAt(++start) != 'r' && csq.charAt(start) != 'R' || csq.charAt(++start) != 'u' && csq.charAt(start) != 'U' || csq.charAt(++start) != 'e' && csq.charAt(start) != 'E')) {
            cursor.increment(4);
            return true;
        }
        throw new IllegalArgumentException("Invalid boolean representation");
    }

    public static boolean parseBoolean(CharSequence csq) {
        Cursor cursor = new Cursor();
        boolean result = TypeFormat.parseBoolean(csq, cursor);
        if (!cursor.atEnd(csq)) {
            throw new IllegalArgumentException("Extraneous characters \"" + cursor.tail(csq) + "\"");
        }
        return result;
    }

    public static byte parseByte(CharSequence csq, int radix, Cursor cursor) {
        int i = TypeFormat.parseInt(csq, radix, cursor);
        if (i < -128 || i > 127) {
            throw new NumberFormatException("Overflow");
        }
        return (byte)i;
    }

    public static byte parseByte(CharSequence csq, int radix) {
        Cursor cursor = new Cursor();
        byte result = TypeFormat.parseByte(csq, radix, cursor);
        if (!cursor.atEnd(csq)) {
            throw new IllegalArgumentException("Extraneous characters \"" + cursor.tail(csq) + "\"");
        }
        return result;
    }

    public static byte parseByte(CharSequence csq, Cursor cursor) {
        return TypeFormat.parseByte(csq, 10, cursor);
    }

    public static byte parseByte(CharSequence csq) {
        return TypeFormat.parseByte(csq, 10);
    }

    public static short parseShort(CharSequence csq, int radix, Cursor cursor) {
        int i = TypeFormat.parseInt(csq, radix, cursor);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException("Overflow");
        }
        return (short)i;
    }

    public static short parseShort(CharSequence csq, int radix) {
        Cursor cursor = new Cursor();
        short result = TypeFormat.parseShort(csq, radix, cursor);
        if (!cursor.atEnd(csq)) {
            throw new IllegalArgumentException("Extraneous characters \"" + cursor.tail(csq) + "\"");
        }
        return result;
    }

    public static short parseShort(CharSequence csq, Cursor cursor) {
        return TypeFormat.parseShort(csq, 10, cursor);
    }

    public static short parseShort(CharSequence csq) {
        return TypeFormat.parseShort(csq, 10);
    }

    public static int parseInt(CharSequence csq, int radix, Cursor cursor) {
        int i;
        int start = cursor.getIndex();
        int end = csq.length();
        boolean isNegative = false;
        int result = 0;
        for (i = start; i < end; ++i) {
            int digit;
            char c = csq.charAt(i);
            int n = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (digit = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (digit >= radix || digit < 0 && c != '-' && c != '+') {
                throw new NumberFormatException("Invalid integer representation for " + csq.subSequence(start, end));
            }
            if (digit >= 0 && digit < radix) {
                int newResult = result * radix - digit;
                if (newResult > result) {
                    throw new NumberFormatException("Overflow parsing " + csq.subSequence(start, end));
                }
                result = newResult;
                continue;
            }
            if (c == '-' && i == start) {
                isNegative = true;
                continue;
            }
            if (c != '+' || i != start) break;
        }
        if (result == 0 && (end == 0 || csq.charAt(i - 1) != '0')) {
            throw new NumberFormatException("Invalid integer representation for " + csq.subSequence(start, end));
        }
        if (result == Integer.MIN_VALUE && !isNegative) {
            throw new NumberFormatException("Overflow parsing " + csq.subSequence(start, end));
        }
        cursor.increment(i - start);
        return isNegative ? result : -result;
    }

    public static int parseInt(CharSequence csq, int radix) {
        Cursor cursor = new Cursor();
        int result = TypeFormat.parseInt(csq, radix, cursor);
        if (!cursor.atEnd(csq)) {
            throw new IllegalArgumentException("Extraneous characters \"" + cursor.tail(csq) + "\"");
        }
        return result;
    }

    public static int parseInt(CharSequence csq, Cursor cursor) {
        return TypeFormat.parseInt(csq, 10, cursor);
    }

    public static int parseInt(CharSequence csq) {
        return TypeFormat.parseInt(csq, 10);
    }

    public static long parseLong(CharSequence csq, int radix, Cursor cursor) {
        int i;
        int start = cursor.getIndex();
        int end = csq.length();
        boolean isNegative = false;
        long result = 0L;
        for (i = start; i < end; ++i) {
            int digit;
            char c = csq.charAt(i);
            int n = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (digit = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (digit >= radix || digit < 0 && c != '-' && c != '+') {
                throw new NumberFormatException("Invalid integer representation for " + csq.subSequence(start, end));
            }
            if (digit >= 0 && digit < radix) {
                long newResult = result * (long)radix - (long)digit;
                if (newResult > result) {
                    throw new NumberFormatException("Overflow parsing " + csq.subSequence(start, end));
                }
                result = newResult;
                continue;
            }
            if (c == '-' && i == start) {
                isNegative = true;
                continue;
            }
            if (c != '+' || i != start) break;
        }
        if (result == 0L && (end == 0 || csq.charAt(i - 1) != '0')) {
            throw new NumberFormatException("Invalid integer representation for " + csq.subSequence(start, end));
        }
        if (result == Long.MIN_VALUE && !isNegative) {
            throw new NumberFormatException("Overflow parsing " + csq.subSequence(start, end));
        }
        cursor.increment(i - start);
        return isNegative ? result : -result;
    }

    public static long parseLong(CharSequence csq, int radix) {
        Cursor cursor = new Cursor();
        long result = TypeFormat.parseLong(csq, radix, cursor);
        if (!cursor.atEnd(csq)) {
            throw new IllegalArgumentException("Extraneous characters \"" + cursor.tail(csq) + "\"");
        }
        return result;
    }

    public static long parseLong(CharSequence csq, Cursor cursor) {
        return TypeFormat.parseLong(csq, 10, cursor);
    }

    public static long parseLong(CharSequence csq) {
        return TypeFormat.parseLong(csq, 10);
    }

    public static float parseFloat(CharSequence csq, Cursor cursor) {
        return (float)TypeFormat.parseDouble(csq, cursor);
    }

    public static float parseFloat(CharSequence csq) {
        return (float)TypeFormat.parseDouble(csq);
    }

    public static double parseDouble(CharSequence csq, Cursor cursor) throws NumberFormatException {
        boolean isNegative;
        int start = cursor.getIndex();
        int end = csq.length();
        int i = start;
        char c = csq.charAt(i);
        if (c == 'N' && TypeFormat.match("NaN", csq, i, end)) {
            cursor.increment(3);
            return Double.NaN;
        }
        boolean bl = isNegative = c == '-';
        if ((isNegative || c == '+') && ++i < end) {
            c = csq.charAt(i);
        }
        if (c == 'I' && TypeFormat.match("Infinity", csq, i, end)) {
            cursor.increment(i + 8 - start);
            return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        if ((c < '0' || c > '9') && c != '.') {
            throw new NumberFormatException("Digit or '.' required");
        }
        long decimal = 0L;
        int decimalPoint = -1;
        while (true) {
            int digit;
            if ((digit = c - 48) >= 0 && digit < 10) {
                long tmp = decimal * 10L + (long)digit;
                if (decimal > 0xCCCCCCCCCCCCCCCL || tmp < decimal) {
                    throw new NumberFormatException("Too many digits - Overflow");
                }
                decimal = tmp;
            } else {
                if (c != '.' || decimalPoint >= 0) break;
                decimalPoint = i;
            }
            if (++i >= end) break;
            c = csq.charAt(i);
        }
        if (isNegative) {
            decimal = -decimal;
        }
        int fractionLength = decimalPoint >= 0 ? i - decimalPoint - 1 : 0;
        int exp = 0;
        if (i < end && (c == 'E' || c == 'e')) {
            int digit;
            boolean isNegativeExp;
            boolean bl2 = isNegativeExp = (c = csq.charAt(++i)) == '-';
            if ((isNegativeExp || c == '+') && ++i < end) {
                c = csq.charAt(i);
            }
            if (c < '0' || c > '9') {
                throw new NumberFormatException("Invalid exponent");
            }
            while ((digit = c - 48) >= 0 && digit < 10) {
                int tmp = exp * 10 + digit;
                if (exp > 0xCCCCCCC || tmp < exp) {
                    throw new NumberFormatException("Exponent Overflow");
                }
                exp = tmp;
                if (++i >= end) break;
                c = csq.charAt(i);
            }
            if (isNegativeExp) {
                exp = -exp;
            }
        }
        cursor.increment(i - start);
        return MathLib.toDoublePow10(decimal, exp - fractionLength);
    }

    public static double parseDouble(CharSequence csq) throws NumberFormatException {
        Cursor cursor = new Cursor();
        double result = TypeFormat.parseDouble(csq, cursor);
        if (!cursor.atEnd(csq)) {
            throw new IllegalArgumentException("Extraneous characters \"" + cursor.tail(csq) + "\"");
        }
        return result;
    }

    static boolean match(String str, CharSequence csq, int start, int length) {
        for (int i = 0; i < str.length(); ++i) {
            if (start + i < start + length && csq.charAt(start + i) == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static boolean match(String str, String csq, int start, int length) {
        for (int i = 0; i < str.length(); ++i) {
            if (start + i < start + length && csq.charAt(start + i) == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static Appendable format(boolean b, Appendable a) throws IOException {
        if (a == null) {
            throw new IllegalArgumentException("Appendable Cannot Be Null");
        }
        return b ? a.append("true") : a.append("false");
    }

    public static Appendable format(int i, Appendable a) throws IOException {
        if (a == null) {
            throw new IllegalArgumentException("Appendable Cannot Be Null");
        }
        if (a instanceof TextBuilder) {
            return ((TextBuilder)a).append(i);
        }
        TextBuilder tb = new TextBuilder();
        tb.append(i);
        return a.append(tb);
    }

    public static Appendable format(int i, int radix, Appendable a) throws IOException {
        if (a == null) {
            throw new IllegalArgumentException("Appendable Cannot Be Null");
        }
        if (a instanceof TextBuilder) {
            return ((TextBuilder)a).append(i, radix);
        }
        TextBuilder tb = new TextBuilder();
        tb.append(i, radix);
        return a.append(tb);
    }

    public static Appendable format(long l, Appendable a) throws IOException {
        if (a == null) {
            throw new IllegalArgumentException("Appendable Cannot Be Null");
        }
        if (a instanceof TextBuilder) {
            return ((TextBuilder)a).append(l);
        }
        TextBuilder tb = new TextBuilder();
        tb.append(l);
        return a.append(tb);
    }

    public static Appendable format(long l, int radix, Appendable a) throws IOException {
        if (a == null) {
            throw new IllegalArgumentException("Appendable Cannot Be Null");
        }
        if (a instanceof TextBuilder) {
            return ((TextBuilder)a).append(l, radix);
        }
        TextBuilder tb = new TextBuilder();
        tb.append(l, radix);
        return a.append(tb);
    }

    public static Appendable format(float f, Appendable a) throws IOException {
        if (a == null) {
            throw new IllegalArgumentException("Appendable Cannot Be Null");
        }
        return TypeFormat.format(f, 10, (double)MathLib.abs(f) >= 1.0E7 || (double)MathLib.abs(f) < 0.001, false, a);
    }

    public static Appendable format(double d, Appendable a) throws IOException {
        if (a == null) {
            throw new IllegalArgumentException("Appendable Cannot Be Null");
        }
        return TypeFormat.format(d, -1, MathLib.abs(d) >= 1.0E7 || MathLib.abs(d) < 0.001, false, a);
    }

    public static Appendable format(double d, int digits, boolean scientific, boolean showZero, Appendable a) throws IOException {
        if (a == null) {
            throw new IllegalArgumentException("Appendable Cannot Be Null");
        }
        if (a instanceof TextBuilder) {
            return ((TextBuilder)a).append(d, digits, scientific, showZero);
        }
        TextBuilder tb = new TextBuilder();
        tb.append(d, digits, scientific, showZero);
        return a.append(tb);
    }
}

