/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.collection;

import java.util.Iterator;
import javolution.util.FastSet;
import javolution.util.function.Equality;
import javolution.util.internal.collection.CollectionView;
import javolution.util.service.CollectionService;

public class DistinctCollectionImpl<E>
extends CollectionView<E> {
    private static final long serialVersionUID = 1536L;

    public DistinctCollectionImpl(CollectionService<E> target) {
        super(target);
    }

    @Override
    public boolean add(E element) {
        if (this.target().contains(element)) {
            return false;
        }
        return this.target().add(element);
    }

    @Override
    public void clear() {
        this.target().clear();
    }

    @Override
    public Equality<? super E> comparator() {
        return this.target().comparator();
    }

    @Override
    public boolean contains(Object o) {
        return this.target().contains(o);
    }

    @Override
    public boolean isEmpty() {
        return this.target().isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl();
    }

    @Override
    public boolean remove(Object o) {
        boolean changed = false;
        while (this.remove(o)) {
            changed = true;
        }
        return changed;
    }

    private class IteratorImpl
    implements Iterator<E> {
        private boolean ahead;
        private final FastSet<E> iterated;
        private E next;
        private final Iterator<E> targetIterator;

        private IteratorImpl() {
            this.iterated = new FastSet(DistinctCollectionImpl.this.comparator());
            this.targetIterator = DistinctCollectionImpl.this.target().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.ahead) {
                return true;
            }
            while (this.targetIterator.hasNext()) {
                this.next = this.targetIterator.next();
                if (this.iterated.contains(this.next)) continue;
                this.ahead = true;
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            this.hasNext();
            this.ahead = false;
            return this.next;
        }

        @Override
        public void remove() {
            this.targetIterator.remove();
        }
    }
}

