/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended.xpath;

import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import com.ximpleware.extended.xpath.Expr;

public class LiteralExpr
extends Expr {
    public String s;

    public LiteralExpr(String st) {
        this.s = st;
    }

    public String toString() {
        boolean b = true;
        for (int i = 0; i < this.s.length(); ++i) {
            if (this.s.charAt(i) != '\'') continue;
            b = false;
            break;
        }
        if (b) {
            return "\"" + this.s + "\"";
        }
        return "'" + this.s + "'";
    }

    public boolean evalBoolean(VTDNavHuge vn) {
        return this.s.length() != 0;
    }

    public double evalNumber(VTDNavHuge vn) {
        try {
            double dval = Double.parseDouble(this.s);
            return dval;
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public int evalNodeSet(VTDNavHuge vn) throws XPathEvalExceptionHuge {
        throw new XPathEvalExceptionHuge("LiteralExpr can't eval to a node set!");
    }

    public String evalString(VTDNavHuge vn) {
        return this.s;
    }

    public void reset(VTDNavHuge vn) {
    }

    public boolean isNodeSet() {
        return false;
    }

    public boolean isNumerical() {
        return false;
    }

    public boolean isString() {
        return true;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean requireContextSize() {
        return false;
    }

    public void setContextSize(int size) {
    }

    public void setPosition(int pos) {
    }

    public int adjust(int n) {
        return 0;
    }
}

