/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.data;

import fr.proline.studio.dam.taskinfo.TaskInfo;
import java.util.Date;

public class JMSNotificationMessage {
    private String m_serviceName;
    private String m_serviceVersion;
    private String m_serviceSource;
    private String m_serviceDescr;
    private String m_serviceInfo;
    private Date m_eventTime;
    private String m_jmsMsgId;
    private String m_jsonRPCMsgId;
    private MessageStatus m_eventType;

    public JMSNotificationMessage(String serviceName, String serviceVersion, String serviceSource, String serviceDescription, String serviceInfo, Long eventTimestamp, String jmsMsgId, String jsonRPCId, MessageStatus eventType) {
        this.m_serviceName = serviceName;
        this.m_serviceVersion = serviceVersion;
        this.m_serviceSource = serviceSource;
        this.m_serviceDescr = serviceDescription;
        this.m_jmsMsgId = jmsMsgId;
        this.m_jsonRPCMsgId = jsonRPCId;
        this.m_serviceInfo = serviceInfo;
        this.m_eventType = eventType;
        this.m_eventTime = new Date(eventTimestamp);
    }

    public String getServiceInfo() {
        return this.m_serviceInfo;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public String getServiceDescription() {
        return this.m_serviceDescr;
    }

    public Date getEventDate() {
        return this.m_eventTime;
    }

    public String getServerUniqueMsgId() {
        return this.m_jmsMsgId;
    }

    public String getJsonRPCMsgId() {
        return this.m_jsonRPCMsgId;
    }

    public MessageStatus getEventType() {
        return this.m_eventType;
    }

    public void setEventType(MessageStatus eventType) {
        this.m_eventType = eventType;
    }

    public String getServiceVersion() {
        return this.m_serviceVersion;
    }

    public String getServiceSource() {
        return this.m_serviceSource;
    }

    public Integer getPublicState() {
        return this.m_eventType.getPublicState();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Message ").append(this.getJsonRPCMsgId()).append(" / ").append(this.getServerUniqueMsgId()).append(" : {");
        sb.append(this.getServiceName());
        if (this.m_serviceVersion != null) {
            sb.append(" [Version ").append(this.m_serviceVersion).append("]");
        }
        if (this.m_serviceSource != null) {
            sb.append(" From ").append(this.m_serviceSource);
        }
        return sb.toString();
    }

    public static enum MessageStatus {
        PENDING("Pending", TaskInfo.PUBLIC_STATE_WAITING),
        STARTED("Start", TaskInfo.PUBLIC_STATE_RUNNING),
        ABORTED("Abort", TaskInfo.PUBLIC_STATE_ABORTED),
        SUCCES("Success", TaskInfo.PUBLIC_STATE_FINISHED),
        FAILED("Fail", TaskInfo.PUBLIC_STATE_FAILED);

        String m_value;
        Integer m_publicState;

        private MessageStatus(String value, Integer publicState) {
            this.m_value = value;
            this.m_publicState = publicState;
        }

        public String getValue() {
            return this.m_value;
        }

        public Integer getPublicState() {
            return this.m_publicState;
        }

        public static MessageStatus parseString(String searchedVal) {
            MessageStatus[] allMessageStatus;
            for (MessageStatus nextMessageStatus : allMessageStatus = MessageStatus.values()) {
                if (!nextMessageStatus.m_value.equals(searchedVal)) continue;
                return nextMessageStatus;
            }
            return null;
        }
    }
}

