/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.UserAccount;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.taskinfo.AbstractLongTask;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dock.gui.InfoLabel;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.util.JMSConnectionManager;
import fr.proline.studio.dpm.task.util.JMSMessageUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJMSTask
extends AbstractLongTask
implements MessageListener {
    protected AbstractJMSCallback m_callback;
    protected MessageProducer m_producer = null;
    protected MessageConsumer m_responseConsumer = null;
    protected TemporaryQueue m_replyQueue = null;
    protected JMSState m_currentState = null;
    protected TaskError m_taskError = null;
    protected boolean m_synchronous;
    private int responseTimeout = 10000;
    protected static final Logger m_loggerProline = LoggerFactory.getLogger((String)"ProlineStudio.DPM.Task");
    public static final String TASK_LIST_INFO = "Services JMS";
    protected Session m_session;
    public final AtomicInteger MESSAGE_COUNT_SEQUENCE = new AtomicInteger(0);

    public AbstractJMSTask(AbstractJMSCallback callback, TaskInfo taskInfo) {
        super(taskInfo);
        this.m_callback = callback;
        this.m_synchronous = false;
    }

    public AbstractJMSTask(AbstractJMSCallback callback, boolean synchronous, TaskInfo taskInfo) {
        super(taskInfo);
        this.m_taskInfo = taskInfo;
        this.m_callback = callback;
        this.m_synchronous = synchronous;
    }

    protected void setResponseTimeout(int timeout) {
        this.responseTimeout = timeout;
    }

    public void askJMS() throws JMSException {
        try {
            this.m_session = AccessJMSManagerThread.getAccessJMSManagerThread().getSession();
            this.m_producer = this.m_session.createProducer((Destination)JMSConnectionManager.getJMSConnectionManager().getServiceQueue());
            this.m_replyQueue = this.m_session.createTemporaryQueue();
            this.m_responseConsumer = this.m_session.createConsumer((Destination)this.m_replyQueue);
            if (!this.m_synchronous) {
                this.m_responseConsumer.setMessageListener((MessageListener)this);
            }
            this.m_currentState = JMSState.STATE_WAITING;
            this.taskRun();
            if (this.m_synchronous) {
                Message responseMsg = this.m_responseConsumer.receive((long)this.responseTimeout);
                this.onMessage(responseMsg);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            m_loggerProline.error("Error sending JMS Message", (Throwable)ex);
            this.m_currentState = JMSState.STATE_FAILED;
            this.m_taskError = new TaskError(ex);
            this.callback(false);
        }
    }

    public abstract void taskRun() throws JMSException;

    public void setTaskInfoRequest(String content) throws JMSException {
        this.m_taskInfo.setRequestURL(this.m_producer.getDestination().toString());
        this.m_taskInfo.setRequestContent(content);
    }

    protected void addSupplementaryInfo(Message message, Long projectId) throws JMSException {
        this.addSourceToMessage(message);
        this.addDescriptionToMessage(message);
        this.addProjectIdToMessage(message, projectId);
    }

    protected void addSupplementaryInfo(Message message) throws JMSException {
        this.addSourceToMessage(message);
        this.addDescriptionToMessage(message);
        this.addProjectIdToMessage(message, null);
    }

    protected void addSourceToMessage(Message message) throws JMSException {
        String hostIP;
        StringBuilder userLoginSB = new StringBuilder();
        UserAccount user = DatabaseDataManager.getDatabaseDataManager().getLoggedUser();
        if (user != null) {
            userLoginSB.append(user.getLogin());
        } else {
            userLoginSB.append("Unknown user");
        }
        try {
            hostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhe) {
            hostIP = "Unknown";
        }
        userLoginSB.append(" (host  ").append(hostIP).append(")");
        message.setStringProperty("Proline_ServiceSource", userLoginSB.toString());
    }

    protected void addDescriptionToMessage(Message message) throws JMSException {
        message.setStringProperty("Proline_ServiceDescription", this.m_taskInfo.getTaskDescription());
    }

    protected void addProjectIdToMessage(Message message, Long projectId) throws JMSException {
        Project p;
        String pId = null;
        if (projectId == null && (p = DatabaseDataManager.getDatabaseDataManager().getCurrentProject()) != null) {
            projectId = p.getId();
        }
        if (projectId != null) {
            pId = String.valueOf(projectId);
        }
        message.setStringProperty("Proline_Service_ProjectId", pId);
    }

    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_loggerProline.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            JSONRPC2Response jsonResponse = JSONRPC2Response.parse((String)jsonString, (boolean)false, (boolean)false, (boolean)true);
            m_loggerProline.trace("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                int jsonErrCode = jsonError.getCode();
                if (this.m_synchronous && jsonErrCode == -32003 && this.m_taskInfo.getDuration() <= (long)this.responseTimeout) {
                    jsonError = jsonError.appendMessage("\n Your clock should not be synchronized with Proline Server's one !! ");
                }
                String serviceErr = (String)jsonResponse.getNonStdAttribute("Proline_ServiceName");
                m_loggerProline.error("JSON Error code {}, on serive {},  message : \"{}\"", new Object[]{jsonError.getCode(), serviceErr, jsonError.getMessage()});
                throw jsonError;
            }
            this.processWithResult(jsonResponse);
        }
    }

    public abstract void processWithResult(JSONRPC2Response var1) throws Exception;

    public JMSState getJMSState() {
        return this.m_currentState;
    }

    public final void onMessage(Message jmsMessage) {
        long endRun = System.currentTimeMillis();
        this.m_taskInfo.setDuration(endRun - this.m_taskInfo.getStartTimestamp());
        if (jmsMessage != null) {
            m_loggerProline.info("Receiving message n\u00b0 " + this.MESSAGE_COUNT_SEQUENCE.incrementAndGet() + " : " + JMSMessageUtil.formatMessage(jmsMessage));
            try {
                this.taskDone(jmsMessage);
                if (this.m_taskError == null) {
                    this.m_currentState = JMSState.STATE_DONE;
                }
            }
            catch (JSONRPC2Error jsonErr) {
                this.m_currentState = JMSState.STATE_FAILED;
                m_loggerProline.error("Error handling JMS Message", (Throwable)jsonErr);
                if (jsonErr.getCode() == -32004) {
                    this.m_taskInfo.setAborted();
                }
                this.m_taskError = new TaskError((Exception)((Object)jsonErr));
            }
            catch (Exception e) {
                this.m_currentState = JMSState.STATE_FAILED;
                m_loggerProline.error("Error handling JMS Message", (Throwable)e);
                this.m_taskError = new TaskError(e);
            }
        } else {
            String msg = "Error receiving message n\u00b0 " + this.MESSAGE_COUNT_SEQUENCE.incrementAndGet() + ": timeout should have occured ";
            m_loggerProline.info(msg);
            this.m_currentState = JMSState.STATE_FAILED;
            this.m_taskError = new TaskError((Exception)new RuntimeException(msg));
        }
        try {
            if (jmsMessage != null) {
                jmsMessage.acknowledge();
            }
        }
        catch (JMSException ex) {
            m_loggerProline.error("Error running JMS Message acknowledge", (Throwable)ex);
        }
        if (this.m_currentState == JMSState.STATE_FAILED) {
            this.callback(false);
        } else if (this.m_currentState == JMSState.STATE_DONE) {
            this.callback(true);
        } else {
            this.m_taskError = new TaskError("Task with State not set");
            this.m_currentState = JMSState.STATE_FAILED;
            this.callback(false);
        }
    }

    protected void callback(final boolean success) {
        if (this.m_callback == null) {
            this.getTaskInfo().setFinished(success, this.m_taskError, true);
            return;
        }
        this.m_callback.setTaskInfo(this.m_taskInfo);
        this.m_callback.setTaskError(this.m_taskError);
        if (this.m_callback.mustBeCalledInAWT()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractJMSTask.this.showError(AbstractJMSTask.this.m_taskError);
                    AbstractJMSTask.this.m_callback.run(success);
                    AbstractJMSTask.this.getTaskInfo().setFinished(success, AbstractJMSTask.this.m_taskError, true);
                }
            });
        } else {
            this.showError(this.m_taskError);
            this.m_callback.run(success);
            this.getTaskInfo().setFinished(success, this.m_taskError, true);
        }
    }

    protected void showError(TaskError taskErr) {
        if (taskErr != null) {
            WindowManager.getDefault().getMainWindow().alert(InfoLabel.INFO_LEVEL.ERROR, (Throwable)new Exception(taskErr.getErrorTitle() + "\n" + taskErr.getErrorText()));
        }
    }

    public static enum JMSState {
        STATE_FAILED,
        STATE_WAITING,
        STATE_DONE;

    }
}

