/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.data.ChangeTypicalRule;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class ChangeTypicalProteinTask
extends AbstractJMSTask {
    private DDataset m_dataset;
    private List<ChangeTypicalRule> m_rules;

    public ChangeTypicalProteinTask(AbstractJMSCallback callback, DDataset dataset, List<ChangeTypicalRule> rules) {
        super(callback, new TaskInfo("Change Typical Protein on Identification Summary " + dataset.getName(), true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_dataset = dataset;
        this.m_rules = rules;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", "proline/dps/msi/ChangeTypicalProteinMatch");
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("project_id", this.m_dataset.getProject().getId());
        params.put("result_summary_id", this.m_dataset.getResultSummaryId());
        ArrayList allRules = new ArrayList();
        for (ChangeTypicalRule nextRule : this.m_rules) {
            HashMap<String, Object> ruleParams = new HashMap<String, Object>();
            ruleParams.put("rule_regex", nextRule.getRulePattern());
            ruleParams.put("rule_on_ac", nextRule.getApplyOnAccession());
            allRules.add(ruleParams);
        }
        params.put("change_typical_rules", allRules);
        return params;
    }

    @Override
    public void processWithResult(JSONRPC2Response jsonResponse) throws Exception {
        Object result = jsonResponse.getResult();
        if (result == null || !Boolean.class.isInstance(result)) {
            m_loggerProline.debug("Invalid result");
            throw new Exception("Invalid result " + result);
        }
        m_loggerProline.debug("Result :\n" + result);
    }
}

