/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.data.CVParam;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class ExportDatasetTask
extends AbstractJMSTask {
    private static final String m_serviceName = "proline/dps/msi/ExportResultSummary";
    private static final String m_version = "2.0";
    private final List<DDataset> m_datasetList;
    private final List<String> m_filePathResult;
    private final HashMap<String, Object> m_exportParams;
    private final ExporterFormat m_exportFormat;
    private final String m_configStr;
    private final List<String> m_JMSNodeID;

    public ExportDatasetTask(AbstractJMSCallback callback, List<DDataset> listDataset, String configStr, List<String> filePathInfo, List<String> jmsNodeID) {
        super(callback, new TaskInfo("Export Dataset for " + listDataset.size() + " datasets", true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_datasetList = listDataset;
        this.m_filePathResult = filePathInfo;
        this.m_JMSNodeID = jmsNodeID;
        this.m_exportFormat = ExporterFormat.TEMPLATED;
        this.m_exportParams = null;
        this.m_configStr = configStr;
    }

    public ExportDatasetTask(AbstractJMSCallback callback, List<DDataset> listDataset, String configStr, List<String> filePathInfo, List<String> jmsNodeID, ExporterFormat exportFormat, HashMap<String, Object> exportParams) {
        super(callback, new TaskInfo("Export Dataset for " + listDataset.size() + " datasets", true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_datasetList = listDataset;
        this.m_filePathResult = filePathInfo;
        this.m_JMSNodeID = jmsNodeID;
        this.m_exportFormat = exportFormat;
        this.m_exportParams = exportParams;
        this.m_configStr = configStr;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", m_serviceName);
        message.setStringProperty("Proline_ServiceVersion", m_version);
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    @Override
    public void processWithResult(JSONRPC2Response jsonResponse) throws Exception {
        Object result = jsonResponse.getResult();
        if (result == null || !HashMap.class.isInstance(result)) {
            m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : No valid file path / information returned :" + result);
            throw new Exception("No  file path returned : " + result);
        }
        HashMap returnedValues = (HashMap)result;
        ArrayList exportedFilePathList = (ArrayList)returnedValues.get("file_paths");
        if (exportedFilePathList == null || exportedFilePathList.isEmpty()) {
            m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : No file path returned :" + result);
            throw new Exception("No  file path returned : " + result);
        }
        for (Object filePath : exportedFilePathList) {
            this.m_filePathResult.add((String)filePath);
            this.m_JMSNodeID.add((String)returnedValues.get("Proline_NodeId"));
        }
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("file_format", this.m_exportFormat.toString());
        params.put("output_mode", "STREAM");
        HashMap<String, Object> extraParams = new HashMap<String, Object>();
        switch (this.m_exportFormat) {
            case TEMPLATED: {
                extraParams.put("config", this.m_configStr);
                break;
            }
            case PRIDE: {
                ArrayList<String> additionalsXmlString;
                List additionals;
                HashMap<String, Object> finalExportParams = new HashMap<String, Object>(this.m_exportParams);
                if (this.m_exportParams.containsKey("sample_additional")) {
                    finalExportParams.remove("sample_additional");
                    additionals = (List)this.m_exportParams.get("sample_additional");
                    additionalsXmlString = new ArrayList<String>(additionals.size());
                    for (CVParam nextCVParam : additionals) {
                        additionalsXmlString.add(nextCVParam.toXMLString());
                    }
                    finalExportParams.put("sample_additional", additionalsXmlString);
                }
                if (this.m_exportParams.containsKey("protocol_steps")) {
                    finalExportParams.remove("protocol_steps");
                    additionals = (List)this.m_exportParams.get("protocol_steps");
                    additionalsXmlString = new ArrayList(additionals.size());
                    for (CVParam nextCVParam : additionals) {
                        additionalsXmlString.add(nextCVParam.toXMLString());
                    }
                    finalExportParams.put("protocol_steps", additionalsXmlString);
                }
                extraParams = finalExportParams;
                break;
            }
            case MZIDENTML: 
            case SPECTRA_LIST: {
                if (this.m_exportParams == null) break;
                extraParams.putAll(this.m_exportParams);
            }
        }
        ArrayList rsmIdents = new ArrayList();
        for (DDataset dataset : this.m_datasetList) {
            HashMap<String, Long> rsmIdent = new HashMap<String, Long>();
            rsmIdent.put("project_id", dataset.getProject().getId());
            rsmIdent.put("ds_id", dataset.getId());
            Long rsmId = dataset.getResultSummaryId();
            if (dataset.getMasterQuantitationChannels() != null && !dataset.getMasterQuantitationChannels().isEmpty()) {
                rsmId = ((DMasterQuantitationChannel)dataset.getMasterQuantitationChannels().get(0)).getQuantResultSummaryId();
            }
            rsmIdent.put("rsm_id", rsmId);
            rsmIdents.add(rsmIdent);
        }
        params.put("rsm_identifiers", rsmIdents);
        params.put("extra_params", extraParams);
        return params;
    }

    public static enum ExporterFormat {
        PRIDE,
        TEMPLATED,
        SPECTRA_LIST,
        MZIDENTML;

    }
}

