/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.core.orm.lcms.Peak;
import fr.proline.core.orm.lcms.dto.DFeature;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class ExtractChromatogramTask
extends AbstractJMSTask {
    private static final String m_serviceName = "proline/dps/msq/ExtractChromatogram";
    private final String m_version = "1.0";
    private final ArrayList<DFeature> m_features;
    private final ArrayList<String> m_rawFileIdentifierList;
    private final ArrayList<Double> m_mzList;
    private final double m_ppm;

    public ExtractChromatogramTask(AbstractJMSCallback callback, ArrayList<DFeature> features, ArrayList<String> rawFileIdentifierList, ArrayList<Double> mzList, double ppm) {
        super(callback, new TaskInfo("Extract Chromatograms", false, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_features = features;
        this.m_rawFileIdentifierList = rawFileIdentifierList;
        this.m_mzList = mzList;
        this.m_ppm = ppm;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", m_serviceName);
        this.addSupplementaryInfo((Message)message);
        message.setStringProperty("Proline_ServiceVersion", "1.0");
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("raw_file_identifier", this.m_rawFileIdentifierList);
        params.put("mz", this.m_mzList);
        params.put("ppm", this.m_ppm);
        return params;
    }

    @Override
    public void processWithResult(JSONRPC2Response jsonResponse) throws Exception {
        Object result = jsonResponse.getResult();
        if (result == null || !String.class.isInstance(result)) {
            m_loggerProline.debug("Invalid result: No Chromatogram returned");
            throw new Exception("Invalid result " + result);
        }
        m_loggerProline.debug("Result :\n" + result);
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        Type peakArrayListType = new TypeToken<ArrayList<Peak[]>>(){}.getType();
        ArrayList peakArray = (ArrayList)gson.fromJson((String)result, peakArrayListType);
        for (int i = 0; i < peakArray.size(); ++i) {
            this.m_features.get(i).addPeakArray((Peak[])peakArray.get(i));
        }
    }
}

