/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.serverfilesystem.ServerFile;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class FileSystemBrowseTask
extends AbstractJMSTask {
    private final String m_dirPath;
    private final ArrayList<ServerFile> m_files;

    public FileSystemBrowseTask(AbstractJMSCallback callback, String dirPath, ArrayList<ServerFile> files) {
        super(callback, new TaskInfo("Browse Server File System " + dirPath, true, "Services JMS", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_dirPath = dirPath;
        this.m_files = files;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("retrieve_directory_content", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", "proline/misc/FileSystem");
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("label_path", this.m_dirPath);
        params.put("include_files", Boolean.TRUE);
        params.put("include_dirs", Boolean.TRUE);
        return params;
    }

    @Override
    public void processWithResult(JSONRPC2Response jsonResponse) throws Exception {
        Object result = jsonResponse.getResult();
        if (result == null || !ArrayList.class.isInstance(result)) {
            m_loggerProline.debug("Invalid or no result");
            throw new Exception("null or invalid result " + result);
        }
        ArrayList resultList = (ArrayList)result;
        for (int i = 0; i < resultList.size(); ++i) {
            ServerFile f;
            Map fileMap = (Map)resultList.get(i);
            boolean isDir = (Boolean)fileMap.get("is_dir");
            if (isDir) {
                f = new ServerFile((String)fileMap.get("path"), (String)fileMap.get("name"), true, 0L, 0L);
            } else {
                Long size = fileMap.containsKey("size") ? (Long)fileMap.get("size") : 0L;
                f = new ServerFile((String)fileMap.get("path"), (String)fileMap.get("name"), false, (Long)fileMap.get("lastmodified"), size);
            }
            this.m_files.add(f);
        }
    }
}

