/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.serverfilesystem.RootInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class FileSystemRootsTask
extends AbstractJMSTask {
    ArrayList<RootInfo> m_roots;

    public FileSystemRootsTask(AbstractJMSCallback callback, ArrayList<RootInfo> roots) {
        super(callback, new TaskInfo("Get Server File System Root Paths", true, "Services JMS", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_roots = roots;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("retrieve_all_mount_points", (Object)this.m_taskInfo.getId());
        HashMap params = new HashMap();
        jsonRequest.setNamedParams(params);
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", "proline/misc/FileSystem");
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
    }

    @Override
    public void processWithResult(JSONRPC2Response jsonResponse) throws Exception {
        Object result = jsonResponse.getResult();
        if (result == null || !ArrayList.class.isInstance(result)) {
            String msg = "Server has returned no Root Path. There is a problem with the server installation, please contact your administrator.";
            m_loggerProline.debug(msg);
            throw new Exception("null or invalid result : " + msg);
        }
        ArrayList resultList = (ArrayList)result;
        for (int i = 0; i < resultList.size(); ++i) {
            Map fileMap = (Map)resultList.get(i);
            String label = (String)fileMap.get("label");
            String directoryType = (String)fileMap.get("directory_type");
            this.m_roots.add(new RootInfo(label, directoryType));
        }
    }
}

