/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class GetDBConnectionTemplateTask
extends AbstractJMSTask {
    private static final String m_serviceName = "proline/admin/GetConnectionTemplate";
    private final String m_password;
    private final HashMap<Object, Object> m_databaseProperties;

    public GetDBConnectionTemplateTask(AbstractJMSCallback callback, String password, HashMap<Object, Object> databaseProperties) {
        super(callback, new TaskInfo("Get information from JMS Server ", false, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_password = password;
        this.m_databaseProperties = databaseProperties;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", m_serviceName);
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    @Override
    public void processWithResult(JSONRPC2Response jsonResponse) throws Exception {
        Object result = jsonResponse.getResult();
        if (result == null || !Map.class.isInstance(result)) {
            m_loggerProline.debug("Get DB Connection Template, invalid result. Dabasase Parameters not returned");
            throw new Exception("Get DB Connection Template. Invalid result " + result + " . Dabasase Parameters not returned");
        }
        m_loggerProline.debug("Result :\n" + result);
        Map returnedValues = (Map)result;
        if (returnedValues.isEmpty()) {
            m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : No returned values");
            throw new Exception("No returned values " + result);
        }
        String databaseUser = (String)returnedValues.get("javax.persistence.jdbc.user");
        String databaseDriver = (String)returnedValues.get("javax.persistence.jdbc.driver");
        String databaseURL = (String)returnedValues.get("javax.persistence.jdbc.url");
        if (databaseUser == null || databaseDriver == null || databaseURL == null) {
            m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : Dabasase Parameters uncomplete");
            throw new Exception("Dabasase Parameters uncomplete " + result);
        }
        this.m_databaseProperties.put("javax.persistence.jdbc.user", databaseUser);
        this.m_databaseProperties.put("javax.persistence.jdbc.password", this.m_password);
        this.m_databaseProperties.put("javax.persistence.jdbc.driver", databaseDriver);
        this.m_databaseProperties.put("javax.persistence.jdbc.url", databaseURL);
        this.m_databaseProperties.put("proline.project.max.pool.connection", 3);
    }
}

