/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class ImportIdentificationTask
extends AbstractJMSTask {
    private final String m_parserId;
    private final HashMap<String, String> m_parserArguments;
    private final String m_filePath;
    private final String m_decoyRegex;
    private final long m_instrumentId;
    private final long m_peaklistSoftwareId;
    private final long m_projectId;
    private final long m_fragmentRuleSetId;
    private final boolean m_saveSpectrumMatches;
    private final Long[] m_resultSetId;

    public ImportIdentificationTask(AbstractJMSCallback callback, String parserId, HashMap<String, String> parserArguments, String filePath, String decoyRegex, long instrumentId, long peaklistSoftwareId, boolean saveSpectrumMatches, long fragmRuleSetId, long projectId, Long[] resultSetId) {
        super(callback, new TaskInfo("Import Identification " + filePath, true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_parserId = parserId;
        this.m_parserArguments = parserArguments;
        this.m_filePath = filePath;
        this.m_decoyRegex = decoyRegex;
        this.m_instrumentId = instrumentId;
        this.m_peaklistSoftwareId = peaklistSoftwareId;
        this.m_saveSpectrumMatches = saveSpectrumMatches;
        this.m_projectId = projectId;
        this.m_resultSetId = resultSetId;
        this.m_fragmentRuleSetId = fragmRuleSetId;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", "proline/dps/msi/ImportResultFiles");
        this.addSupplementaryInfo((Message)message, this.m_projectId);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("ImportIdentificationTask Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("project_id", this.m_projectId);
        ArrayList args = new ArrayList();
        HashMap<String, String> resultfile = new HashMap<String, String>();
        resultfile.put("path", this.m_filePath);
        resultfile.put("format", this.m_parserId);
        if (this.m_decoyRegex != null) {
            resultfile.put("decoy_strategy", this.m_decoyRegex);
        }
        args.add(resultfile);
        params.put("result_files", args);
        params.put("instrument_config_id", this.m_instrumentId);
        params.put("peaklist_software_id", this.m_peaklistSoftwareId);
        if (this.m_fragmentRuleSetId > 0L) {
            params.put("fragmentation_rule_set_id", this.m_fragmentRuleSetId);
        }
        params.put("save_spectrum_matches", this.m_saveSpectrumMatches);
        params.put("importer_properties", this.m_parserArguments);
        return params;
    }

    @Override
    public void processWithResult(JSONRPC2Response jsonResponse) throws Exception {
        Object result = jsonResponse.getResult();
        if (result == null || !ArrayList.class.isInstance(result)) {
            m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : No returned values");
            throw new Exception("Invalid result " + result);
        }
        HashMap returnedValuesMap = (HashMap)((ArrayList)result).get(0);
        Long resultSetIdBD = (Long)returnedValuesMap.get("target_result_set_id");
        if (resultSetIdBD == null) {
            m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : No returned ResultSet Id");
            throw new Exception("Import result error : No returned ResultSet Id");
        }
        this.m_resultSetId[0] = resultSetIdBD;
    }
}

