/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import fr.proline.studio.dpm.data.JMSNotificationMessage;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurgeConsumer {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private List<AbstractJMSCallback> m_callbacks = new ArrayList<AbstractJMSCallback>();
    private List<JMSNotificationMessage[]> m_replyVals = new ArrayList<JMSNotificationMessage[]>();
    private static PurgeConsumer m_singleton;

    public static PurgeConsumer getPurgeConsumer() {
        if (m_singleton == null) {
            m_singleton = new PurgeConsumer();
        }
        return m_singleton;
    }

    private PurgeConsumer() {
    }

    public void addCallback(AbstractJMSCallback callback, JMSNotificationMessage[] replyVal) {
        if (callback == null || replyVal == null || replyVal.length != 1) {
            throw new RuntimeException("Must specify callback and reply value pair to register for PurgeConsumer ");
        }
        this.m_callbacks.add(callback);
        this.m_replyVals.add(replyVal);
    }

    public void removeCallback(AbstractJMSCallback callback) {
        int index = this.m_callbacks.indexOf(callback);
        if (index < 0) {
            return;
        }
        this.m_callbacks.remove(index);
        this.m_replyVals.remove(index);
    }

    public void clearMessage(String msgIdToRemove) {
        String selectorString = "JMSMessageID = '" + msgIdToRemove + "'";
    }
}

