/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.core.orm.uds.RawFile;
import fr.proline.core.orm.uds.Run;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.data.RunInfoData;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.io.File;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.persistence.EntityManager;

public class RegisterRawFileTask
extends AbstractJMSTask {
    private static final String m_serviceName = "proline/dps/uds/RegisterRawFile";
    private final String m_raw_file_path;
    private final String m_raw_file_name;
    private final long m_instrumentId;
    private final long m_ownerId;
    private final RunInfoData m_runInfoData;
    private EntityManager entityManagerUDS;

    public RegisterRawFileTask(AbstractJMSCallback callback, long instrumentId, long ownerId, RunInfoData runInfo) {
        super(callback, new TaskInfo("Register raw file " + runInfo.getRawFileOnDisk(), true, "Services JMS", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        String Sep = File.separator;
        String normalizedPath = runInfo.getRawFileOnDisk().getPath();
        if (Sep.equals("\\")) {
            normalizedPath = normalizedPath.replaceAll("\\\\", "/");
        }
        this.m_raw_file_path = normalizedPath;
        this.m_raw_file_name = runInfo.getRawFileOnDisk().getName();
        this.m_ownerId = ownerId;
        this.m_instrumentId = instrumentId;
        this.m_runInfoData = runInfo;
        this.entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();
    }

    @Override
    public void taskRun() throws JMSException {
        try {
            this.entityManagerUDS.getTransaction().begin();
            RawFile rawFile = (RawFile)this.entityManagerUDS.find(RawFile.class, (Object)this.m_raw_file_name);
            if (rawFile != null) {
                Run r = (Run)rawFile.getRuns().get(0);
                this.m_runInfoData.setRun(r);
                return;
            }
            this.entityManagerUDS.getTransaction().commit();
        }
        catch (Exception e) {
            m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed", (Throwable)e);
            try {
                this.entityManagerUDS.getTransaction().rollback();
            }
            catch (Exception rollbackException) {
                m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : potential network problem", (Throwable)rollbackException);
            }
            return;
        }
        finally {
            this.entityManagerUDS.close();
        }
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", m_serviceName);
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String rwFilePath = this.m_raw_file_path;
        int id = rwFilePath.lastIndexOf(".");
        if (id != -1) {
            rwFilePath = rwFilePath.substring(0, id);
        }
        String identifier = this.m_raw_file_name;
        int id2 = this.m_raw_file_name.lastIndexOf(".");
        if (id2 != -1) {
            identifier = this.m_raw_file_name.substring(0, id2);
        }
        params.put("mzdb_file_path", this.m_raw_file_path);
        params.put("raw_file_identifier", identifier);
        params.put("raw_file_path", rwFilePath);
        params.put("instrument_id", this.m_instrumentId);
        params.put("owner_id", this.m_ownerId);
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processWithResult(JSONRPC2Response jsonResponse) throws Exception {
        Object result = jsonResponse.getResult();
        if (result == null || !Long.class.isInstance(result)) {
            m_loggerProline.debug("Invalid result: No runId returned");
            throw new Exception("Invalid result " + result);
        }
        m_loggerProline.debug("Result :\n" + result);
        Long runId = (Long)result;
        this.entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();
        try {
            this.entityManagerUDS.getTransaction().begin();
            Run r = (Run)this.entityManagerUDS.find(Run.class, (Object)runId);
            if (r == null) {
                this.m_taskError = new TaskError("Internal Error : Project not Found");
                return;
            }
            this.m_runInfoData.setRun(r);
            this.m_runInfoData.setLinkedRawFile(r.getRawFile());
            this.entityManagerUDS.getTransaction().commit();
        }
        catch (Exception e) {
            m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed", (Throwable)e);
            try {
                this.entityManagerUDS.getTransaction().rollback();
            }
            catch (Exception rollbackException) {
                m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : potential network problem", (Throwable)rollbackException);
            }
        }
        finally {
            this.entityManagerUDS.close();
        }
    }
}

