/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class SystemInfoTask
extends AbstractJMSTask {
    private static final String m_serviceName = "proline/monitoring/Info";
    private static final String m_version = "1.0";
    private final String[] m_result;

    public SystemInfoTask(AbstractJMSCallback callback, String[] resultLog) {
        super(callback, new TaskInfo("Get Messaging System information", false, "Services JMS", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_result = resultLog;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", m_serviceName);
        message.setStringProperty("Proline_ServiceVersion", m_version);
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    @Override
    public void processWithResult(JSONRPC2Response jsonResponse) throws Exception {
        Object result = jsonResponse.getResult();
        if (result == null || !String.class.isInstance(result)) {
            m_loggerProline.debug("Invalid result");
            throw new Exception("Invalid result " + result);
        }
        this.m_result[0] = result.toString();
    }

    private Map<String, Object> createParams() {
        return new HashMap<String, Object>();
    }
}

