/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import umontreal.ssj.discrepancy.Discrepancy;
import umontreal.ssj.hups.PointSet;

public class DiscL2Unanchored
extends Discrepancy {
    @Override
    public double compute(double[][] points, int n, int s, double[] gamma) {
        return this.compute(points, n, s);
    }

    public DiscL2Unanchored(double[][] points, int n, int s) {
        super(points, n, s);
    }

    public DiscL2Unanchored(int n, int s) {
        super(null, n, s);
    }

    public DiscL2Unanchored(PointSet set) {
        super(set);
    }

    public DiscL2Unanchored() {
    }

    @Override
    public double compute(double[][] points, int n, int s) {
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double prod = 1.0;
            for (int k = 0; k < s; ++k) {
                prod *= points[i][k] * (1.0 - points[i][k]);
            }
            sum += prod;
        }
        double disc = sum / (double)n * (1.0 / (double)n - Math.pow(0.5, s - 1));
        sum = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double prod = 1.0;
                for (int k = 0; k < s; ++k) {
                    prod *= Math.min(points[i][k], points[j][k]) - points[i][k] * points[j][k];
                }
                sum += prod;
            }
        }
        disc += 2.0 * sum / (double)((long)n * (long)n);
        if ((disc += Math.pow(0.08333333333333333, s)) < 0.0) {
            return -1.0;
        }
        return Math.sqrt(disc);
    }

    @Override
    public double compute(double[] T, int n) {
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += T[i] * (1.0 - T[i]);
        }
        double disc = -(1.0 - 1.0 / (double)n) * sum / (double)n;
        double sum2 = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                sum2 += Math.min(T[i], T[j]) - T[i] * T[j];
            }
        }
        disc += 2.0 * sum2 / (double)((long)n * (long)n);
        if ((disc += 0.08333333333333333) < 0.0) {
            return -1.0;
        }
        return Math.sqrt(disc);
    }
}

