/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.mcqmctools.anova;

import java.util.List;
import umontreal.ssj.mcqmctools.MonteCarloModel;
import umontreal.ssj.mcqmctools.anova.CoordinateSet;
import umontreal.ssj.mcqmctools.anova.CoordinateSetLong;
import umontreal.ssj.mcqmctools.anova.MonteCarloModelDoubleRQMC;
import umontreal.ssj.mcqmctools.anova.SplitStream;
import umontreal.ssj.rng.RandomStream;

public class PartialVarianceEstimator
implements MonteCarloModel<double[]> {
    protected MonteCarloModelDoubleRQMC model;
    protected double approxMean;
    protected List<CoordinateSet> coordSets;
    protected CoordinateSet noCoordinate;
    protected CoordinateSet allCoordinates;
    protected double[] vars;

    public PartialVarianceEstimator() {
        this.model = null;
        this.coordSets = null;
        this.approxMean = 0.0;
        this.vars = null;
    }

    public PartialVarianceEstimator(MonteCarloModelDoubleRQMC model, double approxMean, List<CoordinateSet> coordSets) {
        this.setModel(model, approxMean);
        this.setCoordinateSets(coordSets);
        this.vars = null;
    }

    public MonteCarloModelDoubleRQMC getModel() {
        return this.model;
    }

    public void setModel(MonteCarloModelDoubleRQMC model, double approxMean) {
        this.model = model;
        this.approxMean = approxMean;
    }

    public List<CoordinateSet> getCoordinateSets() {
        return this.coordSets;
    }

    public void setCoordinateSets(List<CoordinateSet> coordSets) {
        this.coordSets = coordSets;
        this.noCoordinate = new CoordinateSetLong(0L);
        this.allCoordinates = new CoordinateSetLong(-1L);
    }

    public double getApproximateMean() {
        return this.approxMean;
    }

    @Override
    public void simulate(RandomStream stream) {
        if (this.vars == null || this.vars.length != this.coordSets.size() + 2) {
            this.vars = new double[this.coordSets.size() + 2];
        }
        if (this.model == null) {
            throw new IllegalArgumentException("model has not been initialized");
        }
        if (this.coordSets == null) {
            throw new IllegalArgumentException("the coordinate sets have not been initialized");
        }
        int nSets = this.coordSets.size();
        if (this.vars.length < nSets + 2) {
            throw new IllegalArgumentException("vars[] must contain one more element than the number of coordinate sets");
        }
        SplitStream s = new SplitStream(stream, this.model.getDimension());
        s.setCoordinates(this.allCoordinates);
        s.resetStartSubstream();
        this.model.simulate(s);
        double valAll = this.model.getPerformance() - this.approxMean;
        s.setCoordinates(this.noCoordinate);
        s.resetStartSubstream();
        this.model.simulate(s);
        double valNone = this.model.getPerformance() - this.approxMean;
        this.vars[nSets] = valAll;
        this.vars[nSets + 1] = valAll * valAll;
        for (int j = 0; j < nSets; ++j) {
            s.setCoordinates(this.coordSets.get(j));
            s.resetStartSubstream();
            this.model.simulate(s);
            double valPartial = this.model.getPerformance() - this.approxMean;
            this.vars[j] = valAll * (valPartial - valNone);
        }
    }

    @Override
    public double[] getPerformance() {
        return this.vars;
    }

    public int getDimension() {
        return this.model == null ? 0 : 2 * this.model.getDimension();
    }

    @Override
    public String toString() {
        String s = String.format("Partial Variance Estimator [model=%s]", this.model.toString());
        return s;
    }
}

