/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.ChiDist;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

public class ChiGen
extends RandomVariateGen {
    protected int nu = -1;

    public ChiGen(RandomStream s, int nu) {
        super(s, new ChiDist(nu));
        this.setParams(nu);
    }

    public ChiGen(RandomStream s, ChiDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getNu());
        }
    }

    public static double nextDouble(RandomStream s, int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        return ChiDist.inverseF(nu, s.nextDouble());
    }

    public int getNu() {
        return this.nu;
    }

    protected void setParams(int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        this.nu = nu;
    }
}

