/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.LaplaceDist;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

public class LaplaceGen
extends RandomVariateGen {
    private double mu;
    private double beta;

    public LaplaceGen(RandomStream s, double mu, double beta) {
        super(s, new LaplaceDist(mu, beta));
        this.setParams(mu, beta);
    }

    public LaplaceGen(RandomStream s) {
        this(s, 0.0, 1.0);
    }

    public LaplaceGen(RandomStream s, LaplaceDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getMu(), dist.getBeta());
        }
    }

    public static double nextDouble(RandomStream s, double mu, double beta) {
        return LaplaceDist.inverseF(mu, beta, s.nextDouble());
    }

    public double getMu() {
        return this.mu;
    }

    public double getBeta() {
        return this.beta;
    }

    protected void setParams(double mu, double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.mu = mu;
        this.beta = beta;
    }
}

