/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvarmulti;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import umontreal.ssj.probdist.NormalDist;
import umontreal.ssj.randvar.NormalGen;
import umontreal.ssj.randvarmulti.MultinormalGen;

public class MultinormalCholeskyGen
extends MultinormalGen {
    private void initL() {
        if (this.mu.length != this.sigma.rows() || this.mu.length != this.sigma.columns()) {
            throw new IllegalArgumentException("Incompatible mean vector and covariance matrix");
        }
        CholeskyDecomposition decomp = new CholeskyDecomposition(this.sigma);
        this.sqrtSigma = decomp.getL();
    }

    public MultinormalCholeskyGen(NormalGen gen1, double[] mu, double[][] sigma) {
        super(gen1, mu, sigma);
        this.initL();
    }

    public MultinormalCholeskyGen(NormalGen gen1, double[] mu, DoubleMatrix2D sigma) {
        super(gen1, mu, sigma);
        this.initL();
    }

    public DoubleMatrix2D getCholeskyDecompSigma() {
        return this.sqrtSigma.copy();
    }

    public void setSigma(DoubleMatrix2D sigma) {
        if (sigma.rows() != this.mu.length || sigma.columns() != this.mu.length) {
            throw new IllegalArgumentException("Invalid dimensions of covariance matrix");
        }
        CholeskyDecomposition decomp = new CholeskyDecomposition(sigma);
        this.sigma.assign(sigma);
        this.sqrtSigma = decomp.getL();
    }

    public static void nextPoint(NormalGen gen1, double[] mu, double[][] sigma, double[] p) {
        MultinormalCholeskyGen.nextPoint(gen1, mu, new DenseDoubleMatrix2D(sigma), p);
    }

    public static void nextPoint(NormalGen gen1, double[] mu, DoubleMatrix2D sigma, double[] p) {
        int i;
        if (gen1 == null) {
            throw new NullPointerException("gen1 is null");
        }
        NormalDist dist = (NormalDist)gen1.getDistribution();
        if (dist.getMu() != 0.0) {
            throw new IllegalArgumentException("mu != 0");
        }
        if (dist.getSigma() != 1.0) {
            throw new IllegalArgumentException("sigma != 1");
        }
        if (mu.length != sigma.rows() || mu.length != sigma.columns()) {
            throw new IllegalArgumentException("Incompatible mean vector and covariance matrix dimensions");
        }
        CholeskyDecomposition decomp = new CholeskyDecomposition(sigma);
        double[] temp = new double[mu.length];
        DoubleMatrix2D sqrtSigma = decomp.getL();
        for (i = 0; i < temp.length; ++i) {
            temp[i] = gen1.nextDouble();
            if (temp[i] == Double.NEGATIVE_INFINITY) {
                temp[i] = -37.54;
            }
            if (temp[i] != Double.POSITIVE_INFINITY) continue;
            temp[i] = 37.54;
        }
        for (i = 0; i < temp.length; ++i) {
            p[i] = 0.0;
            for (int c = 0; c <= i; ++c) {
                int n = i;
                p[n] = p[n] + sqrtSigma.getQuick(i, c) * temp[c];
            }
            int n = i;
            p[n] = p[n] + mu[i];
        }
    }

    @Override
    public void nextPoint(double[] p) {
        int i;
        int n = this.mu.length;
        for (i = 0; i < n; ++i) {
            this.temp[i] = this.gen1.nextDouble();
            if (this.temp[i] == Double.NEGATIVE_INFINITY) {
                this.temp[i] = -37.54;
            }
            if (this.temp[i] != Double.POSITIVE_INFINITY) continue;
            this.temp[i] = 37.54;
        }
        for (i = 0; i < n; ++i) {
            p[i] = 0.0;
            for (int c = 0; c <= i; ++c) {
                int n2 = i;
                p[n2] = p[n2] + this.sqrtSigma.getQuick(i, c) * this.temp[c];
            }
            int n3 = i;
            p[n3] = p[n3] + this.mu[i];
        }
    }
}

