/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat;

import umontreal.ssj.stat.TallyHistogram;
import umontreal.ssj.util.PrintfFormat;

public class HistogramOnly
extends TallyHistogram
implements Cloneable {
    public HistogramOnly(double a, double b, int s) {
        super(a, b, s);
    }

    public HistogramOnly(String name, double a, double b, int s) {
        super(a, b, s);
        this.name = name;
    }

    @Override
    public void init() {
        this.numObs = 0;
        for (int i = 0; i < this.numBins; ++i) {
            this.count[i] = 0;
        }
    }

    @Override
    public void add(double x) {
        ++this.numObs;
        if (x >= this.m_a & x <= this.m_b) {
            int n = (int)((x - this.m_a) / this.m_h);
            this.count[n] = this.count[n] + 1;
        }
    }

    @Override
    public double sum() {
        throw new IllegalStateException("HistogramOnly.variance() is not supported.");
    }

    @Override
    public double average() {
        throw new IllegalStateException("HistogramOnly.variance() is not supported.");
    }

    @Override
    public double variance() {
        throw new IllegalStateException("HistogramOnly.variance() is not supported.");
    }

    @Override
    public HistogramOnly clone() {
        HistogramOnly image = (HistogramOnly)super.clone();
        return image;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("---------------------------------------" + PrintfFormat.NEWLINE);
        sb.append(this.name + PrintfFormat.NEWLINE);
        sb.append("Interval = [ " + this.m_a + ", " + this.m_b + " ]" + PrintfFormat.NEWLINE);
        sb.append("Number of bins = " + this.numBins + PrintfFormat.NEWLINE);
        sb.append(PrintfFormat.NEWLINE + "Counters = {" + PrintfFormat.NEWLINE);
        for (int i = 0; i < this.numBins; ++i) {
            double a = this.m_a + (double)(i - 1) * this.m_h;
            double b = this.m_a + (double)i * this.m_h;
            sb.append("   (" + PrintfFormat.f(6, 3, a) + ", " + PrintfFormat.f(6, 3, b) + ")    " + this.count[i] + PrintfFormat.NEWLINE);
        }
        sb.append("}" + PrintfFormat.NEWLINE);
        return sb.toString();
    }

    @Override
    public String report() {
        throw new IllegalStateException("HistogramOnly.report() is not supported.");
    }

    @Override
    public String shortReport() {
        throw new IllegalStateException("HistogramOnly.shortReport() is not supported.");
    }

    @Override
    public String shortReportHeader() {
        throw new IllegalStateException("HistogramOnly.shortReportHeader() is not supported.");
    }
}

