/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.table;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.db.model.params.param.CVTerm;
import fr.profi.mzdb.db.table.CVTermTable;
import fr.profi.mzdb.io.reader.table.AbstractTableModelReader;
import fr.profi.mzdb.util.sqlite.ISQLiteRecordExtraction;
import fr.profi.mzdb.util.sqlite.SQLiteQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvTermReader
extends AbstractTableModelReader<CVTerm> {
    final Logger logger = LoggerFactory.getLogger(CvTermReader.class);

    public CvTermReader(SQLiteConnection connection) {
        super(connection);
    }

    @Override
    protected ISQLiteRecordExtraction<CVTerm> buildRecordExtractor() {
        return record -> {
            String accession = record.columnString(CVTermTable.ACCESSION);
            String name = record.columnString(CVTermTable.NAME);
            String unitAcc = record.columnString(CVTermTable.UNIT_ACCESSION);
            String cvId = record.columnString(CVTermTable.CV_ID);
            return new CVTerm(accession, name, unitAcc, cvId);
        };
    }

    public CVTerm getCvTerm(String accession) throws SQLiteException {
        return (CVTerm)new SQLiteQuery(this.connection, "SELECT * FROM " + CVTerm.TABLE_NAME + " WHERE id = ?").bind(1, accession).extractRecord(this.recordExtractor);
    }

    public List<CVTerm> getCvTerms() throws SQLiteException {
        return this.getRecordList(CVTerm.TABLE_NAME);
    }
}

