/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.misc;

import java.io.IOException;
import org.knowm.xchart.BitmapEncoder;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.colors.XChartSeriesColors;
import org.knowm.xchart.style.lines.SeriesLines;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class Plotting {
    private XYChart figure;
    private XYChartBuilder plot;
    private int hlineCount = 1;
    private int vlineCount = 1;

    public Plotting() {
        this.plot = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(600)).height(500)).theme(Styler.ChartTheme.Matlab)).xAxisTitle("X").yAxisTitle("Y");
    }

    public Plotting(String title) {
        this.plot = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(600)).height(500)).theme(Styler.ChartTheme.Matlab)).title(title)).xAxisTitle("X").yAxisTitle("Y");
    }

    public Plotting(String title, String x_axis, String y_axis) {
        this.plot = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(600)).height(500)).theme(Styler.ChartTheme.Matlab)).title(title)).xAxisTitle(x_axis).yAxisTitle(y_axis);
    }

    public Plotting(int width, int height, String title, String x_axis, String y_axis) {
        this.plot = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(width)).height(height)).theme(Styler.ChartTheme.Matlab)).title(title)).xAxisTitle(x_axis).yAxisTitle(y_axis);
    }

    public void initialisePlot() {
        this.figure = this.plot.build();
        ((XYStyler)this.figure.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Line);
        ((XYStyler)this.figure.getStyler()).setLegendPosition(Styler.LegendPosition.OutsideS);
    }

    public void addSignal(String name, double[] x, double[] y, boolean marker) {
        XYSeries s = this.figure.addSeries(name, x, y);
        s.setLineWidth(0.75f);
        if (!marker) {
            s.setMarker(SeriesMarkers.NONE);
        }
    }

    public void addSignal(String name, double[] y, boolean marker) {
        XYSeries s = this.figure.addSeries(name, y);
        s.setLineWidth(0.75f);
        if (!marker) {
            s.setMarker(SeriesMarkers.NONE);
        }
    }

    public void addSignal(String name, double[] y, boolean marker, String line_type) {
        XYSeries s = this.figure.addSeries(name, y);
        s.setLineWidth(0.5f);
        if (!marker) {
            s.setMarker(SeriesMarkers.NONE);
        }
        if (line_type.equals("-")) {
            s.setLineStyle(SeriesLines.SOLID);
        } else if (line_type.equals(".")) {
            s.setLineStyle(SeriesLines.DOT_DOT);
        } else if (line_type.equals("--")) {
            s.setLineStyle(SeriesLines.DASH_DASH);
        } else if (line_type.equals("-.")) {
            s.setLineStyle(SeriesLines.DASH_DOT);
        }
    }

    public void addSignal(String name, double[] x, double[] y, boolean marker, String line_type) {
        XYSeries s = this.figure.addSeries(name, x, y);
        s.setLineWidth(0.75f);
        if (!marker) {
            s.setMarker(SeriesMarkers.NONE);
        }
        if (line_type.equals("-")) {
            s.setLineStyle(SeriesLines.SOLID);
        } else if (line_type.equals(".")) {
            s.setLineStyle(SeriesLines.DOT_DOT);
        } else if (line_type.equals("--")) {
            s.setLineStyle(SeriesLines.DASH_DASH);
        } else if (line_type.equals("-.")) {
            s.setLineStyle(SeriesLines.DASH_DOT);
        }
    }

    public void addPoints(String name, double[] x, double[] y) {
        XYSeries s = this.figure.addSeries(name, x, y);
        s.setXYSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        s.setMarker(SeriesMarkers.CIRCLE);
    }

    public void addPoints(String name, int[] x, double[] y) {
        double[] x_new = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            x_new[i] = x[i];
        }
        this.addPoints(name, x_new, y);
    }

    public void addPoints(String name, double[] x, double[] y, char marker) {
        XYSeries s = this.figure.addSeries(name, x, y);
        s.setXYSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        if (marker == 'x') {
            s.setMarker(SeriesMarkers.CROSS);
        } else if (marker == 'o') {
            s.setMarker(SeriesMarkers.CIRCLE);
        } else if (marker == '*') {
            s.setMarker(SeriesMarkers.DIAMOND);
        } else if (marker == '+') {
            s.setMarker(SeriesMarkers.PLUS);
        } else if (marker == '#') {
            s.setMarker(SeriesMarkers.SQUARE);
        } else if (marker == '^') {
            s.setMarker(SeriesMarkers.TRIANGLE_UP);
        }
    }

    public void addPoints(String name, int[] x, double[] y, char marker) {
        double[] x_new = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            x_new[i] = x[i];
        }
        this.addPoints(name, x_new, y, marker);
    }

    public void hline(double x_min, double x_max, double y) {
        double[] x_plot = new double[]{x_min, x_max};
        double[] y_plot = new double[]{y, y};
        XYSeries s = this.figure.addSeries("Horizontal" + this.hlineCount, x_plot, y_plot);
        ++this.hlineCount;
        s.setLineColor(XChartSeriesColors.BLACK);
        s.setMarker(SeriesMarkers.NONE);
        s.setLineStyle(SeriesLines.DASH_DASH);
        s.setShowInLegend(false);
        s.setXYSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Line);
    }

    public void vline(double x, double y_min, double y_max) {
        double[] x_plot = new double[]{x, x};
        double[] y_plot = new double[]{y_min, y_max};
        XYSeries s = this.figure.addSeries("Vertical" + this.vlineCount, x_plot, y_plot);
        ++this.vlineCount;
        s.setLineColor(XChartSeriesColors.BLACK);
        s.setMarker(SeriesMarkers.NONE);
        s.setLineStyle(SeriesLines.DASH_DASH);
        s.setShowInLegend(false);
        s.setXYSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Line);
    }

    public void plot() {
        new SwingWrapper((Chart)this.figure).displayChart();
    }

    public void saveAsPNG(String name) throws IOException, IllegalArgumentException {
        String extension = name.substring(name.length() - 4);
        if (!extension.equals(".png")) {
            throw new IllegalArgumentException("Filename must have PNG extension");
        }
        String filename = name.substring(0, name.length() - 4);
        BitmapEncoder.saveBitmapWithDPI((Chart)this.figure, (String)filename, (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG, (int)300);
    }
}

