/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.signal;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import org.apache.commons.math3.util.MathArrays;

public class Convolution {
    private double[] signal;
    private double[] kernel;
    private double[] output;

    public Convolution(double[] signal, double[] window) {
        this.signal = signal;
        this.kernel = window;
        this.output = null;
    }

    public double[] convolve() {
        this.output = MathArrays.convolve((double[])this.signal, (double[])this.kernel);
        return this.output;
    }

    public double[] convolve(String mode) {
        double[] temp = MathArrays.convolve((double[])this.signal, (double[])this.kernel);
        if (mode.equals("full")) {
            this.output = temp;
        } else if (mode.equals("same")) {
            this.output = new double[this.signal.length];
            int iterator = Math.abs(temp.length - this.signal.length) / 2;
            for (int i = 0; i < this.output.length; ++i) {
                this.output[i] = temp[iterator];
                ++iterator;
            }
        } else if (mode.equals("valid")) {
            this.output = new double[this.signal.length - this.kernel.length + 1];
            int iterator = this.kernel.length - 1;
            for (int i = 0; i < this.output.length; ++i) {
                this.output[i] = temp[iterator];
                ++iterator;
            }
        } else {
            throw new IllegalArgumentException("convolve modes can only be full, same or valid");
        }
        return this.output;
    }

    private double[] convolve(double[] sig, double[] w) {
        double[] output = MathArrays.convolve((double[])sig, (double[])w);
        return output;
    }

    public double[] convolve1d(String mode) {
        if (!(mode.equals("reflect") || mode.equals("constant") || mode.equals("nearest") || mode.equals("mirror") || mode.equals("wrap"))) {
            throw new IllegalArgumentException("convolve1d modes can only be reflect, constant, nearest mirror, or wrap");
        }
        int startVal = this.signal.length + this.kernel.length / 2;
        double[] newSignal = UtilMethods.padSignal(this.signal, mode);
        double[] temp = this.convolve(newSignal, this.kernel);
        double[] output = UtilMethods.splitByIndex(temp, startVal, startVal + this.signal.length);
        return output;
    }

    public double[] convolve1d() throws IllegalArgumentException {
        int startVal = this.signal.length + this.kernel.length / 2;
        double[] newSignal = UtilMethods.padSignal(this.signal, "reflect");
        double[] temp = this.convolve(newSignal, this.kernel);
        double[] output = UtilMethods.splitByIndex(temp, startVal, startVal + this.signal.length);
        return output;
    }
}

