/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.signal;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.transform.DiscreteFourier;
import com.github.psambit9791.jdsp.transform.InverseDiscreteFourier;
import java.util.Arrays;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public class Deconvolution {
    private double[] signal;
    private double[] kernel;
    private final int sig_len;
    private final int ker_len;

    public Deconvolution(double[] signal, double[] window) {
        this.sig_len = signal.length;
        this.ker_len = window.length;
        this.kernel = window;
        this.signal = signal;
    }

    private void preprocess_dft() {
        int shape = Math.max(this.signal.length, this.kernel.length);
        double[] padding = new double[shape - Math.min(this.signal.length, this.kernel.length)];
        Arrays.fill(padding, 0.0);
        if (this.signal.length < shape) {
            this.signal = UtilMethods.concatenateArray(this.signal, padding);
        } else if (this.kernel.length < shape) {
            this.kernel = UtilMethods.concatenateArray(this.kernel, padding);
        }
    }

    private double[] deconvolve_dft() {
        this.preprocess_dft();
        DiscreteFourier ffts = new DiscreteFourier(this.signal);
        ffts.transform();
        DiscreteFourier fftk = new DiscreteFourier(this.kernel);
        fftk.transform();
        Complex[] s = ffts.getComplex(false);
        Complex[] w = fftk.getComplex(false);
        Complex[] s_w = new Complex[s.length];
        for (int i = 0; i < s_w.length; ++i) {
            s_w[i] = s[i].divide(w[i].add(1.1754943508222875E-38));
        }
        InverseDiscreteFourier idf = new InverseDiscreteFourier(UtilMethods.complexTo2D(s_w), false);
        idf.transform();
        return Arrays.copyOfRange(UtilMethods.round(idf.getReal(), 3), 0, this.sig_len - this.ker_len + 1);
    }

    private double[] deconvolve_ola() {
        RealVector soln;
        int start_point;
        double[][] matA = new double[this.sig_len][this.sig_len];
        double[] krn_temp = UtilMethods.padSignal(UtilMethods.reverse(this.kernel), "constant", this.sig_len - 1);
        int index = 0;
        for (int i = start_point = this.ker_len / 2 + this.sig_len - 1; i >= start_point - this.sig_len + 1; --i) {
            matA[index] = UtilMethods.splitByIndex(krn_temp, i, i + this.sig_len);
            ++index;
        }
        try {
            DecompositionSolver solver = new LUDecomposition(MatrixUtils.createRealMatrix((double[][])matA)).getSolver();
            soln = solver.solve((RealVector)new ArrayRealVector(this.signal, false));
        }
        catch (SingularMatrixException e) {
            DecompositionSolver solver = new SingularValueDecomposition(MatrixUtils.createRealMatrix((double[][])matA)).getSolver();
            soln = solver.solve((RealVector)new ArrayRealVector(this.signal, false));
        }
        return UtilMethods.round(soln.toArray(), 3);
    }

    public double[] deconvolve(String mode) {
        double[] out;
        if (mode.equals("full")) {
            out = this.deconvolve_dft();
        } else if (mode.equals("same")) {
            out = this.deconvolve_ola();
        } else {
            throw new IllegalArgumentException("mode has to be one of 'full' or 'same'.");
        }
        return out;
    }
}

