/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.splines;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import org.apache.commons.math3.analysis.interpolation.AkimaSplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;

public class AkimaSpline {
    private PolynomialSplineFunction psf = null;

    public PolynomialSplineFunction getFunction() {
        if (this.psf == null) {
            throw new ExceptionInInitializerError("Execute computeFunction() before calling this function");
        }
        return this.psf;
    }

    public void computeFunction(double[] x, double[] y) {
        if (!UtilMethods.isSorted(x, false)) {
            throw new IllegalArgumentException("X-coordinates must be increasing");
        }
        AkimaSplineInterpolator aks = new AkimaSplineInterpolator();
        this.psf = aks.interpolate(x, y);
    }

    public double getValue(double x) {
        if (this.psf == null) {
            throw new ExceptionInInitializerError("Execute computeFunction() before calling this function");
        }
        if (!this.psf.isValidPoint(x)) {
            throw new IllegalArgumentException("Point has to be within the interpolating range");
        }
        return this.psf.value(x);
    }

    public double[] getValue(double[] x) {
        if (this.psf == null) {
            throw new ExceptionInInitializerError("Execute computeFunction() before calling this function");
        }
        double[] out = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            if (!this.psf.isValidPoint(x[i])) {
                throw new IllegalArgumentException("Point at index " + i + "has to be within the interpolating range");
            }
            out[i] = this.psf.value(x[i]);
        }
        return out;
    }
}

