/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.transform;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.transform._Fourier;
import java.util.Arrays;
import org.apache.commons.math3.complex.Complex;

public class DiscreteFourier
implements _Fourier {
    private double[] signal;
    private Complex[] output = null;

    public DiscreteFourier(double[] s) {
        this.signal = s;
    }

    @Override
    public int getSignalLength() {
        return this.signal.length;
    }

    @Override
    public double[] getFFTFreq(int Fs, boolean onlyPositive) {
        double[] results;
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute transform() function before returning FFT bins");
        }
        double val = (double)Fs / (double)this.signal.length;
        if (onlyPositive) {
            int N = this.signal.length / 2 + 1;
            int[] p1 = UtilMethods.arange(0, N, 1);
            results = Arrays.stream(p1).asDoubleStream().toArray();
        } else {
            int N = (this.signal.length - 1) / 2 + 1;
            int[] p1 = UtilMethods.arange(0, N, 1);
            int[] p2 = UtilMethods.arange(-(this.signal.length / 2), 0, 1);
            results = Arrays.stream(UtilMethods.concatenateArray(p1, p2)).asDoubleStream().toArray();
        }
        results = UtilMethods.scalarArithmetic(results, val, "mul");
        return results;
    }

    @Override
    public void transform() {
        Complex[] out = new Complex[this.signal.length];
        for (int k = 0; k < out.length; ++k) {
            double real = 0.0;
            double imag = 0.0;
            for (int t = 0; t < out.length; ++t) {
                double angle = Math.PI * 2 * (double)t * (double)k / (double)out.length;
                real += this.signal[t] * Math.cos(angle);
                imag += -this.signal[t] * Math.sin(angle);
            }
            out[k] = new Complex(real, imag);
        }
        this.output = out;
    }

    @Override
    public double[] getMagnitude(boolean onlyPositive) throws ExceptionInInitializerError {
        Complex[] dftout = this.getComplex(onlyPositive);
        return Arrays.stream(dftout).mapToDouble(Complex::abs).toArray();
    }

    @Override
    public double[] getPhaseRad(boolean onlyPositive) throws ExceptionInInitializerError {
        Complex[] dftout = this.getComplex(onlyPositive);
        return Arrays.stream(dftout).mapToDouble(Complex::getArgument).toArray();
    }

    @Override
    public double[] getPhaseDeg(boolean onlyPositive) throws ExceptionInInitializerError {
        double[] dftout = this.getPhaseRad(onlyPositive);
        return Arrays.stream(dftout).map(Math::toDegrees).toArray();
    }

    @Override
    public double[][] getMagPhaseRad(boolean onlyPositive) throws ExceptionInInitializerError {
        double[] dftMag = this.getMagnitude(onlyPositive);
        double[] dftPhase = this.getPhaseRad(onlyPositive);
        double[][] out = new double[dftMag.length][2];
        for (int i = 0; i < out.length; ++i) {
            out[i][0] = dftMag[i];
            out[i][1] = dftPhase[i];
        }
        return out;
    }

    @Override
    public double[][] getMagPhaseDeg(boolean onlyPositive) throws ExceptionInInitializerError {
        double[] dftMag = this.getMagnitude(onlyPositive);
        double[] dftPhase = this.getPhaseDeg(onlyPositive);
        double[][] out = new double[dftMag.length][2];
        for (int i = 0; i < out.length; ++i) {
            out[i][0] = dftMag[i];
            out[i][1] = dftPhase[i];
        }
        return out;
    }

    @Override
    public double[][] getComplex2D(boolean onlyPositive) throws ExceptionInInitializerError {
        Complex[] dftout = this.getComplex(onlyPositive);
        return UtilMethods.complexTo2D(dftout);
    }

    @Override
    public Complex[] getComplex(boolean onlyPositive) throws ExceptionInInitializerError {
        Complex[] dftout;
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute transform() function before returning result");
        }
        if (onlyPositive) {
            int numBins = this.output.length / 2 + 1;
            dftout = new Complex[numBins];
        } else {
            dftout = new Complex[this.output.length];
        }
        System.arraycopy(this.output, 0, dftout, 0, dftout.length);
        return dftout;
    }
}

