/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.windows;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.windows._Window;

public class Bohman
extends _Window {
    private double[] window;
    private final boolean sym;
    private final int len;

    public Bohman(int len, boolean sym) throws IllegalArgumentException {
        super(len);
        this.len = len;
        this.sym = sym;
        this.generateWindow();
    }

    public Bohman(int len) throws IllegalArgumentException {
        this(len, true);
    }

    private void generateWindow() {
        int tempLen = super.extend(this.len, this.sym);
        this.window = UtilMethods.linspace(-1, 1, tempLen, true);
        for (int i = 0; i < this.window.length; ++i) {
            double fac = Math.abs(this.window[i]);
            this.window[i] = (1.0 - fac) * Math.cos(Math.PI * fac) + 0.3183098861837907 * Math.sin(Math.PI * fac);
        }
        this.window[0] = 0.0;
        this.window[tempLen - 1] = 0.0;
        this.window = super.truncate(this.window);
    }

    @Override
    public double[] getWindow() {
        return this.window;
    }
}

