/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.windows;

import com.github.psambit9791.jdsp.misc.UtilMethods;

public abstract class _Window {
    private boolean extendVal;

    public _Window(int len) {
        if (this.lenGuard(len)) {
            throw new IllegalArgumentException("Window Length must be greater than 0");
        }
    }

    public boolean lenGuard(int length) {
        return length <= 0;
    }

    public int extend(int length, boolean sym) {
        if (!sym) {
            this.extendVal = true;
            return length + 1;
        }
        this.extendVal = false;
        return length;
    }

    public double[] truncate(double[] arr) {
        if (this.extendVal) {
            return UtilMethods.splitByIndex(arr, 0, arr.length - 1);
        }
        return arr;
    }

    public abstract double[] getWindow();

    public double[] applyWindow(double[] input) {
        double[] window = this.getWindow();
        if (window == null) {
            throw new NullPointerException("Window not initialized");
        }
        if (input.length != window.length) {
            throw new IllegalArgumentException("Input data dimensions and window dimensions don't match");
        }
        double[] out = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            out[i] = input[i] * window[i];
        }
        return out;
    }

    public double[] applyInverseWindow(double[] input) {
        double[] window = this.getWindow();
        double[] out = new double[input.length];
        boolean dataLost = false;
        if (window == null) {
            throw new NullPointerException("Window not initialized");
        }
        if (input.length != window.length) {
            throw new IllegalArgumentException("Input data dimensions and window dimensions don't match");
        }
        for (int i = 0; i < input.length; ++i) {
            if (window[i] == 0.0) {
                dataLost = true;
                continue;
            }
            out[i] = input[i] / window[i];
        }
        if (dataLost) {
            System.err.println("The original window function contained a zero-element, which causes some of the data to be irretrievably lost.");
        }
        return out;
    }
}

