/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.writer;

import fr.profi.mzdb.model.SpectrumData;

public class SpectrumSliceIndex {
    private SpectrumData spectrumData;
    private float firstPeakIdx;
    private float lastPeakIdx;

    public SpectrumSliceIndex(SpectrumData spectrumData, float firstPeakIdx, float lastPeakIdx) {
        this.spectrumData = spectrumData;
        this.firstPeakIdx = firstPeakIdx;
        this.lastPeakIdx = lastPeakIdx;
    }

    public SpectrumData getSpectrumData() {
        return this.spectrumData;
    }

    public float getFirstPeakIdx() {
        return this.firstPeakIdx;
    }

    public float getLastPeakIdx() {
        return this.lastPeakIdx;
    }

    protected int peaksCount() {
        if (!(this.lastPeakIdx >= this.firstPeakIdx)) {
            throw new IllegalArgumentException("invalid pair of firstPeakIdx/lastPeakIdx (" + this.firstPeakIdx + "," + this.lastPeakIdx + ")");
        }
        return (int)(1.0f + this.lastPeakIdx - this.firstPeakIdx);
    }

    public void setLastPeakIdx(int i) {
        this.lastPeakIdx = i;
    }
}

